/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module.alloying;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NonNullConsumer;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.transfer.TransferUtil;
import slimeknights.mantle.transfer.fluid.EmptyFluidHandler;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;

public class MixerAlloyTank
implements IMutableAlloyTank {
    private final MantleBlockEntity parent;
    private final IFluidHandler outputTank;
    private int temperature = 0;
    private final Map<class_2350, LazyOptional<IFluidHandler>> inputs = new EnumMap<class_2350, LazyOptional<IFluidHandler>>(class_2350.class);
    private final Map<class_2350, NonNullConsumer<LazyOptional<IFluidHandler>>> listeners = new EnumMap<class_2350, NonNullConsumer<LazyOptional<IFluidHandler>>>(class_2350.class);
    @Nullable
    private IFluidHandler[] indexedList = null;
    private boolean needsRefresh = true;
    private int currentTanks = 0;

    @Override
    public int getTanks() {
        this.checkTanks();
        return this.currentTanks;
    }

    private IFluidHandler[] indexTanks() {
        if (this.indexedList == null) {
            this.indexedList = new IFluidHandler[this.currentTanks];
            if (this.currentTanks > 0) {
                int nextTank = 0;
                for (class_2350 direction : class_2350.values()) {
                    LazyOptional<IFluidHandler> handler;
                    if (direction == class_2350.field_11033 || !(handler = this.inputs.getOrDefault(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty())).isPresent()) continue;
                    this.indexedList[nextTank] = (IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE);
                    ++nextTank;
                }
            }
        }
        return this.indexedList;
    }

    public IFluidHandler getFluidHandler(int tank) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return EmptyFluidHandler.INSTANCE;
        }
        return this.indexTanks()[tank];
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return FluidStack.EMPTY;
        }
        return this.indexTanks()[tank].getFluidInTank(0);
    }

    @Override
    public FluidStack drain(int tank, FluidStack fluidStack) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return FluidStack.EMPTY;
        }
        return this.indexTanks()[tank].drain(fluidStack, false);
    }

    @Override
    public boolean canFit(FluidStack fluid, int removed) {
        this.checkTanks();
        return this.outputTank.fill(fluid, true) == fluid.getAmount();
    }

    @Override
    public long fill(FluidStack fluidStack) {
        return this.outputTank.fill(fluidStack, false);
    }

    private void checkTanks() {
        class_1937 world = this.parent.method_10997();
        if (world == null) {
            return;
        }
        if (this.needsRefresh) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 target;
                if (direction == class_2350.field_11033 || this.inputs.containsKey(direction) || !world.method_8320(target = this.parent.method_11016().method_10093(direction)).method_26164(TinkerTags.Blocks.ALLOYER_TANKS)) continue;
                class_2586 te = world.method_8321(target);
                if (te != null) {
                    LazyOptional capability = TransferUtil.getFluidHandler((class_2586)te, (class_2350)direction.method_10153());
                    if (capability.isPresent()) {
                        capability.addListener(this.listeners.computeIfAbsent(direction, dir -> new WeakConsumerWrapper((Object)this, (self, handler) -> {
                            if (handler == self.inputs.get(dir)) {
                                this.refresh((class_2350)dir, false);
                            }
                        })));
                        this.inputs.put(direction, (LazyOptional<IFluidHandler>)capability);
                        ++this.currentTanks;
                        continue;
                    }
                    this.inputs.put(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty());
                    continue;
                }
                this.inputs.put(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty());
            }
            this.needsRefresh = false;
        }
    }

    public void refresh(class_2350 direction, boolean checkInput) {
        if (direction == class_2350.field_11033) {
            return;
        }
        if (!checkInput || this.inputs.containsKey(direction) && this.inputs.get(direction).isPresent()) {
            --this.currentTanks;
        }
        this.inputs.remove(direction);
        this.needsRefresh = true;
        this.indexedList = null;
    }

    public MixerAlloyTank(MantleBlockEntity parent, IFluidHandler outputTank) {
        this.parent = parent;
        this.outputTank = outputTank;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }
}

