/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.multiblock;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockCuboid;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockStructureData;

public abstract class HeatingStructureMultiblock<T extends MantleBlockEntity>
extends MultiblockCuboid<StructureData> {
    private static final String TAG_TANKS = "tanks";
    private static final String TAG_INSIDE_CHECK = "insideCheck";
    protected final T parent;
    protected final List<class_2338> tanks = new ArrayList<class_2338>();

    public HeatingStructureMultiblock(T parent, boolean hasFloor, boolean hasFrame, boolean hasCeiling, int maxHeight, int innerLimit) {
        super(hasFloor, hasFrame, hasCeiling, maxHeight, innerLimit);
        this.parent = parent;
    }

    public HeatingStructureMultiblock(T parent, boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        super(hasFloor, hasFrame, hasCeiling);
        this.parent = parent;
    }

    @Override
    public StructureData create(class_2338 min, class_2338 max, Set<class_2338> extraPos) {
        this.tanks.removeIf(pos -> !MultiblockStructureData.isWithin(pos, min, max));
        return new StructureData(min, max, extraPos, this.hasFloor, this.hasFrame, this.hasCeiling, (List<class_2338>)ImmutableList.copyOf(this.tanks));
    }

    public StructureData createClient(class_2338 min, class_2338 max, List<class_2338> tanks) {
        return new StructureData(min, max, Collections.emptySet(), this.hasFloor, this.hasFrame, this.hasCeiling, tanks);
    }

    @Override
    public StructureData detectMultiblock(class_1937 world, class_2338 master, class_2350 facing) {
        this.tanks.clear();
        return (StructureData)super.detectMultiblock(world, master, facing);
    }

    @Override
    @Nullable
    public StructureData readFromTag(class_2487 nbt) {
        this.tanks.clear();
        this.tanks.addAll(HeatingStructureMultiblock.readPosList(nbt, TAG_TANKS));
        return (StructureData)super.readFromTag(nbt);
    }

    protected boolean isValidSlave(class_1937 world, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        if (te instanceof IServantLogic) {
            return ((IServantLogic)te).isValidMaster((IMasterLogic)this.parent);
        }
        return true;
    }

    public boolean canExpand(StructureData data, class_1937 world) {
        class_2338 min = data.getMinPos();
        class_2338 to = data.getMaxPos().method_10084();
        MultiblockResult result = this.detectLayer(world, new class_2338(min.method_10263(), to.method_10264(), min.method_10260()), to, pos -> {});
        this.setLastResult(result);
        return result.isSuccess();
    }

    protected abstract boolean isValidBlock(class_2248 var1);

    protected abstract boolean isValidFloor(class_2248 var1);

    protected abstract boolean isValidTank(class_2248 var1);

    protected abstract boolean isValidWall(class_2248 var1);

    @Override
    protected boolean isValidBlock(class_1937 world, class_2338 pos, MultiblockCuboid.CuboidSide side, boolean isFrame) {
        if (pos.equals((Object)this.parent.method_11016())) {
            return true;
        }
        if (!this.isValidSlave(world, pos)) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        if (side == MultiblockCuboid.CuboidSide.FLOOR && !isFrame) {
            return this.isValidFloor(state.method_26204());
        }
        if (this.isValidTank(state.method_26204())) {
            this.tanks.add(pos.method_10062());
            return true;
        }
        return this.isValidWall(state.method_26204());
    }

    @Override
    public boolean shouldUpdate(class_1937 world, MultiblockStructureData structure, class_2338 pos, class_2680 state) {
        if (structure.withinBounds(pos)) {
            if (structure.contains(pos)) {
                return !this.isValidBlock(state.method_26204());
            }
            return structure.isInside(pos) && !state.method_26215();
        }
        return structure.isDirectlyAbove(pos) && this.isValidWall(state.method_26204());
    }

    public static class StructureData
    extends MultiblockStructureData {
        private final List<class_2338> tanks;
        private class_2338 insideCheck;

        protected StructureData(class_2338 minPos, class_2338 maxPos, Set<class_2338> extraPositions, boolean hasFloor, boolean hasFrame, boolean hasCeiling, List<class_2338> tanks) {
            super(minPos, maxPos, extraPositions, hasFloor, hasFrame, hasCeiling);
            this.tanks = tanks;
        }

        public boolean hasTanks() {
            return !this.tanks.isEmpty();
        }

        private class_2338 getNextInsideCheck(@Nullable class_2338 prev) {
            class_2338 min = this.getMinInside();
            if (prev == null) {
                return min;
            }
            if (prev.method_10263() < min.method_10263() || prev.method_10264() < min.method_10264() || prev.method_10260() < min.method_10260()) {
                return min;
            }
            class_2338 max = this.getMaxInside();
            if (prev.method_10260() >= max.method_10260()) {
                if (prev.method_10263() >= max.method_10263()) {
                    if (prev.method_10264() >= max.method_10264()) {
                        return min;
                    }
                    return new class_2338(min.method_10263(), prev.method_10264() + 1, min.method_10260());
                }
                return new class_2338(prev.method_10263() + 1, prev.method_10264(), min.method_10260());
            }
            return prev.method_10069(0, 0, 1);
        }

        public class_2338 getNextInsideCheck() {
            this.insideCheck = this.getNextInsideCheck(this.insideCheck);
            return this.insideCheck;
        }

        public int getPerimeterCount() {
            class_2338 min = this.getMinInside();
            class_2338 max = this.getMaxInside();
            int dx = max.method_10263() - min.method_10263();
            int dy = max.method_10264() - min.method_10264();
            int dz = max.method_10260() - min.method_10260();
            return 2 * (dx * dy) + 2 * (dy * dz) + dx * dz;
        }

        @Override
        public class_2487 writeClientTag() {
            class_2487 nbt = super.writeClientTag();
            nbt.method_10566(HeatingStructureMultiblock.TAG_TANKS, (class_2520)StructureData.writePosList(this.tanks));
            return nbt;
        }

        @Override
        public class_2487 writeToTag() {
            class_2487 nbt = super.writeToTag();
            if (this.insideCheck != null) {
                nbt.method_10566(HeatingStructureMultiblock.TAG_INSIDE_CHECK, (class_2520)TagUtil.writePos(this.insideCheck));
            }
            return nbt;
        }

        public List<class_2338> getTanks() {
            return this.tanks;
        }
    }
}

