/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.multiblock;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockStructureData;

public abstract class MultiblockCuboid<T extends MultiblockStructureData> {
    protected static final MultiblockResult NO_ATTEMPT = MultiblockResult.error(null, (class_2561)TConstruct.makeTranslation("multiblock", "generic.no_attempt"));
    protected static final MultiblockResult NOT_LOADED = MultiblockResult.error(null, (class_2561)TConstruct.makeTranslation("multiblock", "generic.not_loaded"));
    protected static final MultiblockResult TOO_HIGH = MultiblockResult.error(null, (class_2561)TConstruct.makeTranslation("multiblock", "generic.too_high"));
    protected static final class_2561 INVALID_INNER_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_inner_block");
    protected static final String TOO_LARGE = TConstruct.makeTranslationKey("multiblock", "generic.too_large");
    protected static final class_2561 INVALID_FLOOR_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_block");
    protected static final class_2561 INVALID_CEILING_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_block");
    protected static final class_2561 INVALID_WALL_BLOCK = TConstruct.makeTranslation("multiblock", "generic.invalid_wall_block");
    protected static final class_2561 INVALID_FLOOR_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_floor_frame");
    protected static final class_2561 INVALID_CEILING_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_ceiling_frame");
    protected static final class_2561 INVALID_WALL_FRAME = TConstruct.makeTranslation("multiblock", "generic.invalid_wall_frame");
    private static final int NORTH = class_2350.field_11043.method_10161();
    private static final int EAST = class_2350.field_11034.method_10161();
    private static final int SOUTH = class_2350.field_11035.method_10161();
    private static final int WEST = class_2350.field_11039.method_10161();
    protected final boolean hasFloor;
    protected final boolean hasFrame;
    protected final boolean hasCeiling;
    private final int maxHeight;
    private final int innerLimit;
    private MultiblockResult lastResult = NO_ATTEMPT;

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this(hasFloor, hasFrame, hasCeiling, 64, 14);
    }

    @Nullable
    public T detectMultiblock(class_1937 world, class_2338 master, class_2350 facing) {
        int height;
        MultiblockResult result;
        ImmutableSet.Builder extraBlocks = ImmutableSet.builder();
        class_2338 center = this.getOuterPos(world, master.method_10093(facing.method_10153()), class_2350.field_11033, this.maxHeight).method_10084();
        if (!(master.method_10264() >= center.method_10264() || this.hasFrame && this.isInnerBlock(world, center))) {
            this.setLastResult(MultiblockResult.error(center.method_10074(), INVALID_INNER_BLOCK));
            return null;
        }
        int[] edges = new int[4];
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 pos = this.getOuterPos(world, center, direction, this.innerLimit + 1);
            edges[direction.method_10161()] = pos.method_10263() - center.method_10263() + (pos.method_10260() - center.method_10260());
        }
        int xd = edges[SOUTH] - edges[NORTH] - 1;
        int zd = edges[EAST] - edges[WEST] - 1;
        if (xd > this.innerLimit || zd > this.innerLimit) {
            this.setLastResult(MultiblockResult.error(null, TOO_LARGE, xd, zd, this.innerLimit, this.innerLimit));
            return null;
        }
        class_2338 from = center.method_10069(edges[WEST], 0, edges[NORTH]);
        class_2338 to = center.method_10069(edges[EAST], 0, edges[SOUTH]);
        Consumer<Collection<class_2338>> posConsumer = arg_0 -> ((ImmutableSet.Builder)extraBlocks).addAll(arg_0);
        if (this.hasFloor && !(result = this.detectCap(world, from.method_10074(), to.method_10074(), CuboidSide.FLOOR, posConsumer)).isSuccess()) {
            this.setLastResult(result);
            return null;
        }
        int localMax = Math.min(this.maxHeight, world.method_31605() - center.method_10264());
        MultiblockResult heightResult = TOO_HIGH;
        for (height = 0; height < localMax && (heightResult = this.detectLayer(world, from.method_10086(height), to.method_10086(height), posConsumer)).isSuccess(); ++height) {
        }
        if (height == 0 || height <= master.method_10264() - center.method_10264()) {
            this.setLastResult(heightResult);
            return null;
        }
        if (height == localMax) {
            heightResult = MultiblockResult.SUCCESS;
        }
        if (this.hasCeiling) {
            MultiblockResult result2 = this.detectCap(world, from.method_10086(height), to.method_10086(height), CuboidSide.CEILING, posConsumer);
            if (!result2.isSuccess()) {
                this.setLastResult(result2);
                return null;
            }
            this.setLastResult(MultiblockResult.SUCCESS);
        } else {
            this.setLastResult(heightResult);
        }
        class_2338 minPos = this.hasFloor ? from.method_10074() : from;
        class_2338 maxPos = to.method_10086(this.hasCeiling ? height : height - 1);
        return this.create(minPos, maxPos, (Set<class_2338>)extraBlocks.build());
    }

    protected class_2338 getOuterPos(class_1937 world, class_2338 pos, class_2350 direction, int limit) {
        for (int i = 0; i < limit && world.method_8477(pos) && this.isInnerBlock(world, pos); ++i) {
            pos = pos.method_10093(direction);
        }
        return pos;
    }

    protected MultiblockResult detectCap(class_1937 world, class_2338 from, class_2338 to, CuboidSide side, Consumer<Collection<class_2338>> consumer) {
        int x;
        if (!world.method_22343(from, to)) {
            return NOT_LOADED;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int height = from.method_10264();
        if (this.hasFrame) {
            Predicate<class_2338> frameCheck = pos -> this.isValidBlock(world, (class_2338)pos, side, true);
            class_2561 frameError = side == CuboidSide.CEILING ? INVALID_CEILING_FRAME : INVALID_FLOOR_FRAME;
            for (x = from.method_10263(); x <= to.method_10263(); ++x) {
                if (!frameCheck.test((class_2338)mutable.method_10103(x, height, from.method_10260()))) {
                    return MultiblockResult.error(mutable.method_10062(), frameError);
                }
                if (frameCheck.test((class_2338)mutable.method_10103(x, height, to.method_10260()))) continue;
                return MultiblockResult.error(mutable.method_10062(), frameError);
            }
            for (int z = from.method_10260() + 1; z < to.method_10260(); ++z) {
                if (!frameCheck.test((class_2338)mutable.method_10103(from.method_10263(), height, z))) {
                    return MultiblockResult.error(mutable.method_10062(), frameError);
                }
                if (frameCheck.test((class_2338)mutable.method_10103(to.method_10263(), height, z))) continue;
                return MultiblockResult.error(mutable.method_10062(), frameError);
            }
        }
        class_2561 blockError = side == CuboidSide.CEILING ? INVALID_CEILING_BLOCK : INVALID_FLOOR_BLOCK;
        for (int z = from.method_10260() + 1; z < to.method_10260(); ++z) {
            for (x = from.method_10263() + 1; x < to.method_10263(); ++x) {
                if (this.isValidBlock(world, (class_2338)mutable.method_10103(x, height, z), side, false)) continue;
                return MultiblockResult.error(mutable.method_10062(), blockError);
            }
        }
        return MultiblockResult.SUCCESS;
    }

    protected MultiblockResult detectLayer(class_1937 world, class_2338 from, class_2338 to, Consumer<Collection<class_2338>> consumer) {
        int z;
        if (!world.method_22343(from, to)) {
            return NOT_LOADED;
        }
        ArrayList candidates = Lists.newArrayList();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int height = from.method_10264();
        if (this.hasFrame) {
            Predicate<class_2338> frameCheck = pos -> this.isValidBlock(world, (class_2338)pos, CuboidSide.WALL, true);
            if (!frameCheck.test(from)) {
                return MultiblockResult.error(from.method_10062(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test((class_2338)mutable.method_10103(from.method_10263(), height, to.method_10260()))) {
                return MultiblockResult.error(mutable.method_10062(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test((class_2338)mutable.method_10103(to.method_10263(), height, from.method_10260()))) {
                return MultiblockResult.error(mutable.method_10062(), INVALID_WALL_FRAME);
            }
            if (!frameCheck.test(to)) {
                return MultiblockResult.error(to.method_10062(), INVALID_WALL_FRAME);
            }
        }
        for (int x = from.method_10263() + 1; x < to.method_10263(); ++x) {
            for (z = from.method_10260() + 1; z < to.method_10260(); ++z) {
                mutable.method_10103(x, height, z);
                if (this.isInnerBlock(world, (class_2338)mutable)) {
                    if (world.method_22347((class_2338)mutable)) continue;
                    candidates.add(mutable.method_10062());
                    continue;
                }
                return MultiblockResult.error(mutable.method_10062(), INVALID_INNER_BLOCK);
            }
        }
        Predicate<class_2338> wallCheck = pos -> this.isValidBlock(world, (class_2338)pos, CuboidSide.WALL, false);
        for (int x = from.method_10263() + 1; x < to.method_10263(); ++x) {
            if (!wallCheck.test((class_2338)mutable.method_10103(x, height, from.method_10260()))) {
                return MultiblockResult.error(mutable.method_10062(), INVALID_WALL_BLOCK);
            }
            if (wallCheck.test((class_2338)mutable.method_10103(x, height, to.method_10260()))) continue;
            return MultiblockResult.error(mutable.method_10062(), INVALID_WALL_BLOCK);
        }
        for (z = from.method_10260() + 1; z < to.method_10260(); ++z) {
            if (!wallCheck.test((class_2338)mutable.method_10103(from.method_10263(), height, z))) {
                return MultiblockResult.error(mutable.method_10062(), INVALID_WALL_BLOCK);
            }
            if (wallCheck.test((class_2338)mutable.method_10103(to.method_10263(), height, z))) continue;
            return MultiblockResult.error(mutable.method_10062(), INVALID_WALL_BLOCK);
        }
        consumer.accept(candidates);
        return MultiblockResult.SUCCESS;
    }

    protected abstract boolean isValidBlock(class_1937 var1, class_2338 var2, CuboidSide var3, boolean var4);

    public boolean isInnerBlock(class_1937 world, class_2338 pos) {
        return world.method_22347(pos);
    }

    public abstract boolean shouldUpdate(class_1937 var1, MultiblockStructureData var2, class_2338 var3, class_2680 var4);

    @Nullable
    public T readFromTag(class_2487 nbt) {
        class_2338 minPos = TagUtil.readPos(nbt, "min");
        class_2338 maxPos = TagUtil.readPos(nbt, "max");
        if (minPos == null || maxPos == null) {
            return null;
        }
        ImmutableSet extra = ImmutableSet.copyOf(MultiblockCuboid.readPosList(nbt, "extra"));
        return this.create(minPos, maxPos, (Set<class_2338>)extra);
    }

    public abstract T create(class_2338 var1, class_2338 var2, Set<class_2338> var3);

    protected static Collection<class_2338> readPosList(class_2487 rootTag, String key) {
        List<class_2338> collection;
        if (rootTag.method_10573(key, 9)) {
            class_2499 list = rootTag.method_10554(key, 10);
            collection = new ArrayList<class_2338>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                class_2338 pos = TagUtil.readPos(list.method_10602(i));
                if (pos == null) continue;
                collection.add(pos);
            }
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling, int maxHeight, int innerLimit) {
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
        this.hasCeiling = hasCeiling;
        this.maxHeight = maxHeight;
        this.innerLimit = innerLimit;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    protected void setLastResult(MultiblockResult lastResult) {
        this.lastResult = lastResult;
    }

    public MultiblockResult getLastResult() {
        return this.lastResult;
    }

    public static enum CuboidSide {
        FLOOR,
        CEILING,
        WALL;

    }
}

