/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.tconstruct.smeltery.block.entity.CastingBlockEntity;

public class CastingFluidHandler
implements IFluidHandler {
    private final CastingBlockEntity tile;
    private FluidStack fluid = FluidStack.EMPTY;
    private long capacity = 0L;
    private class_3611 filter = class_3612.field_15906;
    private static final String TAG_FLUID = "fluid";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_CAPACITY = "capacity";

    public boolean isFluidValid(FluidStack stack) {
        return !stack.isEmpty() && (this.filter == class_3612.field_15906 || stack.getFluid() == this.filter);
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public long getCapacity() {
        if (this.capacity == 0L) {
            return this.fluid.getAmount();
        }
        return this.capacity;
    }

    public void reset() {
        this.capacity = 0L;
        this.fluid = FluidStack.EMPTY;
        this.filter = class_3612.field_15906;
    }

    public long fill(FluidStack resource, boolean sim) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0L;
        }
        long capacity = this.capacity;
        if (this.filter == null || this.capacity == 0L) {
            class_3611 fluid = resource.getFluid();
            capacity = this.tile.initNewCasting(resource, sim);
            if (capacity <= 0L) {
                return 0L;
            }
            if (!sim) {
                this.capacity = capacity;
                this.filter = fluid;
            }
        }
        if (this.fluid.isEmpty()) {
            long amount = Math.min(capacity, resource.getAmount());
            if (!sim) {
                this.fluid = new FluidStack(resource, amount);
                this.tile.onContentsChanged();
            }
            return amount;
        }
        if (!resource.isFluidEqual(this.fluid)) {
            return 0L;
        }
        long space = capacity - this.fluid.getAmount();
        if (space <= 0L) {
            return 0L;
        }
        long amount = resource.getAmount();
        if (amount < space) {
            if (!sim) {
                this.fluid.grow(amount);
                this.tile.onContentsChanged();
            }
            return amount;
        }
        if (!sim) {
            this.fluid.setAmount(capacity);
            this.tile.onContentsChanged();
        }
        return space;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, boolean sim) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), sim);
    }

    @Nonnull
    public FluidStack drain(long maxDrain, boolean sim) {
        long drained = Math.min(this.fluid.getAmount(), maxDrain);
        if (drained <= 0L) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (!sim) {
            this.fluid.shrink(drained);
            if (this.fluid.isEmpty()) {
                this.tile.reset();
            } else {
                this.tile.onContentsChanged();
            }
        }
        return stack;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return this.fluid;
        }
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public long getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 && this.isFluidValid(stack);
    }

    public void readFromTag(class_2487 nbt) {
        class_3611 fluid;
        this.capacity = nbt.method_10537(TAG_CAPACITY);
        if (nbt.method_10573(TAG_FLUID, 10)) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((class_2487)nbt.method_10562(TAG_FLUID)));
        }
        if (nbt.method_10573(TAG_FILTER, 8) && (fluid = (class_3611)class_2378.field_11154.method_10223(new class_2960(nbt.method_10558(TAG_FILTER)))) != null) {
            this.filter = fluid;
        }
    }

    public class_2487 writeToTag(class_2487 nbt) {
        nbt.method_10544(TAG_CAPACITY, this.capacity);
        if (!this.fluid.isEmpty()) {
            nbt.method_10566(TAG_FLUID, (class_2520)this.fluid.writeToNBT(new class_2487()));
        }
        if (this.filter != class_3612.field_15906) {
            nbt.method_10582(TAG_FILTER, Objects.requireNonNull(class_2378.field_11154.method_10221((Object)this.filter)).toString());
        }
        return nbt;
    }

    public CastingFluidHandler(CastingBlockEntity tile) {
        this.tile = tile;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }
}

