/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import net.minecraft.class_2487;
import slimeknights.mantle.transfer.fluid.FluidTank;
import slimeknights.tconstruct.smeltery.block.entity.ChannelBlockEntity;

public class ChannelTank
extends FluidTank {
    private static final String TAG_LOCKED = "locked";
    private int locked;
    private final ChannelBlockEntity parent;

    public ChannelTank(int capacity, ChannelBlockEntity parent) {
        super((long)capacity, fluid -> !fluid.getFluid().getAttributes().isGaseous(fluid));
        this.parent = parent;
    }

    public void freeFluid() {
        this.locked = 0;
    }

    public long getMaxUsable() {
        return Math.max(this.fluid.getAmount() - (long)this.locked, 0L);
    }

    public long fill(FluidStack resource, boolean sim) {
        boolean wasEmpty = this.isEmpty();
        long amount = super.fill(resource, sim);
        if (!sim) {
            this.locked = (int)((long)this.locked + amount);
            if (wasEmpty && !this.isEmpty()) {
                this.parent.sendFluidUpdate();
            }
        }
        return amount;
    }

    public FluidStack drain(long maxDrain, boolean sim) {
        boolean wasEmpty = this.isEmpty();
        FluidStack stack = super.drain(maxDrain, sim);
        if (!sim && !wasEmpty && this.isEmpty()) {
            this.parent.sendFluidUpdate();
        }
        return stack;
    }

    public FluidTank readFromNBT(class_2487 nbt) {
        this.locked = nbt.method_10550(TAG_LOCKED);
        super.readFromNBT(nbt);
        return this;
    }

    public class_2487 writeToNBT(class_2487 nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.method_10569(TAG_LOCKED, this.locked);
        return nbt;
    }
}

