/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.transfer.fluid.IFluidHandler;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.network.SmelteryTankUpdatePacket;

public class SmelteryTank<T extends MantleBlockEntity>
implements IFluidHandler {
    private final T parent;
    private final List<FluidStack> fluids = Lists.newArrayList();
    private long capacity = 0L;
    private long contained = 0L;
    private static final String TAG_FLUIDS = "fluids";
    private static final String TAG_CAPACITY = "capacity";

    public SmelteryTank(T parent) {
        this.parent = parent;
    }

    public void syncFluids() {
        class_1937 world = this.parent.method_10997();
        if (world != null && !world.field_9236) {
            class_2338 pos = this.parent.method_11016();
            TinkerNetwork.getInstance().sendToClientsAround((S2CPacket)new SmelteryTankUpdatePacket(pos, this.fluids), (class_1936)world, pos);
        }
    }

    public void setCapacity(long maxCapacity) {
        this.capacity = maxCapacity;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getRemainingSpace() {
        if (this.contained >= this.capacity) {
            return 0L;
        }
        return this.capacity - this.contained;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int getTanks() {
        if (this.contained < this.capacity) {
            return this.fluids.size() + 1;
        }
        return this.fluids.size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.fluids.size()) {
            return FluidStack.EMPTY;
        }
        return this.fluids.get(tank);
    }

    public long getTankCapacity(int tank) {
        if (tank < 0) {
            return 0L;
        }
        long remaining = this.capacity - this.contained;
        if (tank == this.fluids.size()) {
            return remaining;
        }
        return this.fluids.get(tank).getAmount() + remaining;
    }

    public void moveFluidToBottom(int index) {
        if (index < this.fluids.size()) {
            FluidStack fluid = this.fluids.get(index);
            this.fluids.remove(index);
            this.fluids.add(0, fluid);
            ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, FluidStack.EMPTY);
        }
    }

    public long fill(FluidStack resource, boolean sim) {
        if (this.contained >= this.capacity || resource.isEmpty()) {
            return 0L;
        }
        long usable = Math.min(this.capacity - this.contained, resource.getAmount());
        if (usable <= 0L) {
            return 0L;
        }
        if (sim) {
            return usable;
        }
        this.contained += usable;
        for (FluidStack fluid : this.fluids) {
            if (!fluid.isFluidEqual(resource)) continue;
            fluid.grow(usable);
            ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
            return usable;
        }
        resource = resource.copy();
        resource.setAmount(usable);
        this.fluids.add(resource);
        ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ADDED, resource);
        return usable;
    }

    @Nonnull
    public FluidStack drain(long maxDrain, boolean sim) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.fluids.get(0);
        long drainable = Math.min(maxDrain, fluid.getAmount());
        FluidStack ret = fluid.copy();
        ret.setAmount(drainable);
        if (!sim) {
            fluid.shrink(drainable);
            this.contained -= drainable;
            if (fluid.getAmount() <= 0L) {
                this.fluids.remove(fluid);
                ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.REMOVED, fluid);
            } else {
                ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
            }
        }
        return ret;
    }

    @Nonnull
    public FluidStack drain(FluidStack toDrain, boolean sim) {
        ListIterator<FluidStack> iter = this.fluids.listIterator();
        while (iter.hasNext()) {
            FluidStack fluid = iter.next();
            if (!fluid.isFluidEqual(toDrain)) continue;
            long drainable = Math.min(toDrain.getAmount(), fluid.getAmount());
            FluidStack ret = fluid.copy();
            ret.setAmount(drainable);
            if (!sim) {
                fluid.shrink(drainable);
                this.contained -= drainable;
                if (fluid.getAmount() <= 0L) {
                    iter.remove();
                    ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.REMOVED, fluid);
                } else {
                    ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
                }
            }
            return ret;
        }
        return FluidStack.EMPTY;
    }

    public void setFluids(List<FluidStack> fluids) {
        FluidStack oldFirst = this.getFluidInTank(0);
        this.fluids.clear();
        this.fluids.addAll(fluids);
        this.contained = fluids.stream().mapToLong(FluidStack::getAmount).reduce(0L, Long::sum);
        FluidStack newFirst = this.getFluidInTank(0);
        if (!oldFirst.isFluidEqual(newFirst)) {
            ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ORDER_CHANGED, newFirst);
        }
    }

    public class_2487 write(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (FluidStack liquid : this.fluids) {
            class_2487 fluidTag = new class_2487();
            liquid.writeToNBT(fluidTag);
            list.add((Object)fluidTag);
        }
        nbt.method_10566(TAG_FLUIDS, (class_2520)list);
        nbt.method_10544(TAG_CAPACITY, this.capacity);
        return nbt;
    }

    public void read(class_2487 tag) {
        class_2499 list = tag.method_10554(TAG_FLUIDS, 10);
        this.fluids.clear();
        this.contained = 0L;
        for (int i = 0; i < list.size(); ++i) {
            class_2487 fluidTag = list.method_10602(i);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((class_2487)fluidTag);
            if (fluid.isEmpty()) continue;
            this.fluids.add(fluid);
            this.contained += fluid.getAmount();
        }
        this.capacity = tag.method_10537(TAG_CAPACITY);
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public long getContained() {
        return this.contained;
    }
}

