/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.CompositeModelState;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.model.ItemLayerModel;
import io.github.fabricators_of_create.porting_lib.model.ItemMultiLayerBakedModel;
import io.github.fabricators_of_create.porting_lib.model.ItemTextureQuadConverter;
import io.github.fabricators_of_create.porting_lib.model.PerspectiveMapWrapper;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_806;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;

public final class CopperCanModel
implements IModelGeometry<CopperCanModel> {
    public static final Loader LOADER = new Loader();
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Nonnull
    private final FluidStack fluid;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    public class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation) {
        class_1058 templateSprite;
        class_1058 coverSprite;
        class_2960 stillTexture = this.fluid.getFluid().getAttributes().getStillTexture(this.fluid);
        class_1058 fluidSprite = !this.fluid.isEmpty() ? spriteGetter.apply(new class_4730(class_1059.field_5275, stillTexture)) : null;
        class_4730 baseLocation = owner.isTexturePresent("base") ? owner.resolveTexture("base") : null;
        class_1058 class_10582 = coverSprite = (!this.coverIsMask || baseLocation != null) && owner.isTexturePresent("cover") ? spriteGetter.apply(owner.resolveTexture("cover")) : null;
        class_1058 particleSprite = owner.isTexturePresent("particle") ? spriteGetter.apply(owner.resolveTexture("particle")) : (fluidSprite != null ? fluidSprite : (!this.coverIsMask && coverSprite != null ? coverSprite : spriteGetter.apply(new class_4730(class_1059.field_5275, class_1047.method_4539()))));
        class_3665 transformsFromModel = owner.getCombinedTransform();
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((class_3665)new CompositeModelState(transformsFromModel, modelTransform));
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (class_1058)particleSprite, (class_806)new ContainedFluidOverrideHandler(overrides, bakery, owner, this), (ImmutableMap)transformMap);
        class_4590 transform = modelTransform.method_3509();
        if (baseLocation != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprites((List)ImmutableList.of((Object)baseLocation), (class_4590)transform, spriteGetter));
        }
        if (fluidSprite != null && owner.isTexturePresent("fluid") && (templateSprite = spriteGetter.apply(owner.resolveTexture("fluid"))) != null) {
            int luminosity = this.applyFluidLuminosity ? this.fluid.getFluid().getAttributes().getLuminosity(this.fluid) : 0;
            int color = this.fluid.getFluid().getAttributes().getColor(this.fluid);
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((class_4590)transform, (class_1058)templateSprite, (class_1058)fluidSprite, (float)0.468625f, (class_2350)class_2350.field_11043, (int)color, (int)-1, (int)luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((class_4590)transform, (class_1058)templateSprite, (class_1058)fluidSprite, (float)0.531375f, (class_2350)class_2350.field_11035, (int)color, (int)-1, (int)luminosity));
        }
        if (this.coverIsMask) {
            if (coverSprite != null) {
                class_1058 baseSprite = spriteGetter.apply(baseLocation);
                builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemTextureQuadConverter.convertTexture((class_4590)transform, (class_1058)coverSprite, (class_1058)baseSprite, (float)0.4685f, (class_2350)class_2350.field_11043, (int)-1, (int)2));
                builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemTextureQuadConverter.convertTexture((class_4590)transform, (class_1058)coverSprite, (class_1058)baseSprite, (float)0.5315f, (class_2350)class_2350.field_11035, (int)-1, (int)2));
            }
        } else if (coverSprite != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new class_777[]{ItemTextureQuadConverter.genQuad((class_4590)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.4685f, (class_1058)coverSprite, (class_2350)class_2350.field_11043, (int)-1, (int)2)});
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new class_777[]{ItemTextureQuadConverter.genQuad((class_4590)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.5315f, (class_1058)coverSprite, (class_2350)class_2350.field_11035, (int)-1, (int)2)});
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.isTexturePresent("particle")) {
            texs.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("base")) {
            texs.add(owner.resolveTexture("base"));
        }
        if (owner.isTexturePresent("fluid")) {
            texs.add(owner.resolveTexture("fluid"));
        }
        if (owner.isTexturePresent("cover")) {
            texs.add(owner.resolveTexture("cover"));
        }
        return texs;
    }

    public CopperCanModel(@Nonnull FluidStack fluid, boolean coverIsMask, boolean applyFluidLuminosity) {
        if (fluid == null) {
            throw new NullPointerException("fluid is marked non-null but is null");
        }
        this.fluid = fluid;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public CopperCanModel withFluid(@Nonnull FluidStack fluid) {
        if (fluid == null) {
            throw new NullPointerException("fluid is marked non-null but is null");
        }
        return this.fluid == fluid ? this : new CopperCanModel(fluid, this.coverIsMask, this.applyFluidLuminosity);
    }

    private static final class ContainedFluidOverrideHandler
    extends class_806 {
        private static final class_2960 BAKE_LOCATION = TConstruct.getResource("copper_can_dynamic");
        private final Map<FluidStack, class_1087> cache = Maps.newHashMap();
        private final class_806 nested;
        private final class_1088 bakery;
        private final IModelConfiguration owner;
        private final CopperCanModel parent;

        private ContainedFluidOverrideHandler(class_806 nested, class_1088 bakery, IModelConfiguration owner, CopperCanModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        private class_1087 getUncahcedModel(FluidStack fluid) {
            return this.parent.withFluid(fluid).bake(this.owner, this.bakery, class_4730::method_24148, (class_3665)class_1086.field_5350, class_806.field_4292, BAKE_LOCATION);
        }

        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
            class_1087 overriden = this.nested.method_3495(originalModel, stack, world, entity, seed);
            if (overriden != originalModel) {
                return overriden;
            }
            class_3611 fluid = CopperCanItem.getFluid(stack.method_7969());
            if (fluid != class_3612.field_15906) {
                FluidStack fluidStack = new FluidStack(fluid, 9000L, CopperCanItem.getFluidTag(stack.method_7969()));
                return this.cache.computeIfAbsent(fluidStack, this::getUncahcedModel);
            }
            return originalModel;
        }
    }

    private static class Loader
    implements IModelLoader<CopperCanModel> {
        private Loader() {
        }

        public void method_14491(class_3300 resourceManager) {
        }

        public CopperCanModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            boolean coverIsMask = class_3518.method_15258((JsonObject)modelContents, (String)"coverIsMask", (boolean)true);
            boolean applyFluidLuminosity = class_3518.method_15258((JsonObject)modelContents, (String)"applyFluidLuminosity", (boolean)true);
            return new CopperCanModel(FluidStack.EMPTY, coverIsMask, applyFluidLuminosity);
        }
    }
}

