/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;

public class GuiMeltingModule {
    private static final ScalableElementScreen PROGRESS_BAR = new ScalableElementScreen(176, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen NO_HEAT_BAR = new ScalableElementScreen(179, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen NO_SPACE_BAR = new ScalableElementScreen(182, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen UNMELTABLE_BAR = new ScalableElementScreen(185, 150, 3, 16, 256, 256);
    private static final class_2561 TOOLTIP_NO_HEAT = new class_2588(TConstruct.makeTranslationKey("gui", "melting.no_heat"));
    private static final class_2561 TOOLTIP_NO_SPACE = new class_2588(TConstruct.makeTranslationKey("gui", "melting.no_space"));
    private static final class_2561 TOOLTIP_UNMELTABLE = new class_2588(TConstruct.makeTranslationKey("gui", "melting.no_recipe"));
    private final class_465<?> screen;
    private final MeltingModuleInventory inventory;
    private final IntSupplier temperature;
    private final Predicate<class_1735> slotPredicate;

    public void drawHeatBars(class_4587 matrices) {
        int temperature = this.temperature.getAsInt();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            class_1735 slot = (class_1735)this.screen.method_17577().field_7761.get(i);
            if (!slot.method_7681() || !this.slotPredicate.test(slot)) continue;
            ScalableElementScreen bar = PROGRESS_BAR;
            int index = slot.getSlotIndex();
            int currentTemp = this.inventory.getCurrentTime(index);
            int requiredTime = this.inventory.getRequiredTime(index);
            float progress = 1.0f;
            if (requiredTime == 0) {
                bar = UNMELTABLE_BAR;
            } else if (this.inventory.getRequiredTemp(index) > temperature) {
                bar = NO_HEAT_BAR;
            } else if (currentTemp < 0) {
                bar = NO_SPACE_BAR;
                progress = 1.0f;
            } else if (currentTemp <= requiredTime) {
                progress = (float)currentTemp / (float)requiredTime;
            }
            GuiUtil.drawProgressUp(matrices, (ElementScreen)bar, slot.field_7873 - 4, slot.field_7872, progress);
        }
    }

    public void drawHeatTooltips(class_4587 matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.screen.field_2776;
        int checkY = mouseY - this.screen.field_2800;
        int temperature = this.temperature.getAsInt();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            class_1735 slot = (class_1735)this.screen.method_17577().field_7761.get(i);
            if (!slot.method_7681() || !this.slotPredicate.test(slot) || !GuiUtil.isHovered(checkX, checkY, slot.field_7873 - 5, slot.field_7872 - 1, GuiMeltingModule.PROGRESS_BAR.w + 1, GuiMeltingModule.PROGRESS_BAR.h + 2)) continue;
            int index = slot.getSlotIndex();
            class_2561 tooltip = null;
            if (this.inventory.getRequiredTime(index) == 0) {
                tooltip = TOOLTIP_UNMELTABLE;
            } else if (this.inventory.getRequiredTemp(slot.getSlotIndex()) > temperature) {
                tooltip = TOOLTIP_NO_HEAT;
            } else if (this.inventory.getCurrentTime(index) < 0) {
                tooltip = TOOLTIP_NO_SPACE;
            }
            if (tooltip == null) break;
            this.screen.method_25424(matrices, tooltip, mouseX, mouseY);
            break;
        }
    }

    public GuiMeltingModule(class_465<?> screen, MeltingModuleInventory inventory, IntSupplier temperature, Predicate<class_1735> slotPredicate) {
        this.screen = screen;
        this.inventory = inventory;
        this.temperature = temperature;
        this.slotPredicate = slotPredicate;
    }
}

