/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.tank.SmelteryTank;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidClickedPacket;

public class GuiSmelteryTank {
    public static final class_2561 TOOLTIP_CAPACITY = TConstruct.makeTranslation("gui", "melting.capacity");
    public static final class_2561 TOOLTIP_AVAILABLE = TConstruct.makeTranslation("gui", "melting.available");
    public static final class_2561 TOOLTIP_USED = TConstruct.makeTranslation("gui", "melting.used");
    private final class_465<?> parent;
    private final SmelteryTank<?> tank;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final BiConsumer<Long, List<class_2561>> formatter;
    private int[] liquidHeights;

    public GuiSmelteryTank(class_465<?> parent, SmelteryTank<?> tank, int x, int y, int width, int height, class_2960 tooltipId) {
        this.parent = parent;
        this.tank = tank;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.formatter = (amount, tooltip) -> FluidTooltipHandler.appendNamedList((class_2960)tooltipId, (long)amount, (List)tooltip);
    }

    private int[] calcLiquidHeights(boolean refresh) {
        assert (this.tank != null);
        if (this.liquidHeights == null || refresh) {
            this.liquidHeights = GuiSmelteryTank.calcLiquidHeights(this.tank.getFluids(), Math.max(this.tank.getContained(), this.tank.getCapacity()), this.height, 3);
        }
        return this.liquidHeights;
    }

    private boolean withinTank(int checkX, int checkY) {
        return this.x <= checkX && checkX < this.x + this.width && this.y <= checkY && checkY < this.y + this.height;
    }

    public void renderFluids(class_4587 matrices) {
        if (this.tank.getContained() > 0L) {
            int[] heights = this.calcLiquidHeights(true);
            int bottom = this.y + this.width;
            for (int i = 0; i < heights.length; ++i) {
                int fluidH = heights[i];
                FluidStack liquid = this.tank.getFluids().get(i);
                GuiUtil.renderTiledFluid(matrices, this.parent, liquid, this.x, bottom - fluidH, this.width, fluidH, 100);
                bottom -= fluidH;
            }
        }
    }

    private int getFluidHovered(int[] heights, int y) {
        for (int i = 0; i < heights.length; ++i) {
            if (y < heights[i]) {
                return i;
            }
            y -= heights[i];
        }
        return -1;
    }

    private int getFluidFromMouse(int[] heights, int checkY) {
        return this.getFluidHovered(heights, this.y + this.height - checkY - 1);
    }

    public void renderHighlight(class_4587 matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.parent.field_2776;
        int checkY = mouseY - this.parent.field_2800;
        if (this.withinTank(checkX, checkY)) {
            if (this.tank.getContained() == 0L) {
                GuiUtil.renderHighlight(matrices, this.x, this.y, this.width, this.height);
            } else {
                int[] heights = this.calcLiquidHeights(false);
                int hovered = this.getFluidFromMouse(heights, checkY);
                int heightSum = 0;
                int loopMax = hovered == -1 ? heights.length : hovered + 1;
                for (int i = 0; i < loopMax; ++i) {
                    heightSum += heights[i];
                }
                if (hovered == -1) {
                    GuiUtil.renderHighlight(matrices, this.x, this.y, this.width, this.height - heightSum);
                } else {
                    GuiUtil.renderHighlight(matrices, this.x, this.y + this.height - heightSum, this.width, heights[hovered]);
                }
            }
        }
    }

    public void drawTooltip(class_4587 matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.parent.field_2776;
        int checkY = mouseY - this.parent.field_2800;
        if (this.withinTank(checkX, checkY)) {
            ArrayList<class_2561> tooltip;
            int hovered;
            int n = hovered = this.tank.getContained() == 0L ? -1 : this.getFluidFromMouse(this.calcLiquidHeights(false), checkY);
            if (hovered == -1) {
                long used;
                BiConsumer<Long, List<class_2561>> formatter = class_437.method_25442() ? FluidTooltipHandler.BUCKET_FORMATTER : this.formatter;
                tooltip = new ArrayList<class_2561>();
                tooltip.add(TOOLTIP_CAPACITY);
                formatter.accept(this.tank.getCapacity(), tooltip);
                long remaining = this.tank.getRemainingSpace();
                if (remaining > 0L) {
                    tooltip.add(TOOLTIP_AVAILABLE);
                    formatter.accept(remaining, tooltip);
                }
                if ((used = this.tank.getContained()) > 0L) {
                    tooltip.add(TOOLTIP_USED);
                    formatter.accept(used, tooltip);
                }
                FluidTooltipHandler.appendShift(tooltip);
            } else {
                tooltip = FluidTooltipHandler.getFluidTooltip((FluidStack)this.tank.getFluidInTank(hovered));
            }
            this.parent.method_30901(matrices, tooltip, mouseX, mouseY);
        }
    }

    public void handleClick(int mouseX, int mouseY) {
        int index;
        if (this.tank.getContained() > 0L && this.withinTank(mouseX, mouseY) && (index = this.getFluidFromMouse(this.calcLiquidHeights(false), mouseY)) != -1) {
            TinkerNetwork.getInstance().sendToServer((ISimplePacket)new SmelteryFluidClickedPacket(index));
        }
    }

    @Nullable
    public FluidStack getIngredient(int checkX, int checkY) {
        int index;
        if (this.tank.getContained() > 0L && this.withinTank(checkX, checkY) && (index = this.getFluidFromMouse(this.calcLiquidHeights(false), checkY)) != -1) {
            return this.tank.getFluidInTank(index);
        }
        return null;
    }

    public static int[] calcLiquidHeights(List<FluidStack> liquids, long capacity, int height, int min) {
        int[] fluidHeights = new int[liquids.size()];
        int totalFluidAmount = 0;
        if (liquids.size() > 0) {
            int sum;
            for (int i = 0; i < liquids.size(); ++i) {
                FluidStack liquid = liquids.get(i);
                float h = (float)liquid.getAmount() / (float)capacity;
                totalFluidAmount = (int)((long)totalFluidAmount + liquid.getAmount());
                fluidHeights[i] = Math.max(min, (int)Math.ceil(h * (float)height));
            }
            if ((long)totalFluidAmount < capacity) {
                height -= min;
            }
            do {
                sum = 0;
                int biggest = -1;
                int m = 0;
                for (int i = 0; i < fluidHeights.length; ++i) {
                    sum += fluidHeights[i];
                    if (fluidHeights[i] <= biggest) continue;
                    biggest = fluidHeights[i];
                    m = i;
                }
                if (fluidHeights[m] == 0) break;
                if (sum <= height) continue;
                int n = m;
                fluidHeights[n] = fluidHeights[n] - 1;
            } while (sum > height);
        }
        return fluidHeights;
    }
}

