/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import io.github.fabricators_of_create.porting_lib.item.CustomMaxCountItem;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.transfer.fluid.FluidTank;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;

public class TankItem
extends BlockTooltipItem
implements CustomMaxCountItem {
    private static final String KEY_FLUID = TConstruct.makeTranslationKey("block", "tank.fluid");
    private static final String KEY_MB = TConstruct.makeTranslationKey("block", "tank.mb");
    private static final String KEY_INGOTS = TConstruct.makeTranslationKey("block", "tank.ingots");
    private static final String KEY_MIXED = TConstruct.makeTranslationKey("block", "tank.mixed");
    private final boolean limitStackSize;

    public TankItem(class_2248 blockIn, class_1792.class_1793 builder, boolean limitStackSize) {
        super(blockIn, builder);
        this.limitStackSize = limitStackSize;
    }

    private static boolean isFilled(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10573("tank", 10);
    }

    public class_1799 getContainerItem(class_1799 stack) {
        return TankItem.isFilled(stack) ? new class_1799((class_1935)this) : class_1799.field_8037;
    }

    public int getItemStackLimit(class_1799 stack) {
        if (!this.limitStackSize) {
            return 64;
        }
        return TankItem.isFilled(stack) ? 16 : 64;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (stack.method_7985()) {
            FluidTank tank = TankItem.getFluidTank(stack);
            if (tank.getFluidAmount() > 0L) {
                tooltip.add((class_2561)new class_2588(KEY_FLUID, new Object[]{tank.getFluid().getDisplayName()}).method_27692(class_124.field_1080));
                long amount = tank.getFluidAmount();
                TooltipKey key = SafeClientAccess.getTooltipKey();
                if (tank.getCapacity() % 9000L != 0L || key == TooltipKey.SHIFT) {
                    tooltip.add((class_2561)new class_2588(KEY_MB, new Object[]{amount}).method_27692(class_124.field_1080));
                } else {
                    long ingots = amount / 9000L;
                    long mb = amount % 9000L;
                    if (mb == 0L) {
                        tooltip.add((class_2561)new class_2588(KEY_INGOTS, new Object[]{ingots}).method_27692(class_124.field_1080));
                    } else {
                        tooltip.add((class_2561)new class_2588(KEY_MIXED, new Object[]{ingots, mb}).method_27692(class_124.field_1080));
                    }
                    if (key != TooltipKey.UNKNOWN) {
                        tooltip.add(FluidTooltipHandler.HOLD_SHIFT);
                    }
                }
            }
        } else {
            super.method_7851(stack, worldIn, tooltip, flagIn);
        }
    }

    public static void initCapabilities() {
        for (SearedTankBlock block : TinkerSmeltery.searedTank.values()) {
            FluidStorage.combinedItemApiProvider((class_1792)block.method_8389()).register(ctx -> null);
        }
    }

    public static class_1799 setTank(class_1799 stack, FluidTank tank) {
        if (tank.isEmpty()) {
            class_2487 nbt = stack.method_7969();
            if (nbt != null) {
                nbt.method_10551("tank");
                if (nbt.method_33133()) {
                    stack.method_7980(null);
                }
            }
        } else {
            stack.method_7948().method_10566("tank", (class_2520)tank.writeToNBT(new class_2487()));
        }
        return stack;
    }

    public static FluidTank getFluidTank(class_1799 stack) {
        FluidTank tank = new FluidTank(TankBlockEntity.getCapacity(stack.method_7909()));
        if (stack.method_7985()) {
            assert (stack.method_7969() != null);
            tank.readFromNBT(stack.method_7969().method_10562("tank"));
        }
        return tank;
    }
}

