/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.transfer.item.ItemStackHandler;
import slimeknights.tconstruct.tables.block.entity.inventory.IChestItemHandler;

public abstract class ScalingChestItemHandler
extends ItemStackHandler
implements IChestItemHandler {
    protected static final int DEFAULT_MAX = 256;
    private int visualSize = 1;
    @Nullable
    private MantleBlockEntity parent;

    public ScalingChestItemHandler(int size) {
        super(size);
    }

    public ScalingChestItemHandler() {
        this(256);
    }

    public abstract boolean isItemValid(int var1, class_1799 var2);

    protected void onLoad() {
        int newLimit = this.getSlots();
        if (newLimit > 1 && this.getStackInSlot(newLimit - 1).method_7960()) {
            while (newLimit > 1 && this.getStackInSlot(newLimit - 2).method_7960()) {
                --newLimit;
            }
        }
        this.visualSize = newLimit;
    }

    private void updateVisualSize(int slotChanged, class_1799 stack) {
        int maxSlots = this.getSlots();
        if (slotChanged >= maxSlots) {
            return;
        }
        if (stack.method_7960()) {
            if (slotChanged + 1 == this.visualSize || slotChanged + 2 == this.visualSize && this.getStackInSlot(this.visualSize - 1).method_7960()) {
                while (this.visualSize > 1 && this.getStackInSlot(this.visualSize - 2).method_7960()) {
                    --this.visualSize;
                }
            }
        } else if (this.visualSize < maxSlots && this.visualSize < slotChanged + 2) {
            this.visualSize = slotChanged + 2;
        }
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        super.setStackInSlot(slot, stack);
        this.updateVisualSize(slot, stack);
    }

    @Nonnull
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        class_1799 result = super.insertItem(slot, stack, simulate);
        if (!simulate) {
            this.updateVisualSize(slot, this.getStackInSlot(slot));
        }
        return result;
    }

    @Nonnull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        class_1799 result = super.extractItem(slot, amount, simulate);
        if (!simulate) {
            this.updateVisualSize(slot, this.getStackInSlot(slot));
        }
        return result;
    }

    protected void onContentsChanged(int slot) {
        if (this.parent != null) {
            this.parent.setChangedFast();
        }
    }

    @Override
    public int getVisualSize() {
        return this.visualSize;
    }

    @Override
    public void setParent(@Nullable MantleBlockEntity parent) {
        this.parent = parent;
    }
}

