/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import io.github.fabricators_of_create.porting_lib.event.common.ItemCraftedCallback;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.RecipeManagerAccessor;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.LazyResultContainer;
import slimeknights.tconstruct.tables.block.entity.inventory.PartBuilderContainerWrapper;
import slimeknights.tconstruct.tables.block.entity.table.RetexturedTableBlockEntity;
import slimeknights.tconstruct.tables.menu.PartBuilderContainerMenu;

public class PartBuilderBlockEntity
extends RetexturedTableBlockEntity
implements LazyResultContainer.ILazyCrafter {
    public static final int MATERIAL_SLOT = 0;
    public static final int PATTERN_SLOT = 1;
    private static final class_2561 NAME = TConstruct.makeTranslation("gui", "part_builder");
    private final LazyResultContainer craftingResult;
    private final PartBuilderContainerWrapper inventoryWrapper;
    @Nullable
    private Map<Pattern, IPartBuilderRecipe> recipes = null;
    @Nullable
    private List<Pattern> sortedButtons = null;
    private Pattern selectedPattern = null;
    private int selectedPatternIndex = -2;

    public PartBuilderBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)TinkerTables.partBuilderTile.get(), pos, state, NAME, 3);
        this.itemHandler = new ConfigurableInvWrapperCapability((class_1263)this, false, false);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.inventoryWrapper = new PartBuilderContainerWrapper(this);
        this.craftingResult = new LazyResultContainer(this);
    }

    protected Map<Pattern, IPartBuilderRecipe> getCurrentRecipes() {
        if (this.field_11863 == null) {
            return Collections.emptyMap();
        }
        if (this.recipes == null) {
            if (this.method_5438(1).method_7960()) {
                this.recipes = Collections.emptyMap();
                this.sortedButtons = Collections.emptyList();
            } else {
                record PatternRecipe(Pattern pattern, IPartBuilderRecipe recipe) {
                }
                this.recipes = ((RecipeManagerAccessor)this.field_11863.method_8433()).port_lib$byType((class_3956)TinkerRecipeTypes.PART_BUILDER.get()).values().stream().filter(r -> r instanceof IPartBuilderRecipe).map(r -> (IPartBuilderRecipe)r).filter(r -> r.partialMatch(this.inventoryWrapper)).sorted(Comparator.comparing(class_1860::method_8114)).flatMap(r -> r.getPatterns(this.inventoryWrapper).map(p -> new PatternRecipe((Pattern)((Object)((Object)p)), (IPartBuilderRecipe)r))).collect(Collectors.toMap(PatternRecipe::pattern, PatternRecipe::recipe, (a, b) -> a));
                this.sortedButtons = this.recipes.entrySet().stream().sorted(Comparator.comparingInt(ent -> ((IPartBuilderRecipe)ent.getValue()).getCost()).thenComparing(Map.Entry::getKey)).map(Map.Entry::getKey).collect(Collectors.toList());
            }
        }
        return this.recipes;
    }

    public List<Pattern> getSortedButtons() {
        if (this.field_11863 == null) {
            return Collections.emptyList();
        }
        if (this.sortedButtons == null) {
            this.getCurrentRecipes();
        }
        return this.sortedButtons;
    }

    public int getSelectedIndex() {
        if (this.selectedPatternIndex == -2) {
            this.selectedPatternIndex = this.selectedPattern != null ? this.getSortedButtons().indexOf((Object)this.selectedPattern) : -1;
        }
        return this.selectedPatternIndex;
    }

    @Nullable
    public IPartBuilderRecipe getPartRecipe() {
        if (this.selectedPattern != null) {
            return this.getCurrentRecipes().get((Object)this.selectedPattern);
        }
        return null;
    }

    @Nullable
    public IPartBuilderRecipe getFirstRecipe() {
        List<Pattern> sortedButtons = this.getSortedButtons();
        if (sortedButtons.isEmpty()) {
            return null;
        }
        return this.getCurrentRecipes().get((Object)sortedButtons.get(0));
    }

    @Nullable
    public IMaterialValue getMaterialRecipe() {
        return this.inventoryWrapper.getMaterial();
    }

    private void refresh(boolean refreshRecipeList) {
        if (refreshRecipeList) {
            this.recipes = null;
            this.sortedButtons = null;
        }
        this.selectedPatternIndex = -2;
        this.craftingResult.method_5448();
        if (refreshRecipeList && this.field_11863 != null && !this.field_11863.field_9236) {
            this.syncToRelevantPlayers(x$0 -> this.syncScreen((class_1657)x$0));
        }
    }

    public void selectRecipe(@Nullable Pattern pattern) {
        this.selectedPattern = pattern != null && this.getCurrentRecipes().containsKey((Object)pattern) ? pattern : null;
        this.refresh(false);
    }

    public void selectRecipe(int index) {
        List<Pattern> list;
        this.selectedPattern = index < 0 ? null : (index < (list = this.getSortedButtons()).size() ? list.get(index) : null);
        this.refresh(false);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 original = this.method_5438(slot);
        super.method_5447(slot, stack);
        if (slot == 0) {
            if (original.method_7909() != stack.method_7909() || !class_1799.method_7975((class_1799)original, (class_1799)stack)) {
                this.inventoryWrapper.refreshMaterial();
                this.refresh(true);
            } else if (original.method_7947() != stack.method_7947()) {
                this.craftingResult.method_5448();
            }
        } else if (original.method_7909() != stack.method_7909()) {
            this.refresh(true);
        }
    }

    @Nullable
    public class_1703 createMenu(int menuId, class_1661 playerInventory, class_1657 playerEntity) {
        return new PartBuilderContainerMenu(menuId, playerInventory, this);
    }

    @Override
    public class_1799 calcResult(@Nullable class_1657 player) {
        IPartBuilderRecipe recipe;
        if (this.field_11863 != null && (recipe = this.getPartRecipe()) != null && recipe.method_8115((class_1263)this.inventoryWrapper, this.field_11863)) {
            return recipe.assemble(this.inventoryWrapper, this.selectedPattern);
        }
        return class_1799.field_8037;
    }

    private void shrinkSlot(int slot, int amount, class_1657 player) {
        class_1799 stack = this.method_5438(slot);
        if (!stack.method_7960()) {
            class_1799 container;
            class_1799 class_17992 = container = stack.method_7909().method_7857() ? stack.method_7909().method_7858().method_7854() : class_1799.field_8037;
            if (amount > 0) {
                container.method_7939(container.method_7947() * amount);
            }
            if (stack.method_7947() <= amount) {
                this.method_5447(slot, container);
            } else {
                stack.method_7934(amount);
                player.method_31548().method_7398(container);
            }
        }
    }

    @Override
    public void onCraft(class_1657 player, class_1799 result, int amount) {
        class_1799 leftover;
        if (amount == 0 || this.field_11863 == null) {
            return;
        }
        IPartBuilderRecipe recipe = this.getPartRecipe();
        if (recipe == null) {
            return;
        }
        result.method_7982(this.field_11863, player, amount);
        ((ItemCraftedCallback)ItemCraftedCallback.EVENT.invoker()).onCraft(player, result, (class_1263)this.inventoryWrapper);
        this.playCraftSound(player);
        if (this.field_11863 != null && !this.field_11863.field_9236 && !(leftover = recipe.getLeftover(this.inventoryWrapper, this.selectedPattern)).method_7960()) {
            player.method_31548().method_7398(leftover);
        }
        this.shrinkSlot(0, recipe.getItemsUsed(this.inventoryWrapper), player);
        if (!this.method_5438(1).method_31573(TinkerTags.Items.REUSABLE_PATTERNS)) {
            this.shrinkSlot(1, 1, player);
        }
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.syncToRelevantPlayers(x$0 -> this.syncScreen((class_1657)x$0));
        }
    }

    public LazyResultContainer getCraftingResult() {
        return this.craftingResult;
    }

    public PartBuilderContainerWrapper getInventoryWrapper() {
        return this.inventoryWrapper;
    }
}

