/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tables.block.entity.table.PartBuilderBlockEntity;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.client.inventory.PartInfoPanelScreen;
import slimeknights.tconstruct.tables.menu.PartBuilderContainerMenu;

public class PartBuilderScreen
extends BaseTabbedScreen<PartBuilderBlockEntity, PartBuilderContainerMenu> {
    private static final class_2561 INFO_TEXT = TConstruct.makeTranslation("gui", "part_builder.info");
    private static final class_2561 TRAIT_TITLE = TConstruct.makeTranslation("gui", "part_builder.trait").method_27692(class_124.field_1073);
    private static final class_5250 UNCRAFTABLE_MATERIAL = TConstruct.makeTranslation("gui", "part_builder.uncraftable").method_27692(class_124.field_1061);
    private static final class_5250 UNCRAFTABLE_MATERIAL_TOOLTIP = TConstruct.makeTranslation("gui", "part_builder.uncraftable.tooltip");
    private static final class_2960 BACKGROUND = TConstruct.getResource("textures/gui/partbuilder.png");
    protected PartInfoPanelScreen infoPanelScreen;
    private float sliderProgress = 0.0f;
    private boolean clickedOnScrollBar;
    private int recipeIndexOffset = 0;

    public PartBuilderScreen(PartBuilderContainerMenu container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.infoPanelScreen = new PartInfoPanelScreen(this, (class_1703)container, playerInventory, title);
        this.infoPanelScreen.setTextScale(0.7777778f);
        this.infoPanelScreen.field_2779 = this.field_2779;
        this.addModule(this.infoPanelScreen);
        this.addChestSideInventory(playerInventory);
    }

    protected void method_2389(class_4587 matrices, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(matrices, BACKGROUND);
        this.method_25302(matrices, this.cornerX + 126, this.cornerY + 15 + (int)(41.0f * this.sliderProgress), 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        this.drawRecipesBackground(matrices, mouseX, mouseY, this.cornerX + 51, this.cornerY + 15);
        this.drawIconEmpty(matrices, ((PartBuilderContainerMenu)this.getMenu()).getPatternSlot(), Icons.PATTERN);
        this.drawIconEmpty(matrices, ((PartBuilderContainerMenu)this.getMenu()).getInputSlot(), Icons.INGOT);
        this.drawRecipesItems(matrices, this.cornerX + 51, this.cornerY + 15);
        super.method_2389(matrices, partialTicks, mouseX, mouseY);
    }

    private int getButtonAt(int mouseX, int mouseY) {
        List<Pattern> buttons = ((PartBuilderBlockEntity)this.tile).getSortedButtons();
        if (!buttons.isEmpty()) {
            int x = this.cornerX + 51;
            int y = this.cornerY + 15;
            int maxIndex = Math.min(this.recipeIndexOffset + 12, buttons.size());
            for (int l = this.recipeIndexOffset; l < maxIndex; ++l) {
                int relative = l - this.recipeIndexOffset;
                double buttonX = (double)mouseX - (double)(x + relative % 4 * 18);
                double buttonY = (double)mouseY - (double)(y + relative / 4 * 18);
                if (!(buttonX >= 0.0) || !(buttonY >= 0.0) || !(buttonX < 18.0) || !(buttonY < 18.0)) continue;
                return l;
            }
        }
        return -1;
    }

    protected void method_2380(class_4587 matrixStack, int mouseX, int mouseY) {
        int index;
        super.method_2380(matrixStack, mouseX, mouseY);
        List<Pattern> buttons = ((PartBuilderBlockEntity)this.tile).getSortedButtons();
        if (!buttons.isEmpty() && (index = this.getButtonAt(mouseX, mouseY)) >= 0) {
            this.method_25424(matrixStack, buttons.get(index).getDisplayName(), mouseX, mouseY);
        }
    }

    private void drawRecipesBackground(class_4587 matrices, int mouseX, int mouseY, int left, int top) {
        int max = Math.min(this.recipeIndexOffset + 12, this.getPartRecipeCount());
        for (int i = this.recipeIndexOffset; i < max; ++i) {
            int relative = i - this.recipeIndexOffset;
            int x = left + relative % 4 * 18;
            int y = top + relative / 4 * 18;
            int u = this.field_2779;
            if (i == ((PartBuilderBlockEntity)this.tile).getSelectedIndex()) {
                u += 18;
            } else if (mouseX >= x && mouseY >= y && mouseX < x + 18 && mouseY < y + 18) {
                u += 36;
            }
            this.method_25302(matrices, x, y, 0, u, 18, 18);
        }
    }

    private void drawRecipesItems(class_4587 matrices, int left, int top) {
        assert (this.field_22787 != null);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        Function spriteGetter = this.field_22787.method_1549(class_1723.field_21668);
        List<Pattern> list = ((PartBuilderBlockEntity)this.tile).getSortedButtons();
        int max = Math.min(this.recipeIndexOffset + 12, this.getPartRecipeCount());
        for (int i = this.recipeIndexOffset; i < max; ++i) {
            int relative = i - this.recipeIndexOffset;
            int x = left + relative % 4 * 18 + 1;
            int y = top + relative / 4 * 18 + 1;
            Pattern pattern = list.get(i);
            class_1058 sprite = (class_1058)spriteGetter.apply(pattern.getTexture());
            PartBuilderScreen.method_25298((class_4587)matrices, (int)x, (int)y, (int)100, (int)16, (int)16, (class_1058)sprite);
        }
    }

    @Override
    public void updateDisplay() {
        if (!this.canScroll()) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
        assert (this.tile != null);
        IMaterialValue materialRecipe = ((PartBuilderBlockEntity)this.tile).getMaterialRecipe();
        if (materialRecipe != null) {
            this.setDisplayForMaterial(materialRecipe);
        } else {
            this.infoPanelScreen.setCaption(this.method_25440());
            this.infoPanelScreen.setText(INFO_TEXT);
            this.infoPanelScreen.clearMaterialValue();
        }
        IPartBuilderRecipe partRecipe = ((PartBuilderBlockEntity)this.tile).getPartRecipe();
        boolean skipCost = false;
        if (partRecipe == null) {
            partRecipe = ((PartBuilderBlockEntity)this.tile).getFirstRecipe();
            skipCost = true;
        }
        if (partRecipe != null) {
            int cost = partRecipe.getCost();
            if (cost > 0 && !skipCost) {
                this.infoPanelScreen.setPatternCost(cost);
            } else {
                this.infoPanelScreen.clearPatternCost();
            }
            class_2561 title = partRecipe.getTitle();
            if (title != null) {
                this.infoPanelScreen.setCaption(title);
                this.infoPanelScreen.setText(partRecipe.getText(((PartBuilderBlockEntity)this.tile).getInventoryWrapper()));
            }
        } else {
            this.infoPanelScreen.clearPatternCost();
        }
    }

    private void setDisplayForMaterial(IMaterialValue materialRecipe) {
        MaterialVariant materialVariant = materialRecipe.getMaterial();
        this.infoPanelScreen.setCaption(MaterialTooltipCache.getColoredDisplayName(materialVariant.getVariant()));
        float value = materialRecipe.getMaterialValue(((PartBuilderBlockEntity)this.tile).getInventoryWrapper());
        class_2585 formatted = new class_2585(Util.COMMA_FORMAT.format(value));
        IPartBuilderRecipe partRecipe = ((PartBuilderBlockEntity)this.tile).getPartRecipe();
        if (partRecipe != null && value < (float)partRecipe.getCost()) {
            formatted = formatted.method_27692(class_124.field_1079);
        }
        this.infoPanelScreen.setMaterialValue((class_2561)formatted);
        LinkedList stats = Lists.newLinkedList();
        ArrayList tips = Lists.newArrayList();
        if (!materialVariant.get().isCraftable()) {
            stats.add(UNCRAFTABLE_MATERIAL);
            stats.add(class_2585.field_24366);
            tips.add(UNCRAFTABLE_MATERIAL_TOOLTIP);
            tips.add(class_2585.field_24366);
        }
        MaterialId id = materialVariant.getId();
        for (IMaterialStats stat : MaterialRegistry.getInstance().getAllStats(id)) {
            List<class_2561> info = stat.getLocalizedInfo();
            if (info.isEmpty()) continue;
            stats.add(stat.getLocalizedName().method_27692(class_124.field_1073));
            tips.add(class_2585.field_24366);
            stats.addAll(info);
            tips.addAll(stat.getLocalizedDescriptions());
            List<ModifierEntry> traits = MaterialRegistry.getInstance().getTraits(id, stat.getIdentifier());
            if (!traits.isEmpty()) {
                for (ModifierEntry trait : traits) {
                    Modifier mod = trait.getModifier();
                    stats.add(mod.getDisplayName(trait.getLevel()));
                    tips.add(mod.getDescription(trait.getLevel()));
                }
            }
            stats.add(class_2585.field_24366);
            tips.add(class_2585.field_24366);
        }
        if (!stats.isEmpty() && ((class_2561)stats.get(stats.size() - 1)).getString().isEmpty()) {
            stats.remove(stats.size() - 1);
            tips.remove(tips.size() - 1);
        }
        this.infoPanelScreen.setText(stats, tips);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        this.clickedOnScrollBar = false;
        if (this.infoPanelScreen.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        List<Pattern> buttons = ((PartBuilderBlockEntity)this.tile).getSortedButtons();
        if (!buttons.isEmpty()) {
            int index = this.getButtonAt((int)mouseX, (int)mouseY);
            assert (this.field_22787 != null && this.field_22787.field_1724 != null);
            if (index >= 0 && ((PartBuilderContainerMenu)this.getMenu()).method_7604((class_1657)this.field_22787.field_1724, index)) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                assert (this.field_22787.field_1761 != null);
                this.field_22787.field_1761.method_2900(((PartBuilderContainerMenu)this.getMenu()).field_7763, index);
                return true;
            }
            int x = this.cornerX + 126;
            int y = this.cornerY + 15;
            if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 54)) {
                this.clickedOnScrollBar = true;
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unknown) {
        if (this.infoPanelScreen.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.clickedOnScrollBar && this.canScroll()) {
            int i = this.cornerY + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = class_3532.method_15363((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unknown);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (super.method_25401(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = class_3532.method_15363((float)((float)((double)this.sliderProgress - delta / (double)i)), (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)(this.sliderProgress * (float)i + 0.5f) * 4;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        if (this.infoPanelScreen.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.method_25406(mouseX, mouseY, state);
    }

    @Override
    public void error(class_2561 message) {
        this.infoPanelScreen.setCaption(COMPONENT_ERROR);
        this.infoPanelScreen.setText(message);
    }

    @Override
    public void warning(class_2561 message) {
        this.infoPanelScreen.setCaption(COMPONENT_WARNING);
        this.infoPanelScreen.setText(message);
    }

    private int getPartRecipeCount() {
        return ((PartBuilderBlockEntity)this.tile).getSortedButtons().size();
    }

    private boolean canScroll() {
        return this.getPartRecipeCount() > 12;
    }

    private int getHiddenRows() {
        return (this.getPartRecipeCount() + 4 - 1) / 4 - 3;
    }
}

