/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TinkerTooltipFlags;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;
import slimeknights.tconstruct.tables.client.inventory.widget.SlotButtonItem;
import slimeknights.tconstruct.tables.client.inventory.widget.TinkerStationButtonsWidget;
import slimeknights.tconstruct.tables.menu.TinkerStationContainerMenu;
import slimeknights.tconstruct.tables.menu.slot.TinkerStationSlot;
import slimeknights.tconstruct.tables.network.TinkerStationSelectionPacket;

public class TinkerStationScreen
extends BaseTabbedScreen<TinkerStationBlockEntity, TinkerStationContainerMenu> {
    private static final class_2561 COMPONENTS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.components");
    private static final class_2561 MODIFIERS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.modifiers");
    private static final class_2561 UPGRADES_TEXT = TConstruct.makeTranslation("gui", "tinker_station.upgrades");
    private static final class_2561 TRAITS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.traits");
    private static final class_2561 ASCII_ANVIL = new class_2585("\n\n").method_27693("       .\n").method_27693("     /( _________\n").method_27693("     |  >:=========`\n").method_27693("     )(  \n").method_27693("     \"\"").method_27692(class_124.field_1063);
    private static final int STILL_FILLED_X = 112;
    private static final int STILL_FILLED_Y = 62;
    private static final int STILL_FILLED_SPACING = 18;
    private static final class_2960 TINKER_STATION_TEXTURE = TConstruct.getResource("textures/gui/tinker_station.png");
    private static final ElementScreen ACTIVE_TEXT_FIELD = new ElementScreen(0, 210, 91, 12, 256, 256);
    private static final ElementScreen ITEM_COVER = new ElementScreen(176, 18, 70, 64);
    private static final ElementScreen SLOT_BACKGROUND = new ElementScreen(176, 0, 18, 18);
    private static final ElementScreen SLOT_BORDER = new ElementScreen(194, 0, 18, 18);
    private static final ElementScreen SLOT_SPACE_TOP = new ElementScreen(0, 176, 18, 2);
    private static final ElementScreen SLOT_SPACE_BOTTOM = new ElementScreen(0, 174, 18, 2);
    private static final ElementScreen PANEL_SPACE_LEFT = new ElementScreen(0, 174, 5, 4);
    private static final ElementScreen PANEL_SPACE_RIGHT = new ElementScreen(9, 174, 9, 4);
    private static final ElementScreen LEFT_BEAM = new ElementScreen(0, 180, 2, 7);
    private static final ElementScreen RIGHT_BEAM = new ElementScreen(131, 180, 2, 7);
    private static final ScalableElementScreen CENTER_BEAM = new ScalableElementScreen(2, 180, 129, 7);
    public static final int COLUMN_COUNT = 5;
    protected ElementScreen buttonDecorationTop = SLOT_SPACE_TOP;
    protected ElementScreen buttonDecorationBot = SLOT_SPACE_BOTTOM;
    protected ElementScreen panelDecorationL = PANEL_SPACE_LEFT;
    protected ElementScreen panelDecorationR = PANEL_SPACE_RIGHT;
    protected ElementScreen leftBeam = new ElementScreen(0, 0, 0, 0);
    protected ElementScreen rightBeam = new ElementScreen(0, 0, 0, 0);
    protected ScalableElementScreen centerBeam = new ScalableElementScreen(0, 0, 0, 0);
    @Nonnull
    private final StationSlotLayout defaultLayout;
    @Nonnull
    private StationSlotLayout currentLayout;
    protected InfoPanelScreen tinkerInfo;
    protected InfoPanelScreen modifierInfo;
    protected TinkerStationButtonsWidget buttonsScreen;
    private final int maxInputs;
    protected int activeInputs;

    public TinkerStationScreen(TinkerStationContainerMenu container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.tinkerInfo = new InfoPanelScreen(this, (class_1703)container, playerInventory, title);
        this.tinkerInfo.setTextScale(0.8888889f);
        this.addModule(this.tinkerInfo);
        this.modifierInfo = new InfoPanelScreen(this, (class_1703)container, playerInventory, title);
        this.modifierInfo.setTextScale(0.7777778f);
        this.addModule(this.modifierInfo);
        this.tinkerInfo.yOffset = 5;
        this.modifierInfo.yOffset = this.tinkerInfo.field_2779 + 9;
        this.field_2779 = 174;
        int max = 5;
        TinkerStationBlockEntity te = (TinkerStationBlockEntity)container.getTile();
        if (te != null) {
            max = te.getInputCount();
        }
        this.maxInputs = max;
        if (max > 3) {
            this.metal();
        } else {
            this.wood();
        }
        this.defaultLayout = te == null ? StationSlotLayout.EMPTY : StationSlotLayoutLoader.getInstance().get(Objects.requireNonNull(te.method_11010().method_26204().getRegistryName()));
        this.currentLayout = this.defaultLayout;
        this.activeInputs = Math.min(this.defaultLayout.getInputCount(), max);
        this.field_22792 = false;
    }

    @Override
    public void method_25426() {
        assert (this.field_22787 != null);
        this.field_22787.field_1774.method_1462(true);
        this.field_2800 += 4;
        this.cornerY += 4;
        this.tinkerInfo.xOffset = 2;
        this.tinkerInfo.yOffset = this.centerBeam.h + this.panelDecorationL.h;
        this.modifierInfo.xOffset = this.tinkerInfo.xOffset;
        this.modifierInfo.yOffset = this.tinkerInfo.yOffset + this.tinkerInfo.field_2779 + 4;
        for (ModuleScreen module : this.modules) {
            module.field_2800 += 4;
        }
        super.method_25426();
        int buttonsStyle = this.maxInputs > 3 ? 1 : 2;
        ArrayList layouts = Lists.newArrayList();
        layouts.add(this.defaultLayout);
        layouts.addAll(StationSlotLayoutLoader.getInstance().getSortedSlots().stream().filter(layout -> layout.getInputSlots().size() <= this.maxInputs).toList());
        this.buttonsScreen = new TinkerStationButtonsWidget(this, this.cornerX - TinkerStationButtonsWidget.width(5) - 2, this.cornerY + this.centerBeam.h + this.buttonDecorationTop.h, layouts, buttonsStyle);
        this.updateLayout();
    }

    public void method_25419() {
        super.method_25419();
        assert (this.field_22787 != null);
        this.field_22787.field_1774.method_1462(false);
    }

    public void updateLayout() {
        int stillFilled = 0;
        for (int i = 0; i <= this.maxInputs; ++i) {
            TinkerStationSlot tinkerSlot;
            class_1735 slot = ((TinkerStationContainerMenu)this.getMenu()).method_7611(i);
            LayoutSlot layoutSlot = this.currentLayout.getSlot(i);
            if (layoutSlot.isHidden()) {
                slot.field_7873 = 112 - 18 * stillFilled;
                slot.field_7872 = 62;
                ++stillFilled;
                if (!(slot instanceof TinkerStationSlot)) continue;
                tinkerSlot = (TinkerStationSlot)slot;
                tinkerSlot.deactivate();
                continue;
            }
            slot.field_7873 = layoutSlot.getX();
            slot.field_7872 = layoutSlot.getY();
            if (!(slot instanceof TinkerStationSlot)) continue;
            tinkerSlot = (TinkerStationSlot)slot;
            tinkerSlot.activate(layoutSlot);
        }
        this.updateDisplay();
    }

    @Override
    public void updateDisplay() {
        if (this.tile == null) {
            return;
        }
        class_1799 toolStack = ((TinkerStationContainerMenu)this.getMenu()).getResult();
        ValidatedResult currentError = ((TinkerStationBlockEntity)this.tile).getCurrentError();
        if (currentError.hasError()) {
            this.error(currentError.getMessage());
            return;
        }
        if (toolStack.method_7960()) {
            toolStack = ((TinkerStationContainerMenu)this.getMenu()).method_7611(0).method_7677();
        }
        if (toolStack.method_31573(TinkerTags.Items.MODIFIABLE)) {
            class_2561 title;
            ToolStack tool = ToolStack.from(toolStack);
            class_1792 class_17922 = toolStack.method_7909();
            if (class_17922 instanceof ITinkerStationDisplay) {
                ITinkerStationDisplay display = (ITinkerStationDisplay)class_17922;
                this.tinkerInfo.setCaption(display.getLocalizedName());
                assert (this.field_22787 != null);
                this.tinkerInfo.setText(display.getStatInformation((IToolStackView)tool, (class_1657)this.field_22787.field_1724, new ArrayList<class_2561>(), SafeClientAccess.getTooltipKey(), (class_1836)TinkerTooltipFlags.TINKER_STATION));
            } else {
                this.tinkerInfo.setCaption(toolStack.method_7954());
                this.tinkerInfo.setText(new class_2561[0]);
            }
            ArrayList<class_2561> modifierNames = new ArrayList<class_2561>();
            ArrayList<class_2561> modifierInfo = new ArrayList<class_2561>();
            if (TinkerStationScreen.method_25441()) {
                title = TRAITS_TEXT;
                Map<Modifier, Integer> upgrades = tool.getUpgrades().getModifiers().stream().collect(Collectors.toMap(ModifierEntry::getModifier, ModifierEntry::getLevel));
                for (ModifierEntry entry : tool.getModifierList()) {
                    int level;
                    Modifier mod = entry.getModifier();
                    if (!mod.shouldDisplay(true) || (level = entry.getLevel() - upgrades.getOrDefault(mod, 0)) <= 0) continue;
                    modifierNames.add(mod.getDisplayName(tool, level));
                    modifierInfo.add(mod.getDescription(tool, level));
                }
            } else {
                List<ModifierEntry> modifiers;
                if (TinkerStationScreen.method_25442()) {
                    modifiers = tool.getUpgrades().getModifiers();
                    title = UPGRADES_TEXT;
                } else {
                    modifiers = tool.getModifierList();
                    title = MODIFIERS_TEXT;
                }
                for (ModifierEntry entry : modifiers) {
                    Modifier mod = entry.getModifier();
                    if (!mod.shouldDisplay(true)) continue;
                    int level = entry.getLevel();
                    modifierNames.add(mod.getDisplayName(tool, level));
                    modifierInfo.add(mod.getDescription(tool, level));
                }
            }
            this.modifierInfo.setCaption(title);
            this.modifierInfo.setText(modifierNames, modifierInfo);
        } else {
            this.tinkerInfo.setCaption(this.currentLayout.getDisplayName());
            this.tinkerInfo.setText(this.currentLayout.getDescription());
            class_2585 fullText = new class_2585("");
            boolean hasComponents = false;
            for (int i = 0; i <= this.activeInputs; ++i) {
                LayoutSlot layout = this.currentLayout.getSlot(i);
                String key = layout.getTranslationKey();
                if (layout.isHidden() || key.isEmpty()) continue;
                hasComponents = true;
                class_2585 textComponent = new class_2585(" * ");
                class_1799 slotStack = ((TinkerStationContainerMenu)this.getMenu()).method_7611(i).method_7677();
                if (!layout.isValid(slotStack)) {
                    textComponent.method_27692(class_124.field_1061);
                }
                textComponent.method_10852((class_2561)new class_2588(key)).method_27693("\n");
                fullText.method_10852((class_2561)textComponent);
            }
            if (hasComponents) {
                this.modifierInfo.setCaption(COMPONENTS_TEXT);
                this.modifierInfo.setText(new class_2561[]{fullText});
            } else {
                this.modifierInfo.setCaption(class_2585.field_24366);
                this.modifierInfo.setText(ASCII_ANVIL);
            }
        }
    }

    protected void drawContainerName(class_4587 matrixStack) {
        this.field_22793.method_30883(matrixStack, this.method_25440(), 8.0f, 8.0f, 0x404040);
    }

    private static void renderPattern(class_4587 matrices, Pattern pattern, int x, int y) {
        class_1058 sprite = class_310.method_1551().method_1554().method_24153(class_1723.field_21668).method_4608(pattern.getTexture());
        TinkerStationScreen.method_25298((class_4587)matrices, (int)x, (int)y, (int)100, (int)16, (int)16, (class_1058)sprite);
    }

    public static void renderIcon(class_4587 matrices, LayoutIcon icon, int x, int y) {
        Pattern pattern = icon.getValue(Pattern.class);
        class_310 minecraft = class_310.method_1551();
        if (pattern != null) {
            RenderUtils.setup(class_1723.field_21668);
            RenderSystem.applyModelViewMatrix();
            TinkerStationScreen.renderPattern(matrices, pattern, x, y);
            return;
        }
        class_1799 stack = icon.getValue(class_1799.class);
        if (stack != null) {
            minecraft.method_1480().method_4010(stack, x, y);
        }
    }

    protected void method_2389(class_4587 matrices, float partialTicks, int mouseX, int mouseY) {
        class_1735 slot;
        int i;
        this.drawBackground(matrices, TINKER_STATION_TEXTURE);
        int x = 0;
        int y = 0;
        float scale = 3.7f;
        float xOff = 12.5f;
        float yOff = 22.0f;
        class_4587 renderPose = RenderSystem.getModelViewStack();
        renderPose.method_22903();
        renderPose.method_22904(12.5, 22.0, 0.0);
        renderPose.method_22905(3.7f, 3.7f, 1.0f);
        TinkerStationScreen.renderIcon(matrices, this.currentLayout.getIcon(), (int)((float)this.cornerX / 3.7f), (int)((float)this.cornerY / 3.7f));
        renderPose.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderUtils.setup(TINKER_STATION_TEXTURE, 1.0f, 1.0f, 1.0f, 0.82f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        ITEM_COVER.draw(matrices, this.cornerX + 7, this.cornerY + 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.28f);
        if (!this.currentLayout.getToolSlot().isHidden()) {
            class_1735 slot2 = ((TinkerStationContainerMenu)this.getMenu()).method_7611(0);
            SLOT_BACKGROUND.draw(matrices, x + this.cornerX + slot2.field_7873 - 1, y + this.cornerY + slot2.field_7872 - 1);
        }
        for (i = 0; i < this.activeInputs; ++i) {
            slot = ((TinkerStationContainerMenu)this.getMenu()).method_7611(i + 1);
            SLOT_BACKGROUND.draw(matrices, x + this.cornerX + slot.field_7873 - 1, y + this.cornerY + slot.field_7872 - 1);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i <= this.maxInputs; ++i) {
            slot = ((TinkerStationContainerMenu)this.getMenu()).method_7611(i);
            if (!(slot instanceof TinkerStationSlot) || ((TinkerStationSlot)slot).isDormant() && !slot.method_7681()) continue;
            SLOT_BORDER.draw(matrices, x + this.cornerX + slot.field_7873 - 1, y + this.cornerY + slot.field_7872 - 1);
        }
        x = this.buttonsScreen.getLeftPos() - this.leftBeam.w;
        y = this.cornerY;
        x += this.leftBeam.draw(matrices, x, y);
        x += this.centerBeam.drawScaledX(matrices, x, y, this.buttonsScreen.getImageWidth());
        this.rightBeam.draw(matrices, x, y);
        x = this.tinkerInfo.field_2776 - this.leftBeam.w;
        x += this.leftBeam.draw(matrices, x, y);
        x += this.centerBeam.drawScaledX(matrices, x, y, this.tinkerInfo.field_2792);
        this.rightBeam.draw(matrices, x, y);
        for (SlotButtonItem button : this.buttonsScreen.getButtons()) {
            this.buttonDecorationTop.draw(matrices, button.field_22760, button.field_22761 - this.buttonDecorationTop.h);
            if (button.buttonId >= this.buttonsScreen.getButtons().size() - 5) continue;
            this.buttonDecorationBot.draw(matrices, button.field_22760, button.field_22761 + button.method_25364());
        }
        this.panelDecorationL.draw(matrices, this.tinkerInfo.field_2776 + 5, this.tinkerInfo.field_2800 - this.panelDecorationL.h);
        this.panelDecorationR.draw(matrices, this.tinkerInfo.guiRight() - 5 - this.panelDecorationR.w, this.tinkerInfo.field_2800 - this.panelDecorationR.h);
        this.panelDecorationL.draw(matrices, this.modifierInfo.field_2776 + 5, this.modifierInfo.field_2800 - this.panelDecorationL.h);
        this.panelDecorationR.draw(matrices, this.modifierInfo.guiRight() - 5 - this.panelDecorationR.w, this.modifierInfo.field_2800 - this.panelDecorationR.h);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        for (int i2 = 0; i2 <= this.maxInputs; ++i2) {
            Pattern icon;
            slot = ((TinkerStationContainerMenu)this.getMenu()).method_7611(i2);
            if (slot.method_7681() || (icon = this.currentLayout.getSlot(i2).getIcon()) == null) continue;
            TinkerStationScreen.renderPattern(matrices, icon, this.cornerX + slot.field_7873, this.cornerY + slot.field_7872);
        }
        RenderSystem.enableDepthTest();
        super.method_2389(matrices, partialTicks, mouseX, mouseY);
        this.buttonsScreen.method_25394(matrices, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.tinkerInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.modifierInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.buttonsScreen.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        if (this.tinkerInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.modifierInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        return super.method_25403(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.tinkerInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        if (this.modifierInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        if (this.tinkerInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        if (this.modifierInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        if (this.buttonsScreen.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.method_25406(mouseX, mouseY, state);
    }

    private static boolean needsDisplayUpdate(int keyCode) {
        if (keyCode == 340 || keyCode == 344) {
            return true;
        }
        if (class_310.field_1703) {
            return keyCode == 343 || keyCode == 347;
        }
        return keyCode == 341 || keyCode == 345;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public void method_2385(class_4587 matrixStack, class_1735 slotIn) {
        if (slotIn instanceof TinkerStationSlot && ((TinkerStationSlot)slotIn).isDormant() && !slotIn.method_7681()) {
            return;
        }
        super.method_2385(matrixStack, slotIn);
    }

    public boolean method_2387(class_1735 slotIn, double mouseX, double mouseY) {
        if (slotIn instanceof TinkerStationSlot && ((TinkerStationSlot)slotIn).isDormant() && !slotIn.method_7681()) {
            return false;
        }
        return super.method_2387(slotIn, mouseX, mouseY);
    }

    protected void wood() {
        this.tinkerInfo.wood();
        this.modifierInfo.wood();
        this.buttonDecorationTop = SLOT_SPACE_TOP.shift(TinkerStationScreen.SLOT_SPACE_TOP.w, 0);
        this.buttonDecorationBot = SLOT_SPACE_BOTTOM.shift(TinkerStationScreen.SLOT_SPACE_BOTTOM.w, 0);
        this.panelDecorationL = PANEL_SPACE_LEFT.shift(18, 0);
        this.panelDecorationR = PANEL_SPACE_RIGHT.shift(18, 0);
        this.leftBeam = LEFT_BEAM;
        this.rightBeam = RIGHT_BEAM;
        this.centerBeam = CENTER_BEAM;
    }

    protected void metal() {
        this.tinkerInfo.metal();
        this.modifierInfo.metal();
        this.buttonDecorationTop = SLOT_SPACE_TOP.shift(TinkerStationScreen.SLOT_SPACE_TOP.w * 2, 0);
        this.buttonDecorationBot = SLOT_SPACE_BOTTOM.shift(TinkerStationScreen.SLOT_SPACE_BOTTOM.w * 2, 0);
        this.panelDecorationL = PANEL_SPACE_LEFT.shift(36, 0);
        this.panelDecorationR = PANEL_SPACE_RIGHT.shift(36, 0);
        this.leftBeam = LEFT_BEAM.shift(0, TinkerStationScreen.LEFT_BEAM.h);
        this.rightBeam = RIGHT_BEAM.shift(0, TinkerStationScreen.RIGHT_BEAM.h);
        this.centerBeam = CENTER_BEAM.shift(0, TinkerStationScreen.CENTER_BEAM.h);
    }

    @Override
    public void error(class_2561 message) {
        this.tinkerInfo.setCaption(COMPONENT_ERROR);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption(class_2585.field_24366);
        this.modifierInfo.setText(class_2585.field_24366);
    }

    @Override
    public void warning(class_2561 message) {
        this.tinkerInfo.setCaption(COMPONENT_WARNING);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption(class_2585.field_24366);
        this.modifierInfo.setText(class_2585.field_24366);
    }

    public void onToolSelection(StationSlotLayout layout) {
        this.activeInputs = Math.min(layout.getInputCount(), this.maxInputs);
        this.currentLayout = layout;
        this.updateLayout();
        TinkerNetwork.getInstance().sendToServer((ISimplePacket)new TinkerStationSelectionPacket(layout.getName()));
    }

    @Override
    public List<class_768> getModuleAreas() {
        List<class_768> list = super.getModuleAreas();
        list.add(this.buttonsScreen.getArea());
        return list;
    }

    @Override
    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.buttonsScreen.method_25405(mouseX, mouseY);
    }

    @Nonnull
    public StationSlotLayout getDefaultLayout() {
        return this.defaultLayout;
    }

    @Nonnull
    public StationSlotLayout getCurrentLayout() {
        return this.currentLayout;
    }

    public int getMaxInputs() {
        return this.maxInputs;
    }
}

