/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3908;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_638;
import net.minecraft.class_6382;
import net.minecraft.class_768;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.TabsWidget;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.tables.block.ITabbedBlock;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.network.StationTabPacket;

public class TinkerTabsWidget
implements class_4068,
class_364,
class_6379 {
    private static final class_2960 TAB_IMAGE = TConstruct.getResource("textures/gui/icons.png");
    protected static final ElementScreen TAB_ELEMENT = new ElementScreen(0, 18, 26, 30, 256, 256);
    protected static final ElementScreen ACTIVE_TAB_L_ELEMENT = new ElementScreen(26, 18, 26, 30, 256, 256);
    protected static final ElementScreen ACTIVE_TAB_C_ELEMENT = new ElementScreen(52, 18, 26, 30, 256, 256);
    protected static final ElementScreen ACTIVE_TAB_R_ELEMENT = new ElementScreen(78, 18, 26, 30, 256, 256);
    private final int leftPos;
    private final int topPos;
    private final int imageWidth;
    private final int imageHeight;
    private final TabsWidget tabs;
    private final List<class_2338> tabData;
    private final BaseTabbedScreen<?, ?> parent;

    public TinkerTabsWidget(BaseTabbedScreen<?, ?> parent) {
        this.parent = parent;
        List<Pair<class_1799, class_2338>> tabs = TinkerTabsWidget.collectTabs(Screens.getClient(this.parent), (TabbedContainerMenu)this.parent.getMenu());
        this.tabs = new TabsWidget(parent, TAB_ELEMENT, TAB_ELEMENT, TAB_ELEMENT, ACTIVE_TAB_L_ELEMENT, ACTIVE_TAB_C_ELEMENT, ACTIVE_TAB_R_ELEMENT);
        this.tabs.tabsResource = TAB_IMAGE;
        int count = tabs.size();
        this.imageWidth = count * TinkerTabsWidget.ACTIVE_TAB_C_ELEMENT.w + (count - 1) * this.tabs.spacing;
        this.imageHeight = TinkerTabsWidget.ACTIVE_TAB_C_ELEMENT.h;
        this.leftPos = parent.cornerX + 4;
        this.topPos = parent.cornerY - this.imageHeight;
        this.tabs.setPosition(this.leftPos, this.topPos);
        tabs.stream().map(Pair::getLeft).forEach(arg_0 -> ((TabsWidget)this.tabs).addTab(arg_0));
        this.tabData = tabs.stream().map(Pair::getRight).toList();
        Object blockEntity = this.parent.getTileEntity();
        if (blockEntity != null) {
            this.selectTabForPos(blockEntity.method_11016());
        }
    }

    private static List<Pair<class_1799, class_2338>> collectTabs(class_310 minecraft, TabbedContainerMenu<?> menu) {
        ArrayList tabs = Lists.newArrayList();
        class_638 level = minecraft.field_1687;
        if (level != null) {
            for (Pair<class_2338, class_2680> pair : menu.stationBlocks) {
                class_1799 stack;
                class_2680 state = (class_2680)pair.getRight();
                class_2338 blockPos = (class_2338)pair.getLeft();
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof BlockPickInteractionAware) {
                    BlockPickInteractionAware pickInteractionAware = (BlockPickInteractionAware)class_22482;
                    stack = pickInteractionAware.getPickedStack(state, (class_1922)level, blockPos, (class_1657)minecraft.field_1724, null);
                    tabs.add(Pair.of((Object)stack, (Object)blockPos));
                    continue;
                }
                stack = state.method_26204().method_9574((class_1922)level, blockPos, state);
                tabs.add(Pair.of((Object)stack, (Object)blockPos));
            }
        }
        return tabs;
    }

    private void selectTabForPos(class_2338 pos) {
        for (int i = 0; i < this.tabData.size(); ++i) {
            if (!this.tabData.get(i).equals((Object)pos)) continue;
            this.tabs.selected = i;
            return;
        }
    }

    private void onNewTabSelection(class_2338 pos) {
        class_2680 state;
        assert (Screens.getClient(this.parent) != null);
        class_638 level = Screens.getClient(this.parent).field_1687;
        if (level != null && (state = level.method_8320(pos)).method_26204() instanceof ITabbedBlock) {
            TinkerNetwork.getInstance().sendToServer((ISimplePacket)new StationTabPacket(pos));
            Screens.getClient(this.parent).method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)(this.leftPos - 1) && mouseX < (double)(this.guiRight() + 1) && mouseY >= (double)(this.topPos - 1) && mouseY < (double)(this.guiBottom() + 1);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (this.method_25405(mouseX, mouseY)) {
            this.tabs.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.tabs.handleMouseReleased();
        return true;
    }

    public int guiRight() {
        return this.leftPos + this.imageWidth;
    }

    public int guiBottom() {
        return this.topPos + this.imageHeight;
    }

    public class_768 getArea() {
        return new class_768(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sel = this.tabs.selected;
        this.tabs.update(mouseX, mouseY);
        this.tabs.draw(poseStack);
        if (sel != this.tabs.selected && 0 <= this.tabs.selected && this.tabs.selected < this.tabData.size()) {
            this.onNewTabSelection(this.tabData.get(this.tabs.selected));
        }
        this.renterTooltip(poseStack, mouseX, mouseY);
    }

    protected void renterTooltip(class_4587 poseStack, int mouseX, int mouseY) {
        class_638 world = Screens.getClient(this.parent).field_1687;
        if (this.tabs.highlighted > -1 && world != null) {
            class_2338 pos = this.tabData.get(this.tabs.highlighted);
            class_2586 te = world.method_8321(pos);
            Object title = te instanceof class_3908 ? ((class_3908)te).method_5476() : world.method_8320(pos).method_26204().method_9518();
            this.parent.method_30901(poseStack, Lists.newArrayList((Object[])new class_2561[]{title}), mouseX, mouseY);
        }
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationOutput) {
    }
}

