/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.menu;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.transfer.TransferUtil;
import slimeknights.mantle.transfer.item.IItemHandler;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.inventory.TriggeringMultiModuleContainerMenu;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.ITabbedBlock;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.menu.module.SideInventoryContainer;

public class TabbedContainerMenu<TILE extends class_2586>
extends TriggeringMultiModuleContainerMenu<TILE> {
    private static final TinkerBlockComp COMPARATOR = new TinkerBlockComp();
    public final List<Pair<class_2338, class_2680>> stationBlocks = Lists.newLinkedList();

    public TabbedContainerMenu(class_3917<?> containerType, int id, @Nullable class_1661 inv, @Nullable TILE tile) {
        super(containerType, id, inv, tile);
        if (tile != null && tile.method_10997() != null) {
            this.detectStationParts(tile.method_10997(), tile.method_11016());
        }
    }

    public void detectStationParts(class_1937 world, class_2338 start) {
        HashSet visited = Sets.newHashSet();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        queue.add(start);
        while (!queue.isEmpty()) {
            class_2680 state;
            class_2338 pos = (class_2338)queue.poll();
            if (visited.contains(pos) || !((state = world.method_8320(pos)).method_26204() instanceof ITabbedBlock)) continue;
            for (class_2350 direction : class_2350.values()) {
                class_2338 offset = pos.method_10093(direction);
                if (visited.contains(offset)) continue;
                queue.add(offset);
            }
            visited.add(pos);
            this.stationBlocks.add((Pair<class_2338, class_2680>)Pair.of((Object)pos, (Object)state));
            if (this.stationBlocks.size() < 6) continue;
            break;
        }
        this.stationBlocks.sort(COMPARATOR);
    }

    protected void addChestSideInventory() {
        if (this.tile == null || this.inv == null) {
            return;
        }
        class_1937 world = this.tile.method_10997();
        if (world != null) {
            class_2586 inventoryTE = null;
            class_2350 accessDir = null;
            class_2338 pos = this.tile.method_11016();
            block0: for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 neighbor = pos.method_10093(dir);
                for (Pair<class_2338, class_2680> tinkerPos : this.stationBlocks) {
                    if (!((class_2338)tinkerPos.getLeft()).equals((Object)neighbor)) continue;
                    continue block0;
                }
                class_2586 te = world.method_8321(neighbor);
                if (te == null || !TabbedContainerMenu.isUsable(te, this.inv.field_7546)) continue;
                if (TabbedContainerMenu.hasItemHandler(te, null)) {
                    inventoryTE = te;
                    accessDir = null;
                    break;
                }
                class_2350 side = dir.method_10153();
                if (!TabbedContainerMenu.hasItemHandler(te, side)) continue;
                inventoryTE = te;
                accessDir = side;
                break;
            }
            if (inventoryTE != null) {
                int invSlots = ((IItemHandler)TransferUtil.getItemHandler(inventoryTE, accessDir).orElse((Object)EmptyItemHandler.INSTANCE)).getSlots();
                int columns = class_3532.method_15340((int)((invSlots - 1) / 9 + 1), (int)3, (int)6);
                this.addSubContainer((class_1703)new SideInventoryContainer<class_2586>((class_3917)TinkerTables.craftingStationContainer.get(), this.field_7763, this.inv, inventoryTE, accessDir, -114, 8, columns), false);
            }
        }
    }

    private static boolean isUsable(class_2586 tileEntity, class_1657 player) {
        return !RegistryHelper.contains((class_2378)class_2378.field_11137, TinkerTags.TileEntityTypes.CRAFTING_STATION_BLACKLIST, (Object)tileEntity.method_11017()) && (!(tileEntity instanceof class_1263) || ((class_1263)tileEntity).method_5443(player));
    }

    private static boolean hasItemHandler(class_2586 tileEntity, @Nullable class_2350 direction) {
        class_1263 container;
        return tileEntity instanceof class_1263 && TransferUtil.simplifyItem((Storage)InventoryStorage.of((class_1263)(container = (class_1263)tileEntity), (class_2350)direction)).isPresent();
    }

    public void updateScreen() {
        if (this.tile != null && this.tile.method_10997() != null && this.tile.method_10997().field_9236 && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientOnly.clientScreenUpdate();
        }
    }

    public void error(class_5250 message) {
        if (this.tile != null && this.tile.method_10997() != null && this.tile.method_10997().field_9236 && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientOnly.clientError(message);
        }
    }

    public void warning(class_5250 message) {
        if (this.tile != null && this.tile.method_10997() != null && this.tile.method_10997().field_9236 && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientOnly.clientWarning(message);
        }
    }

    private static class TinkerBlockComp
    implements Comparator<Pair<class_2338, class_2680>> {
        private TinkerBlockComp() {
        }

        @Override
        public int compare(Pair<class_2338, class_2680> o1, Pair<class_2338, class_2680> o2) {
            int sum2;
            class_2338 pos1 = (class_2338)o1.getLeft();
            class_2338 pos2 = (class_2338)o2.getLeft();
            int sum1 = pos1.method_10263() + pos1.method_10264() + pos1.method_10260();
            if (sum1 != (sum2 = pos2.method_10263() + pos2.method_10264() + pos2.method_10260())) {
                return Integer.compare(sum1, sum2);
            }
            if (pos1.method_10264() != pos2.method_10264()) {
                return Integer.compare(pos1.method_10264(), pos2.method_10264());
            }
            if (pos1.method_10263() != pos2.method_10263()) {
                return Integer.compare(pos1.method_10263(), pos2.method_10263());
            }
            return Integer.compare(pos1.method_10260(), pos2.method_10260());
        }
    }

    private static class ClientOnly {
        private ClientOnly() {
        }

        private static void clientScreenUpdate() {
            class_437 screen = class_310.method_1551().field_1755;
            if (screen instanceof BaseTabbedScreen) {
                ((BaseTabbedScreen)screen).updateDisplay();
            }
        }

        private static void clientError(class_5250 errorMessage) {
            class_437 screen = class_310.method_1551().field_1755;
            if (screen instanceof BaseTabbedScreen) {
                ((BaseTabbedScreen)screen).error((class_2561)errorMessage);
            }
        }

        private static void clientWarning(class_5250 warningMessage) {
            class_437 screen = class_310.method_1551().field_1755;
            if (screen instanceof BaseTabbedScreen) {
                ((BaseTabbedScreen)screen).warning((class_2561)warningMessage);
            }
        }
    }
}

