/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.menu.slot.LazyResultSlot;
import slimeknights.tconstruct.tables.menu.slot.TinkerStationSlot;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class TinkerStationContainerMenu
extends TabbedContainerMenu<TinkerStationBlockEntity> {
    private static final class_2960[] ARMOR_SLOT_BACKGROUNDS = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private final List<class_1735> inputSlots;
    private final LazyResultSlot resultSlot;

    public TinkerStationContainerMenu(int id, class_1661 inv, @Nullable TinkerStationBlockEntity tile) {
        super((class_3917)TinkerTables.tinkerStationContainer.get(), id, inv, tile);
        if (tile != null) {
            tile.syncRecipe(inv.field_7546);
            this.inputSlots = new ArrayList<class_1735>();
            this.inputSlots.add(this.method_7621(new TinkerStationSlot(tile, 0, 0, 0)));
            for (int index = 0; index < tile.method_5439() - 1; ++index) {
                this.inputSlots.add(this.method_7621(new TinkerStationSlot(tile, index + 1, 0, 0)));
            }
            this.resultSlot = new LazyResultSlot(tile.getCraftingResult(), 114, 38);
            this.method_7621(this.resultSlot);
            this.setToolSelection(StationSlotLayoutLoader.getInstance().get(Objects.requireNonNull(tile.method_11010().method_26204().getRegistryName())));
        } else {
            this.resultSlot = null;
            this.inputSlots = Collections.emptyList();
        }
        for (ArmorSlotType slotType : ArmorSlotType.values()) {
            int index = slotType.getIndex();
            this.method_7621(new ArmorSlot(inv, slotType.getEquipmentSlot(), 152, 16 + (3 - index) * 18));
        }
        this.method_7621(new class_1735((class_1263)inv, 40, 132, 70).setBackground(class_1723.field_21668, class_1723.field_21673));
        this.addInventorySlots();
    }

    public TinkerStationContainerMenu(int id, class_1661 inv, class_2540 buf) {
        this(id, inv, (TinkerStationBlockEntity)TinkerStationContainerMenu.getTileEntityFromBuf((class_2540)buf, TinkerStationBlockEntity.class));
    }

    protected int getInventoryYOffset() {
        return 92;
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot != this.resultSlot && super.method_7613(stack, slot);
    }

    public void setToolSelection(StationSlotLayout layout) {
        assert (this.tile != null);
        int maxSize = ((TinkerStationBlockEntity)this.tile).method_5439();
        for (int i = 0; i < maxSize; ++i) {
            class_1735 slot = (class_1735)this.field_7761.get(i);
            if (!(slot instanceof TinkerStationSlot)) continue;
            TinkerStationSlot slotToolPart = (TinkerStationSlot)slot;
            LayoutSlot layoutSlot = layout.getSlot(i);
            if (layoutSlot.isHidden()) {
                slotToolPart.deactivate();
                continue;
            }
            slotToolPart.activate(layoutSlot);
        }
    }

    public class_1799 getResult() {
        return this.resultSlot.method_7677();
    }

    public List<class_1735> getInputSlots() {
        return this.inputSlots;
    }

    private static class ArmorSlot
    extends class_1735 {
        private final class_1657 player;
        private final class_1304 slotType;

        public ArmorSlot(class_1661 inv, class_1304 slotType, int xPosition, int yPosition) {
            super((class_1263)inv, 36 + slotType.method_5927(), xPosition, yPosition);
            this.player = inv.field_7546;
            this.slotType = slotType;
            this.setBackground(class_1723.field_21668, ARMOR_SLOT_BACKGROUNDS[slotType.method_5927()]);
        }

        public int method_7675() {
            return 1;
        }

        public boolean method_7680(class_1799 stack) {
            return class_1308.method_32326((class_1799)stack) == this.slotType;
        }

        public boolean method_7674(class_1657 player) {
            class_1799 stack = this.method_7677();
            return stack.method_7960() || player.method_7337() || !class_1890.method_8224((class_1799)stack);
        }
    }
}

