/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.PartBuilderContainerWrapper;

public class PartBuilderToolRecycle
implements IPartBuilderRecipe {
    private static final class_2561 TOOL_RECYCLING = TConstruct.makeTranslation("recipe", "tool_recycling");
    private static final List<class_2561> INSTRUCTIONS = Collections.singletonList(TConstruct.makeTranslation("recipe", "tool_recycling.info"));
    private static final List<class_2561> NO_MODIFIERS = Collections.singletonList(TConstruct.makeTranslation("recipe", "tool_recycling.no_modifiers").method_27692(class_124.field_1061));
    private static final Pattern ERROR = new Pattern("tconstruct", "missingno");
    private final class_2960 id;
    private final class_1856 pattern;

    @Override
    public Pattern getPattern() {
        return ERROR;
    }

    @Override
    public Stream<Pattern> getPatterns(IPartBuilderContainer inv) {
        return ToolStack.from(inv.getStack()).getDefinition().getData().getParts().stream().map(PartRequirement::getPart).filter(Objects::nonNull).map(part -> part.method_8389().getRegistryName()).filter(Objects::nonNull).distinct().map(Pattern::new);
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int getItemsUsed(IPartBuilderContainer inv) {
        return 1;
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        return this.pattern.method_8093(inv.getPatternStack()) && inv.getStack().method_31573(TinkerTags.Items.MULTIPART_TOOL);
    }

    public boolean matches(IPartBuilderContainer inv, class_1937 pLevel) {
        return this.partialMatch(inv) && ToolStack.from(inv.getStack()).getUpgrades().isEmpty();
    }

    @Override
    public class_1799 assemble(IPartBuilderContainer inv, Pattern pattern) {
        ToolStack tool = ToolStack.from(inv.getStack());
        IMaterialItem match = null;
        int matchIndex = -1;
        List<PartRequirement> requirements = tool.getDefinition().getData().getParts();
        for (int i = 0; i < requirements.size(); ++i) {
            IToolPart part = requirements.get(i).getPart();
            if (part == null || !pattern.equals(part.method_8389().getRegistryName())) continue;
            matchIndex = i;
            match = part;
            break;
        }
        if (match == null) {
            return class_1799.field_8037;
        }
        return match.withMaterial(tool.getMaterial(matchIndex).getVariant());
    }

    @Override
    public class_1799 getLeftover(PartBuilderContainerWrapper inv, Pattern pattern) {
        int max;
        ToolStack tool = ToolStack.from(inv.getStack());
        int damage = tool.getDamage();
        if (damage > 0 && TConstruct.RANDOM.nextInt(max = tool.getStats().getInt(ToolStats.DURABILITY)) < damage) {
            return class_1799.field_8037;
        }
        ArrayList<IToolPart> parts = new ArrayList<IToolPart>();
        IntArrayList indices = new IntArrayList();
        boolean found = false;
        List<PartRequirement> requirements = tool.getDefinition().getData().getParts();
        for (int i = 0; i < requirements.size(); ++i) {
            IToolPart part = requirements.get(i).getPart();
            if (part == null) continue;
            if (found || !pattern.equals(part.method_8389().getRegistryName())) {
                parts.add(part);
                indices.add(i);
                continue;
            }
            found = true;
        }
        if (parts.isEmpty()) {
            return class_1799.field_8037;
        }
        int index = TConstruct.RANDOM.nextInt(parts.size());
        return ((IToolPart)parts.get(index)).withMaterial(tool.getMaterial(indices.getInt(index)).getVariant());
    }

    @Deprecated
    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerTables.partBuilderToolRecycling.get();
    }

    @Override
    @Nullable
    public class_2561 getTitle() {
        return TOOL_RECYCLING;
    }

    @Override
    public List<class_2561> getText(IPartBuilderContainer inv) {
        return ModifierUtil.hasUpgrades(inv.getStack()) ? NO_MODIFIERS : INSTRUCTIONS;
    }

    public PartBuilderToolRecycle(class_2960 id, class_1856 pattern) {
        this.id = id;
        this.pattern = pattern;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public static class Finished
    implements class_2444 {
        private final class_2960 id;
        private final class_1856 pattern;

        public void method_10416(JsonObject json) {
            json.add("pattern", this.pattern.method_8089());
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerTables.partBuilderToolRecycling.get();
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }

        public Finished(class_2960 id, class_1856 pattern) {
            this.id = id;
            this.pattern = pattern;
        }

        public class_2960 method_10417() {
            return this.id;
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<PartBuilderToolRecycle> {
        public PartBuilderToolRecycle fromJson(class_2960 id, JsonObject json) {
            return new PartBuilderToolRecycle(id, class_1856.method_8102((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"pattern")));
        }

        protected void toNetworkSafe(class_2540 buffer, PartBuilderToolRecycle recipe) {
            recipe.pattern.method_8088(buffer);
        }

        @Nullable
        protected PartBuilderToolRecycle fromNetworkSafe(class_2960 id, class_2540 buffer) {
            return new PartBuilderToolRecycle(id, class_1856.method_8086((class_2540)buffer));
        }
    }
}

