/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationPartSwapping
implements ITinkerStationRecipe {
    private static final ValidatedResult TOO_MANY_PARTS = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_many_parts"), new Object[0]);
    protected final class_2960 id;

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        class_1799 tinkerable = inv.getTinkerableStack();
        if (tinkerable.method_7960() || !tinkerable.method_31573(TinkerTags.Items.MULTIPART_TOOL) || !(tinkerable.method_7909() instanceof IModifiable)) {
            return false;
        }
        List<PartRequirement> parts = ((IModifiable)tinkerable.method_7909()).getToolDefinition().getData().getParts();
        if (parts.isEmpty()) {
            return false;
        }
        boolean foundItem = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960()) continue;
            if (foundItem) {
                return false;
            }
            class_1792 item = stack.method_7909();
            if (!(item instanceof IToolPart) || parts.stream().noneMatch(p -> p.matches(item))) {
                return false;
            }
            foundItem = true;
        }
        return foundItem;
    }

    @Deprecated
    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        class_1799 tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        List<PartRequirement> parts = tool.getDefinition().getData().getParts();
        if (parts.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 result;
            ValidatedResult toolValidation;
            int cost;
            IRepairableMaterialStats r;
            IRepairableMaterialStats repairable;
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            if (!(item instanceof IToolPart)) {
                return ValidatedResult.PASS;
            }
            IToolPart part = (IToolPart)item;
            MaterialVariantId partVariant = part.getMaterial(stack);
            if (partVariant.equals(IMaterial.UNKNOWN_ID)) {
                return ValidatedResult.PASS;
            }
            int index = i;
            if (!(i < parts.size() && parts.get(i).matches(item) || (index = IntStream.range(0, parts.size()).filter(pi -> ((PartRequirement)parts.get(pi)).matches(item)).findFirst().orElse(-1)) != -1)) {
                return ValidatedResult.PASS;
            }
            MaterialVariant toolVariant = tool.getMaterial(index);
            boolean didChange = !toolVariant.sameVariant(partVariant);
            IMaterialStats stats = MaterialRegistry.getInstance().getMaterialStats(partVariant.getId(), part.getStatType()).orElse(null);
            IRepairableMaterialStats iRepairableMaterialStats = repairable = stats instanceof IRepairableMaterialStats ? (r = (IRepairableMaterialStats)stats) : null;
            if (!(didChange || tool.getDamage() != 0 && repairable != null)) {
                return ValidatedResult.PASS;
            }
            tool = tool.copy();
            List<Modifier> actuallyRemoved = Collections.emptyList();
            if (didChange) {
                Modifier modifier;
                HashMap<Modifier, Integer> removedTraits = new HashMap<Modifier, Integer>();
                for (ModifierEntry iterator : MaterialRegistry.getInstance().getTraits(toolVariant.getId(), part.getStatType())) {
                    removedTraits.put(iterator.getModifier(), iterator.getLevel());
                }
                for (ModifierEntry modifierEntry : MaterialRegistry.getInstance().getTraits(partVariant.getId(), part.getStatType())) {
                    modifier = modifierEntry.getModifier();
                    if (!removedTraits.containsKey(modifier)) continue;
                    int value = (Integer)removedTraits.get(modifier) - modifierEntry.getLevel();
                    if (value <= 0) {
                        removedTraits.remove(modifier);
                        continue;
                    }
                    removedTraits.put(modifier, value);
                }
                actuallyRemoved = new ArrayList<Modifier>();
                for (Map.Entry entry : removedTraits.entrySet()) {
                    modifier = (Modifier)entry.getKey();
                    if (tool.getModifierLevel(modifier) > (Integer)entry.getValue()) continue;
                    modifier.beforeRemoved(tool, tool.getRestrictedNBT());
                    actuallyRemoved.add(modifier);
                }
                tool.replaceMaterial(index, partVariant);
                for (Modifier modifier2 : actuallyRemoved) {
                    modifier2.onRemoved(tool);
                }
            }
            if (repairable != null && (cost = MaterialCastingLookup.getItemCost(part)) > 0) {
                ModifierEntry entry;
                float factor = (float)cost / 3.0f;
                Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                while (iterator.hasNext() && !((factor = (entry = iterator.next()).getModifier().getRepairFactor(tool, entry.getLevel(), factor)) <= 0.0f)) {
                }
                if (factor > 0.0f) {
                    ToolDamageUtil.repair(tool, (int)((float)repairable.getDurability() * factor));
                }
            }
            if ((toolValidation = ModifierRecipeLookup.checkRequirements(result = tool.createStack(Math.min(tinkerable.method_7947(), this.shrinkToolSlotBy())), tool)).hasError()) {
                return toolValidation;
            }
            toolValidation = tool.validate();
            if (toolValidation.hasError()) {
                return toolValidation;
            }
            for (Modifier modifier : actuallyRemoved) {
                toolValidation = modifier.validate(tool, 0);
                if (!toolValidation.hasError()) continue;
                return toolValidation;
            }
            return ValidatedResult.success(result);
        }
        return ValidatedResult.PASS;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerTables.tinkerStationPartSwappingSerializer.get();
    }

    public TinkerStationPartSwapping(class_2960 id) {
        this.id = id;
    }

    public class_2960 method_8114() {
        return this.id;
    }
}

