/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerToolParts;

public class TinkerStationRepairRecipe
implements ITinkerStationRecipe {
    protected static final ValidatedResult FULLY_REPAIRED = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "tool_repair.fully_repaired"), new Object[0]);
    private static final IntConsumer NO_ACTION = i -> {};
    private final class_2960 id;

    public static int getRepairIndex(IToolStackView tool, MaterialId material) {
        for (int part : tool.getDefinition().getRepairParts()) {
            if (!tool.getMaterial(part).getId().equals(material)) continue;
            return part;
        }
        return -1;
    }

    protected static MaterialId getMaterialFrom(ITinkerStationContainer inv, int slot) {
        class_1799 item = inv.getInput(slot);
        if (item.method_7909() == TinkerToolParts.repairKit.get()) {
            return IMaterialItem.getMaterialFromStack(item).getId();
        }
        MaterialRecipe recipe = inv.getInputMaterial(slot);
        if (recipe != null) {
            return recipe.getMaterial().getId();
        }
        return IMaterial.UNKNOWN_ID;
    }

    @Nullable
    public static MaterialStatsId getDefaultStatsId(IToolStackView tool, MaterialId repairMaterial) {
        int repairIndex = TinkerStationRepairRecipe.getRepairIndex(tool, repairMaterial);
        if (repairIndex < 0) {
            return null;
        }
        return tool.getDefinition().getData().getParts().get(repairIndex).getStatType();
    }

    protected float getRepairPerItem(ToolStack tool, ITinkerStationContainer inv, int slot, MaterialId repairMaterial) {
        class_1799 stack = inv.getInput(slot);
        ToolDefinitionData toolData = tool.getDefinition().getData();
        if (stack.method_7909() == TinkerToolParts.repairKit.get()) {
            return (float)(MaterialRecipe.getRepairDurability(toolData, repairMaterial, TinkerStationRepairRecipe.getDefaultStatsId(tool, repairMaterial)) * 2) / 3.0f;
        }
        MaterialRecipe recipe = inv.getInputMaterial(slot);
        if (recipe != null) {
            if (stack.method_7909() instanceof IToolPart) {
                return recipe.getRepairPerItem(toolData, ((IToolPart)stack.method_7909()).getStatType());
            }
            return recipe.getRepairPerItem(toolData, TinkerStationRepairRecipe.getDefaultStatsId(tool, repairMaterial));
        }
        return 0.0f;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        class_1799 tinkerable = inv.getTinkerableStack();
        if (tinkerable.method_7960() || !tinkerable.method_31573(TinkerTags.Items.MULTIPART_TOOL) || !tinkerable.method_31573(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        MaterialId material = null;
        ToolStack tool = ToolStack.from(tinkerable);
        if (!tool.getDefinition().isMultipart()) {
            return false;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960()) continue;
            MaterialId inputMaterial = TinkerStationRepairRecipe.getMaterialFrom(inv, i);
            if (inputMaterial.equals(IMaterial.UNKNOWN_ID)) {
                return false;
            }
            if (!(material == null ? TinkerStationRepairRecipe.getRepairIndex(tool, material = inputMaterial) < 0 : !material.equals(inputMaterial))) continue;
            return false;
        }
        return material != null;
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        int repairNeeded;
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        if (tool.getDefinition() == ToolDefinition.EMPTY) {
            return ValidatedResult.PASS;
        }
        if (!tool.isBroken() && tool.getDamage() == 0) {
            return FULLY_REPAIRED;
        }
        MaterialId primaryMaterial = this.getPrimaryMaterial(tool);
        int repairRemaining = repairNeeded = tool.getDamage();
        for (int i = 0; i < inv.getInputCount() && repairRemaining > 0; repairRemaining -= this.repairFromSlot(tool, primaryMaterial, inv, repairRemaining, i, NO_ACTION), ++i) {
        }
        if (repairRemaining < repairNeeded) {
            tool = tool.copy();
            ToolDamageUtil.repair(tool, repairNeeded - repairRemaining);
            return ValidatedResult.success(tool.createStack());
        }
        return ValidatedResult.PASS;
    }

    protected MaterialId getPrimaryMaterial(IToolStackView tool) {
        return tool.getMaterial(tool.getDefinition().getRepairParts()[0]).getId();
    }

    @Override
    public void updateInputs(class_1799 result, IMutableTinkerStationContainer inv, boolean isServer) {
        int slot;
        ToolStack inputTool = ToolStack.from(inv.getTinkerableStack());
        ToolStack resultTool = ToolStack.from(result);
        int repairRemaining = inputTool.getDamage() - resultTool.getDamage();
        MaterialId primaryMaterial = this.getPrimaryMaterial(inputTool);
        for (int i = 0; i < inv.getInputCount() && repairRemaining > 0; repairRemaining -= this.repairFromSlot(inputTool, primaryMaterial, inv, repairRemaining, i, count -> inv.shrinkInput(slot, count)), ++i) {
            slot = i;
        }
        if (repairRemaining > 0) {
            TConstruct.LOG.error("Recipe repair on {} consumed too few items. {} durability unaccounted for", (Object)result, (Object)repairRemaining);
        }
    }

    public static float getRepairWeight(IToolStackView tool, MaterialId repairMaterial) {
        ToolDefinition definition = tool.getDefinition();
        return (float)IntStream.of(definition.getRepairParts()).filter(i -> tool.getMaterial(i).matches(repairMaterial)).map(i -> definition.getData().getParts().get(i).getWeight()).max().orElse(1) / (float)definition.getMaxRepairWeight();
    }

    protected int repairFromSlot(ToolStack tool, MaterialId primaryMaterial, ITinkerStationContainer inv, int repairNeeded, int slot, IntConsumer amountConsumer) {
        float durabilityPerItem;
        MaterialId repairMaterial;
        class_1799 stack = inv.getInput(slot);
        if (!stack.method_7960() && !(repairMaterial = TinkerStationRepairRecipe.getMaterialFrom(inv, slot)).equals(IMaterial.UNKNOWN_ID) && (durabilityPerItem = this.getRepairPerItem(tool, inv, slot, repairMaterial)) > 0.0f) {
            durabilityPerItem *= TinkerStationRepairRecipe.getRepairWeight(tool, repairMaterial);
            for (ModifierEntry entry : tool.getModifierList()) {
                durabilityPerItem = entry.getModifier().getRepairFactor(tool, entry.getLevel(), durabilityPerItem);
                if (!(durabilityPerItem <= 0.0f)) continue;
                return 0;
            }
            int applied = Math.min(stack.method_7947(), (int)Math.ceil((float)repairNeeded / durabilityPerItem));
            amountConsumer.accept(applied);
            return (int)((float)applied * durabilityPerItem);
        }
        return 0;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerTables.tinkerStationRepairSerializer.get();
    }

    @Deprecated
    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    public TinkerStationRepairRecipe(class_2960 id) {
        this.id = id;
    }

    public class_2960 method_8114() {
        return this.id;
    }
}

