/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1088;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_776;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolRenderEvents {
    private static final int MAX_BLOCKS = 60;

    public static void init() {
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register(ToolRenderEvents::renderBlockHighlights);
        WorldRenderEvents.END.register(ToolRenderEvents::renderBlockDamageProgress);
    }

    static boolean renderBlockHighlights(WorldRenderContext context, @Nullable class_239 target) {
        class_638 world = class_310.method_1551().field_1687;
        class_746 player = class_310.method_1551().field_1724;
        if (world == null || player == null) {
            return true;
        }
        class_1799 stack = player.method_6047();
        if (stack.method_7960() || !stack.method_31573(TinkerTags.Items.HARVEST)) {
            return true;
        }
        class_239 result = class_310.method_1551().field_1765;
        if (result == null || result.method_17783() != class_239.class_240.field_1332) {
            return true;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return true;
        }
        class_3965 blockTrace = (class_3965)target;
        class_2338 origin = blockTrace.method_17777();
        class_2680 state = world.method_8320(origin);
        if (!ToolHarvestLogic.isEffective(tool, state)) {
            return true;
        }
        Iterator<class_2338> extraBlocks = tool.getDefinition().getData().getAOE().getBlocks(tool, stack, (class_1657)player, world.method_8320(origin), (class_1937)world, origin, blockTrace.method_17780(), IAreaOfEffectIterator.AOEMatchType.BREAKING).iterator();
        if (!extraBlocks.hasNext()) {
            return true;
        }
        class_4597.class_4598 buffers = context.worldRenderer().field_20951.method_23000();
        class_4588 vertexBuilder = buffers.getBuffer(class_1921.method_23594());
        context.matrixStack().method_22903();
        class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
        class_1297 viewEntity = renderInfo.method_19331();
        class_243 vector3d = renderInfo.method_19326();
        double x = vector3d.method_10216();
        double y = vector3d.method_10214();
        double z = vector3d.method_10215();
        int rendered = 0;
        do {
            class_2338 pos = extraBlocks.next();
            if (!world.method_8621().method_11952(pos)) continue;
            ++rendered;
            context.worldRenderer().method_22712(context.matrixStack(), vertexBuilder, viewEntity, x, y, z, pos, world.method_8320(pos));
        } while (rendered < 60 && extraBlocks.hasNext());
        context.matrixStack().method_22909();
        buffers.method_22993();
        return true;
    }

    static void renderBlockDamageProgress(WorldRenderContext context) {
        class_636 controller = class_310.method_1551().field_1761;
        if (controller == null || !controller.method_2923()) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        class_746 player = class_310.method_1551().field_1724;
        if (world == null || player == null || class_310.method_1551().method_1560() == null) {
            return;
        }
        class_1799 stack = player.method_6047();
        if (stack.method_7960() || !stack.method_31573(TinkerTags.Items.HARVEST)) {
            return;
        }
        class_239 result = class_310.method_1551().field_1765;
        if (result == null || result.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return;
        }
        class_3965 blockTrace = (class_3965)result;
        class_2338 target = blockTrace.method_17777();
        class_3191 progress = null;
        for (Int2ObjectMap.Entry entry : class_310.method_1551().field_1769.field_4058.int2ObjectEntrySet()) {
            if (!((class_3191)entry.getValue()).method_13991().equals((Object)target)) continue;
            progress = (class_3191)entry.getValue();
            break;
        }
        if (progress == null) {
            return;
        }
        class_2680 state = world.method_8320(target);
        if (!ToolHarvestLogic.isEffective(tool, state)) {
            return;
        }
        Iterator<class_2338> extraBlocks = tool.getDefinition().getData().getAOE().getBlocks(tool, stack, (class_1657)player, state, (class_1937)world, target, blockTrace.method_17780(), IAreaOfEffectIterator.AOEMatchType.BREAKING).iterator();
        if (!extraBlocks.hasNext()) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        matrices.method_22903();
        class_4597.class_4598 vertices = context.worldRenderer().field_20951.method_23001();
        class_4588 vertexBuilder = vertices.getBuffer((class_1921)class_1088.field_21772.get(progress.method_13988()));
        class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
        double x = renderInfo.method_19326().field_1352;
        double y = renderInfo.method_19326().field_1351;
        double z = renderInfo.method_19326().field_1350;
        class_776 dispatcher = class_310.method_1551().method_1541();
        int rendered = 0;
        do {
            class_2338 pos = extraBlocks.next();
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - x, (double)pos.method_10264() - y, (double)pos.method_10260() - z);
            class_4587.class_4665 entry = matrices.method_23760();
            class_4583 blockBuilder = new class_4583(vertexBuilder, entry.method_23761(), entry.method_23762());
            dispatcher.method_23071(world.method_8320(pos), pos, (class_1920)world, matrices, (class_4588)blockBuilder);
            matrices.method_22909();
        } while (++rendered < 60 && extraBlocks.hasNext());
        matrices.method_22909();
        vertices.method_22993();
    }
}

