/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import java.util.Iterator;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2694;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class InteractionHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static class_1269 beforeEntityInteract(class_1657 player, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hitResult) {
        class_1799 stack = player.method_5998(hand);
        class_1304 slotType = Util.getSlotType(hand);
        if (!stack.method_31573(TinkerTags.Items.HELD)) {
            if (!stack.method_7960()) return class_1269.field_5811;
            stack = player.method_6118(class_1304.field_6174);
            if (!stack.method_31573(TinkerTags.Items.CHESTPLATES)) return class_1269.field_5811;
            slotType = class_1304.field_6174;
        }
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            class_1269 result = entry.getModifier().beforeEntityUse(tool, entry.getLevel(), player, target, hand, slotType);
            if (!result.method_23665()) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    static class_1269 afterEntityInteract(class_1657 player, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hitResult) {
        class_1799 chestplate;
        if (player.method_5998(hand).method_7960() && !player.method_7325() && (chestplate = player.method_6118(class_1304.field_6174)).method_31573(TinkerTags.Items.CHESTPLATES)) {
            ToolStack tool = ToolStack.from(chestplate);
            class_1269 result = target.method_5688(player, hand);
            if (result.method_23665()) {
                return class_1269.field_5811;
            }
            if (target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                for (ModifierEntry entry : tool.getModifierList()) {
                    result = entry.getModifier().afterEntityUse(tool, entry.getLevel(), player, livingTarget, hand, class_1304.field_6174);
                    if (!result.method_23665()) continue;
                    return result;
                }
            }
            result = InteractionHandler.onChestplateUse(player, chestplate, hand);
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onBlockUse(class_1838 context, IToolStackView tool, class_1799 stack, Function<ModifierEntry, class_1269> callback) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2694 info = new class_2694((class_4538)world, context.method_8037(), false);
        if (player != null && !player.method_31549().field_7476 && !stack.method_7944((class_2378)class_2378.field_11146, info)) {
            return class_1269.field_5811;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            class_1269 result = callback.apply(entry);
            if (!result.method_23665()) continue;
            if (player != null) {
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            }
            return result;
        }
        return class_1269.field_5811;
    }

    static class_1269 chestplateInteractWithBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 trace) {
        class_1799 chestplate;
        if (player.method_5998(hand).method_7960() && !player.method_7325() && (chestplate = player.method_6118(class_1304.field_6174)).method_31573(TinkerTags.Items.CHESTPLATES)) {
            class_1269 result;
            class_1838 context = new class_1838(player, hand, trace);
            ToolStack tool = ToolStack.from(chestplate);
            class_1269 result2 = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getModifier().beforeBlockUse(tool, entry.getLevel(), context, class_1304.field_6174));
            if (result2.method_23665()) {
                return result2;
            }
            class_2338 pos = trace.method_17777();
            if (!player.method_21823() && (result = player.field_6002.method_8320(pos).method_26174(player.field_6002, player, hand, trace)).method_23665()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, class_1799.field_8037);
                }
                return result;
            }
            if (!player.method_7357().method_7904(chestplate.method_7909()) && (result = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getModifier().afterBlockUse(tool, entry.getLevel(), context, class_1304.field_6174))).method_23665()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, class_1799.field_8037);
                }
                return result;
            }
            return InteractionHandler.onChestplateUse(player, chestplate, hand);
        }
        return class_1269.field_5811;
    }

    public static class_1269 onChestplateUse(class_1657 player, class_1799 chestplate, class_1268 hand) {
        if (player.method_7357().method_7904(chestplate.method_7909())) {
            return class_1269.field_5811;
        }
        ToolStack tool = ToolStack.from(chestplate);
        for (ModifierEntry entry : tool.getModifierList()) {
            class_1269 result = entry.getModifier().onToolUse(tool, entry.getLevel(), player.field_6002, player, hand, class_1304.field_6174);
            if (!result.method_23665()) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    static class_1269 onChestplateAttack(class_1657 attacker, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hitResult) {
        ToolStack tool;
        class_1799 chestplate;
        if (attacker.method_6047().method_7960() && (chestplate = attacker.method_6118(class_1304.field_6174)).method_31573(TinkerTags.Items.UNARMED) && !(tool = ToolStack.from(chestplate)).isBroken() && tool.getModifierLevel(TinkerModifiers.unarmed.getId()) > 0) {
            ToolAttackUtil.attackEntity(tool, (class_1309)attacker, class_1268.field_5808, target, ToolAttackUtil.getCooldownFunction(attacker, class_1268.field_5808), false, class_1304.field_6174);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static boolean startArmorInteract(class_1657 player, class_1304 slotType, TooltipKey modifierKey) {
        class_1799 helmet;
        if (!player.method_7325() && (helmet = player.method_6118(slotType)).method_31573(TinkerTags.Items.ARMOR)) {
            ModifierEntry entry;
            IArmorInteractModifier helmetInteract;
            ToolStack tool = ToolStack.from(helmet);
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && ((helmetInteract = (entry = iterator.next()).getModifier().getModule(IArmorInteractModifier.class)) == null || !helmetInteract.startArmorInteract(tool, entry.getLevel(), player, slotType, modifierKey))) {
            }
            return true;
        }
        return false;
    }

    public static boolean stopArmorInteract(class_1657 player, class_1304 slotType) {
        class_1799 helmet;
        if (!player.method_7325() && (helmet = player.method_6118(slotType)).method_31573(TinkerTags.Items.ARMOR)) {
            ToolStack tool = ToolStack.from(helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                IArmorInteractModifier helmetInteract = entry.getModifier().getModule(IArmorInteractModifier.class);
                if (helmetInteract == null) continue;
                helmetInteract.stopArmorInteract(tool, entry.getLevel(), player, slotType);
            }
            return true;
        }
        return false;
    }

    public static void init() {
        UseEntityCallback.EVENT.register(InteractionHandler::beforeEntityInteract);
        UseEntityCallback.EVENT.register(TConstruct.getResource("event_phase"), InteractionHandler::afterEntityInteract);
        UseEntityCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, TConstruct.getResource("event_phase"));
        UseBlockCallback.EVENT.register(InteractionHandler::chestplateInteractWithBlock);
        AttackEntityCallback.EVENT.register(InteractionHandler::onChestplateAttack);
    }
}

