/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import com.google.common.collect.Multiset;
import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.event.common.PlayerBreakSpeedCallback;
import io.github.fabricators_of_create.porting_lib.util.EntityHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2276;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3922;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_5134;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.dynamic.MobDisguiseModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorWalkModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ArmorUtil;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.defense.ProjectileProtectionModifier;
import slimeknights.tconstruct.tools.modifiers.upgrades.armor.HasteArmorModifier;

public class ToolEvents {
    public static void init() {
        PlayerBreakSpeedCallback.EVENT.register(ToolEvents::onBreakSpeed);
        TinkerToolEvent.ToolHarvestEvent.EVENT.register(ToolEvents::onHarvest);
        LivingEntityEvents.ACTUALLY_HURT.register(ToolEvents::enderDragonDamage);
        LivingEntityEvents.ACTUALLY_HURT.register(ToolEvents::livingAttack);
        LivingEntityEvents.ACTUALLY_HURT.register(ToolEvents::livingHurt);
        LivingEntityEvents.TICK.register(ToolEvents::livingWalk);
        LivingEntityEvents.VISIBILITY.register(ToolEvents::livingVisibility);
    }

    static void onBreakSpeed(PlayerBreakSpeedCallback.BreakSpeed event) {
        float armorHaste;
        List<ModifierEntry> modifiers;
        ToolStack tool;
        class_1799 stack;
        class_1657 player = event.player;
        if (player.method_5777(class_3486.field_15517) && ModifierUtil.getTotalModifierLevel((class_1309)player, TinkerDataKeys.AQUA_AFFINITY) > 0 && !class_1890.method_8200((class_1309)player)) {
            event.newSpeed *= 5.0f;
        }
        if ((stack = player.method_6047()).method_31573(TinkerTags.Items.HARVEST) && !(tool = ToolStack.from(stack)).isBroken() && !(modifiers = tool.getModifierList()).isEmpty()) {
            float miningSpeedModifier = Modifier.getMiningModifier((class_1309)player);
            boolean isEffective = stack.method_7951(event.state);
            class_2350 direction = BlockSideHitListener.getSideHit(player);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().onBreakSpeed(tool, entry.getLevel(), event, direction, isEffective, miningSpeedModifier);
            }
        }
        if ((armorHaste = ModifierUtil.getTotalModifierFloat((class_1309)player, HasteArmorModifier.HASTE)) > 0.0f) {
            event.newSpeed *= 1.0f + 0.1f * armorHaste;
        }
    }

    static void onHarvest(TinkerToolEvent.ToolHarvestEvent event) {
        if (event.getResult() != class_1269.field_5811) {
            return;
        }
        class_2680 state = event.getState();
        class_2248 block = state.method_26204();
        class_3218 world = event.getWorld();
        class_2338 pos = event.getPos();
        if (block == class_2246.field_10261) {
            class_2350 facing = event.getContext().method_8038();
            if (facing.method_10166() == class_2350.class_2351.field_11052) {
                facing = event.getContext().method_8042().method_10153();
            }
            world.method_8396(null, pos, class_3417.field_14619, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8652(pos, (class_2680)class_2246.field_10147.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)facing), 11);
            class_1542 itemEntity = new class_1542((class_1937)world, (double)pos.method_10263() + 0.5 + (double)facing.method_10148() * 0.65, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5 + (double)facing.method_10165() * 0.65, new class_1799((class_1935)class_1802.field_8706, 4));
            itemEntity.method_18800(0.05 * (double)facing.method_10148() + world.field_9229.nextDouble() * 0.02, 0.05, 0.05 * (double)facing.method_10165() + world.field_9229.nextDouble() * 0.02);
            world.method_8649((class_1297)itemEntity);
            event.setResult(class_1269.field_5812);
        }
        if (block instanceof class_4481) {
            class_4481 beehive = (class_4481)block;
            int level = (Integer)state.method_11654((class_2769)class_4481.field_20420);
            if (level >= 5) {
                world.method_8396(null, pos, class_3417.field_20611, class_3419.field_15254, 1.0f, 1.0f);
                class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_1802.field_20414, 3));
                if (!class_3922.method_23895((class_1937)world, (class_2338)pos)) {
                    if (beehive.method_23894((class_1937)world, pos)) {
                        beehive.method_23893((class_1937)world, pos);
                    }
                    beehive.method_21841((class_1937)world, state, pos, event.getPlayer(), class_4482.class_4484.field_21052);
                } else {
                    beehive.method_23754((class_1937)world, state, pos);
                }
                event.setResult(class_1269.field_5812);
            } else {
                event.setResult(class_1269.field_5814);
            }
        }
    }

    static float enderDragonDamage(class_1282 source, class_1309 entity, float amount) {
        if (!((Boolean)Config.COMMON.dropDragonScales.get()).booleanValue()) {
            return amount;
        }
        if (entity.method_5864() == class_1299.field_6116 && amount > 0.0f && !entity.field_6002.field_9236 && source.method_5535() && source.method_5529() != null && source.method_5529().method_5864() == class_1299.field_6097) {
            ModifierUtil.dropItem((class_1297)entity, new class_1799(TinkerModifiers.dragonScale, 1 + entity.field_6002.field_9229.nextInt(8)));
        }
        return amount;
    }

    static float livingAttack(class_1282 source, class_1309 entity, float amount) {
        class_1309 livingAttacker;
        class_1297 attacker;
        class_1285 entityDamage;
        if (entity.field_6002.method_8608() || entity.method_29504()) {
            return amount;
        }
        if (entity.method_5679(source)) {
            return amount;
        }
        boolean isDirectDamage = source.method_5529() != null && source instanceof class_1285 && !(entityDamage = (class_1285)source).method_5549();
        EquipmentContext context = new EquipmentContext(entity);
        if (context.hasModifiableArmor()) {
            IToolStackView toolStack;
            for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    if (!entry.getModifier().isSourceBlocked(toolStack, entry.getLevel(), context, slotType, source, amount)) continue;
                    return 0.0f;
                }
            }
            for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    entry.getModifier().onAttacked(toolStack, entry.getLevel(), context, slotType, source, amount, isDirectDamage);
                }
            }
        }
        if ((attacker = source.method_5529()) instanceof class_1309 && (context = new EquipmentContext(livingAttacker = (class_1309)attacker)).hasModifiableArmor()) {
            for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                IToolStackView toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    entry.getModifier().attackWithArmor(toolStack, entry.getLevel(), context, slotType, entity, source, amount, isDirectDamage);
                }
            }
        }
        return amount;
    }

    private static int getArmorDamage(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            return 1;
        }
        return (int)damage;
    }

    static float livingHurt(class_1282 source, class_1309 entity, float originalDamage) {
        EquipmentContext context = new EquipmentContext(entity);
        int vanillaModifier = 0;
        float modifierValue = 0.0f;
        if (context.hasModifiableArmor()) {
            if (!source.method_5504()) {
                vanillaModifier = class_1890.method_8219((Iterable)entity.method_5661(), (class_1282)source);
                modifierValue = vanillaModifier;
            }
            for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                IToolStackView tool = context.getToolInSlot(slotType);
                if (tool == null || tool.isBroken()) continue;
                for (ModifierEntry entry : tool.getModifierList()) {
                    modifierValue = entry.getModifier().getProtectionModifier(tool, entry.getLevel(), context, slotType, source, modifierValue);
                }
            }
            if (entity.method_5864().method_20210(TinkerTags.EntityTypes.SMALL_ARMOR)) {
                modifierValue *= 4.0f;
            }
        } else if (!source.method_5504() && entity.method_5864().method_20210(TinkerTags.EntityTypes.SMALL_ARMOR)) {
            vanillaModifier = class_1890.method_8219((Iterable)entity.method_5661(), (class_1282)source);
            modifierValue = vanillaModifier * 4;
        }
        if ((float)vanillaModifier != modifierValue) {
            int damageMissed;
            float armor = 0.0f;
            float toughness = 0.0f;
            if (!source.method_5537()) {
                armor = entity.method_6096();
                toughness = (float)entity.method_26825(class_5134.field_23725);
            }
            float finalDamage = ArmorUtil.getDamageForEvent(originalDamage, armor, toughness, vanillaModifier, modifierValue);
            if (!source.method_5537() && (damageMissed = ToolEvents.getArmorDamage(originalDamage) - ToolEvents.getArmorDamage(finalDamage)) > 0 && entity instanceof class_1657) {
                for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                    IToolStackView tool = context.getToolInSlot(slotType);
                    if (!(tool == null || source.method_5534() && tool.getItem().method_24358())) {
                        ToolDamageUtil.damageAnimated(tool, damageMissed, entity, slotType);
                        continue;
                    }
                    class_1799 armorStack = entity.method_6118(slotType);
                    if (armorStack.method_7960() || source.method_5534() && armorStack.method_7909().method_24358() || !(armorStack.method_7909() instanceof class_1738)) continue;
                    armorStack.method_7956(damageMissed, entity, e -> e.method_20235(slotType));
                }
            }
            return finalDamage;
        }
        return originalDamage;
    }

    static void livingWalk(class_1309 living) {
        class_1799 boots;
        class_2338 pos = living.method_24515();
        class_2338 lastPos = EntityHelper.getLastPos((class_1309)living);
        if (!living.method_7325() && !living.field_6002.method_8608() && living.method_5805() && !Objects.equals(lastPos, pos) && !(boots = living.method_6118(class_1304.field_6166)).method_7960() && boots.method_31573(TinkerTags.Items.BOOTS)) {
            ToolStack tool = ToolStack.from(boots);
            for (ModifierEntry entry : tool.getModifierList()) {
                IArmorWalkModifier hook = entry.getModifier().getModule(IArmorWalkModifier.class);
                if (hook == null) continue;
                hook.onWalk(tool, entry.getLevel(), living, lastPos, pos);
            }
        }
    }

    static double livingVisibility(class_1309 living, @Nullable class_1297 lookingEntity, double current) {
        MutableDouble value = new MutableDouble(current);
        if (lookingEntity == null) {
            return current;
        }
        TinkerDataCapability.CAPABILITY.maybeGet((Object)living).ifPresent(data -> {
            float max;
            ModifierMaxLevel projData;
            Multiset<class_1299<?>> disguises = data.get(MobDisguiseModifier.DISGUISES);
            if (disguises != null && disguises.contains((Object)lookingEntity.method_5864())) {
                value.setValue(value.getValue() * 0.65);
            }
            if ((projData = data.get(ProjectileProtectionModifier.PROJECTILE_DATA)) != null && (max = projData.getMax()) > 0.0f) {
                value.setValue(value.getValue() * Math.max(0.0, 1.0 - (double)max * 0.05));
            }
        });
        return value.getValue();
    }
}

