/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.interaction;

import io.github.fabricators_of_create.porting_lib.util.ToolAction;
import java.util.Iterator;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import slimeknights.tconstruct.library.modifiers.impl.InteractionModifier;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.MutableUseOnContext;

public class BlockTransformModifier
extends InteractionModifier.NoLevels {
    private final int priority;
    private final ToolAction action;
    private final class_3414 sound;
    private final boolean requireGround;
    private final int eventId;

    public BlockTransformModifier(int priority, ToolAction action, class_3414 sound, boolean requireGround) {
        this(priority, action, sound, requireGround, -1);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, int level, ToolAction toolAction) {
        return this.action == toolAction;
    }

    @Override
    public class_1269 afterBlockUse(IToolStackView tool, int level, class_1838 context, class_1304 slotType) {
        if (tool.isBroken()) {
            return class_1269.field_5811;
        }
        class_1657 player = context.method_8036();
        if (player != null && player.method_5715()) {
            return class_1269.field_5811;
        }
        if (this.requireGround && context.method_8038() == class_2350.field_11033) {
            return class_1269.field_5811;
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 original = world.method_8320(pos);
        class_1799 stack = context.method_8041();
        boolean didTransform = this.transform(context, original, true);
        if (didTransform) {
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            if (ToolDamageUtil.damage(tool, 1, (class_1309)player, stack)) {
                if (player != null) {
                    player.method_20235(slotType);
                }
                return class_1269.field_21466;
            }
        }
        if (player != null && !tool.isBroken()) {
            int totalTransformed = 0;
            Iterator<class_2338> aoePos = tool.getDefinition().getData().getAOE().getBlocks(tool, stack, player, original, world, pos, context.method_8038(), IAreaOfEffectIterator.AOEMatchType.TRANSFORM).iterator();
            if (aoePos.hasNext()) {
                MutableUseOnContext offsetContext = new MutableUseOnContext(context);
                do {
                    class_2338 newPos;
                    if (pos.equals((Object)(newPos = aoePos.next()))) continue;
                    offsetContext.setOffsetPos(newPos);
                    class_2680 newTarget = world.method_8320(newPos);
                    if (!this.transform(offsetContext, newTarget, totalTransformed < 40)) continue;
                    ++totalTransformed;
                    didTransform = true;
                    if (world.field_9236 || ToolDamageUtil.damageAnimated(tool, 1, (class_1309)player, slotType)) break;
                } while (aoePos.hasNext());
                if (totalTransformed > 0) {
                    player.method_7263();
                }
            }
        }
        return didTransform ? class_1269.method_29236((boolean)world.field_9236) : class_1269.field_5811;
    }

    protected boolean transform(class_1838 context, class_2680 original, boolean playSound) {
        class_3614 material;
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2338 above = pos.method_10084();
        if (this.requireGround && !(material = level.method_8320(above).method_26207()).method_15800() && material != class_3614.field_15935) {
            return false;
        }
        class_1657 player = context.method_8036();
        class_2680 transformed = original.getToolModifiedState(context, this.action, false);
        if (transformed != null) {
            if (playSound) {
                level.method_8396(player, pos, this.sound, class_3419.field_15245, 1.0f, 1.0f);
                if (this.eventId != -1) {
                    level.method_8444(player, this.eventId, pos, 0);
                }
            }
            if (!level.field_9236) {
                level.method_8652(pos, transformed, 11);
                if (this.requireGround) {
                    level.method_22352(above, true);
                }
            }
            return true;
        }
        return false;
    }

    public BlockTransformModifier(int priority, ToolAction action, class_3414 sound, boolean requireGround, int eventId) {
        this.priority = priority;
        this.action = action;
        this.sound = sound;
        this.requireGround = requireGround;
        this.eventId = eventId;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

