/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.interaction;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_6880;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.impl.InteractionModifier;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class HarvestAbilityModifier
extends InteractionModifier.NoLevels {
    private final int priority;

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    private static boolean harvestInteract(class_1838 context, class_3218 world, class_2680 state, class_2338 pos, @Nullable class_1657 player) {
        if (player == null) {
            return false;
        }
        class_3965 trace = new class_3965(context.method_17698(), context.method_8038(), pos, false);
        class_1269 result = state.method_26174((class_1937)world, player, context.method_20287(), trace);
        return result.method_23665();
    }

    private static boolean harvestStackable(class_3218 world, class_2680 state, class_2338 pos, @Nullable class_1657 player) {
        if (world.method_8320(pos.method_10074()).method_26204() == state.method_26204()) {
            world.method_8651(pos, true, (class_1297)player);
            return true;
        }
        class_2338 up = pos.method_10084();
        if (world.method_8320(up).method_26204() == state.method_26204()) {
            world.method_8651(up, true, (class_1297)player);
            return true;
        }
        return false;
    }

    private static boolean harvestCrop(class_1799 stack, class_3218 world, class_2680 state, class_2338 pos, @Nullable class_1657 player) {
        class_2680 replant;
        class_2248 block = state.method_26204();
        if (block instanceof class_2302) {
            class_2302 crops = (class_2302)block;
            if (!crops.method_9825(state)) {
                return false;
            }
            replant = crops.method_9828(0);
        } else {
            class_2758 age = null;
            for (class_2769 prop : state.method_28501()) {
                if (!prop.method_11899().equals("age") || !(prop instanceof class_2758)) continue;
                age = (class_2758)prop;
                break;
            }
            if (age == null) {
                return false;
            }
            Collection allowedValues = age.method_11898();
            if (!allowedValues.contains(0)) {
                return false;
            }
            int maxAge = age.method_11898().stream().max(Integer::compareTo).orElse(Integer.MAX_VALUE);
            if ((Integer)state.method_11654((class_2769)age) < maxAge) {
                return false;
            }
            replant = (class_2680)state.method_11657((class_2769)age, (Comparable)Integer.valueOf(0));
        }
        class_47.class_48 lootContext = new class_47.class_48(world).method_311(world.field_9229).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_312(class_181.field_1229, (Object)class_1799.field_8037).method_306(class_181.field_1228, (Object)world.method_8321(pos));
        List drops = state.method_26189(lootContext);
        Iterator iterator = drops.iterator();
        boolean hasSeed = false;
        while (iterator.hasNext()) {
            class_1799 drop = (class_1799)iterator.next();
            if (!drop.method_31573(TinkerTags.Items.SEEDS)) continue;
            hasSeed = true;
            drop.method_7934(1);
            if (!drop.method_7960()) break;
            iterator.remove();
            break;
        }
        if (hasSeed) {
            world.method_8501(pos, replant);
            state.method_26180(world, pos, stack);
            world.method_8396(null, pos, state.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
        } else {
            world.method_22352(pos, false);
        }
        for (class_1799 drop : drops) {
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)drop);
        }
        return true;
    }

    private static boolean harvest(class_1838 context, IToolStackView tool, class_3218 world, class_2680 state, class_2338 pos, class_1304 slotType) {
        class_1657 player = context.method_8036();
        class_6880.class_6883 holder = state.method_26204().method_40142();
        if (!holder.method_40220(TinkerTags.Blocks.HARVESTABLE)) {
            return false;
        }
        boolean didHarvest = false;
        class_1269 result = new TinkerToolEvent.ToolHarvestEvent(tool, context, world, state, pos, slotType).fire();
        if (result != class_1269.field_5811) {
            didHarvest = result == class_1269.field_5812;
        } else if (holder.method_40220(TinkerTags.Blocks.HARVESTABLE_INTERACT)) {
            didHarvest = HarvestAbilityModifier.harvestInteract(context, world, state, pos, player);
        } else if (holder.method_40220(TinkerTags.Blocks.HARVESTABLE_STACKABLE)) {
            didHarvest = HarvestAbilityModifier.harvestStackable(world, state, pos, player);
        } else if (holder.method_40220(TinkerTags.Blocks.HARVESTABLE_CROPS)) {
            didHarvest = HarvestAbilityModifier.harvestCrop(context.method_8041(), world, state, pos, player);
        }
        if (didHarvest) {
            for (ModifierEntry entry : tool.getModifierList()) {
                IHarvestModifier harvest = entry.getModifier().getModule(IHarvestModifier.class);
                if (harvest == null) continue;
                harvest.afterHarvest(tool, entry.getLevel(), context, world, state, pos);
            }
        }
        return didHarvest;
    }

    @Override
    public class_1269 beforeBlockUse(IToolStackView tool, int level, class_1838 context, class_1304 slotType) {
        class_2338 pos;
        if (tool.isBroken()) {
            return class_1269.field_5811;
        }
        class_1657 player = context.method_8036();
        if (player != null && player.method_5715()) {
            return class_1269.field_5811;
        }
        class_1937 world = context.method_8045();
        class_2680 state = world.method_8320(pos = context.method_8037());
        if (state.method_26164(TinkerTags.Blocks.HARVESTABLE)) {
            if (world instanceof class_3218) {
                class_3218 server = (class_3218)world;
                boolean survival = player == null || !player.method_7337();
                boolean didHarvest = false;
                boolean broken = false;
                class_1799 stack = context.method_8041();
                if (HarvestAbilityModifier.harvest(context, tool, server, state, pos, slotType)) {
                    didHarvest = true;
                    broken = survival && ToolDamageUtil.damage(tool, 1, (class_1309)player, stack);
                }
                class_1792 item = stack.method_7909();
                if (!broken && player != null) {
                    for (class_2338 newPos : tool.getDefinition().getData().getAOE().getBlocks(tool, stack, player, state, world, pos, context.method_8038(), IAreaOfEffectIterator.AOEMatchType.TRANSFORM)) {
                        if (!HarvestAbilityModifier.harvest(context, tool, server, world.method_8320(newPos), newPos, slotType)) continue;
                        didHarvest = true;
                        if (!survival || !ToolDamageUtil.damage(tool, 1, (class_1309)player, stack)) continue;
                        broken = true;
                        break;
                    }
                }
                if (player != null) {
                    if (didHarvest) {
                        player.method_7263();
                    }
                    if (broken) {
                        player.method_20236(context.method_20287());
                    }
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public HarvestAbilityModifier(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

