/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.interaction;

import io.github.fabricators_of_create.porting_lib.extensions.IShearable;
import io.github.fabricators_of_create.porting_lib.util.ToolAction;
import io.github.fabricators_of_create.porting_lib.util.ToolActions;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hooks.IShearModifier;
import slimeknights.tconstruct.library.modifiers.impl.InteractionModifier;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ShearsAbilityModifier
extends InteractionModifier.NoLevels {
    private final int range;
    private final int priority;

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    protected void swingTool(class_1657 player, class_1268 hand) {
        player.method_6104(hand);
        player.method_7263();
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, int level, ToolAction toolAction) {
        if (this.isShears(tool)) {
            return toolAction == ToolActions.SHEARS_DIG || toolAction == ToolActions.SHEARS_HARVEST || toolAction == ToolActions.SHEARS_CARVE || toolAction == ToolActions.SHEARS_DISARM;
        }
        return false;
    }

    protected boolean isShears(IToolStackView tool) {
        return true;
    }

    @Override
    public class_1269 beforeEntityUse(IToolStackView tool, int level, class_1657 player, class_1297 target, class_1268 hand, class_1304 slotType) {
        if (tool.isBroken()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_6118(slotType);
        int looting = ModifierUtil.getLootingLevel(tool, (class_1309)player, target, null);
        looting = ModifierUtil.getLeggingsLootingLevel((class_1309)player, target, null, looting);
        class_1937 world = player.method_5770();
        if (this.isShears(tool) && ShearsAbilityModifier.shearEntity(stack, tool, world, player, target, looting)) {
            int expanded;
            boolean broken = ToolDamageUtil.damageAnimated(tool, 1, (class_1309)player, slotType);
            this.swingTool(player, hand);
            ShearsAbilityModifier.runShearHook(tool, player, target, true);
            if (!broken && (expanded = this.range + tool.getModifierLevel(TinkerModifiers.expanded.getId())) > 0) {
                for (class_1309 aoeTarget : player.method_5770().method_18467(class_1309.class, target.method_5829().method_1009((double)expanded, 0.25, (double)expanded))) {
                    if (aoeTarget == player || aoeTarget == target || aoeTarget instanceof class_1531 && ((class_1531)aoeTarget).method_6912() || !ShearsAbilityModifier.shearEntity(stack, tool, world, player, (class_1297)aoeTarget, looting)) continue;
                    broken = ToolDamageUtil.damageAnimated(tool, 1, (class_1309)player, slotType);
                    ShearsAbilityModifier.runShearHook(tool, player, (class_1297)aoeTarget, false);
                    if (!broken) continue;
                    break;
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static void runShearHook(IToolStackView tool, class_1657 player, class_1297 entity, boolean isTarget) {
        for (ModifierEntry entry : tool.getModifierList()) {
            IShearModifier shearModifier = entry.getModifier().getModule(IShearModifier.class);
            if (shearModifier == null) continue;
            shearModifier.afterShearEntity(tool, entry.getLevel(), player, entity, isTarget);
        }
    }

    private static boolean shearEntity(class_1799 itemStack, IToolStackView tool, class_1937 world, class_1657 player, class_1297 entity, int fortune) {
        IShearable target;
        class_1269 result = new TinkerToolEvent.ToolShearEvent(itemStack, tool, world, player, entity, fortune).fire();
        if (result != class_1269.field_5811) {
            return result == class_1269.field_5812;
        }
        if (entity instanceof IShearable && (target = (IShearable)entity).isShearable(itemStack, world, entity.method_24515())) {
            if (!world.field_9236) {
                target.onSheared(player, itemStack, world, entity.method_24515(), fortune).forEach(stack -> ModifierUtil.dropItem(entity, stack));
            }
            return true;
        }
        return false;
    }

    public ShearsAbilityModifier(int range, int priority) {
        this.range = range;
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

