/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.data.VanillaMaxLevel;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class FireProtectionModifier
extends IncrementalModifier {
    private static final TinkerDataCapability.TinkerDataKey<FireData> FIRE_DATA = TConstruct.createKey("fire_protection");

    public FireProtectionModifier() {
        LivingEntityEvents.TICK.register(FireProtectionModifier::livingTick);
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1282 source, float modifierValue) {
        if (!source.method_5504() && !source.method_5538() && source.method_5534()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.0f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.0f, tooltip);
    }

    private int getEnchantmentLevel(EquipmentChangeContext context, class_1304 slotType) {
        if (context.getToolInSlot(slotType) == null) {
            return class_1890.method_8225((class_1887)class_1893.field_9095, (class_1799)context.getEntity().method_6118(slotType));
        }
        return 0;
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        class_1309 entity = context.getEntity();
        class_1304 slot = context.getChangedSlot();
        if (slot.method_5925() == class_1304.class_1305.field_6178 && !entity.field_6002.field_9236) {
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null) {
                    fireData.modifier.set(slot, 0.0f);
                    if (fireData.modifier.getMax() == 0.0f) {
                        data.remove(FIRE_DATA);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        class_1309 entity = context.getEntity();
        class_1304 slot = context.getChangedSlot();
        if (!entity.field_6002.field_9236 && slot.method_5925() == class_1304.class_1305.field_6178 && !tool.isBroken()) {
            float scaledLevel = this.getScaledLevel(tool, level);
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData == null) {
                    fireData = new FireData();
                    for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                        fireData.vanilla.set(slotType, this.getEnchantmentLevel(context, slotType));
                    }
                    int fireTimer = entity.method_20802();
                    if (fireTimer > 0) {
                        fireData.finish = entity.field_6012 + fireTimer + 1;
                    }
                    data.put(FIRE_DATA, fireData);
                }
                fireData.modifier.set(slot, scaledLevel);
                fireData.vanilla.set(slot, 0);
            });
        }
    }

    @Override
    public void onEquipmentChange(IToolStackView tool, int level, EquipmentChangeContext context, class_1304 slotType) {
        class_1309 entity = context.getEntity();
        class_1304 slot = context.getChangedSlot();
        if (!entity.field_6002.field_9236 && slot.method_5925() == class_1304.class_1305.field_6178) {
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null && fireData.modifier.getMaxSlot() == slotType) {
                    fireData.vanilla.set(slot, this.getEnchantmentLevel(context, slot));
                }
            });
        }
    }

    private static void livingTick(class_1309 entity) {
        if (!entity.field_6002.field_9236 && !entity.method_7325()) {
            TinkerDataCapability.CAPABILITY.maybeGet((Object)entity).ifPresent(data -> {
                float maxLevel;
                int maxVanilla;
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null && (float)(maxVanilla = fireData.vanilla.getMax()) < (maxLevel = fireData.modifier.getMax())) {
                    int currentFire = entity.method_20802();
                    if (currentFire <= 0) {
                        if (fireData.finish > entity.field_6012) {
                            fireData.finish = 0;
                        }
                    } else if (currentFire + entity.field_6012 > fireData.finish) {
                        int newFire = currentFire;
                        newFire = maxVanilla > 0 ? (newFire -= class_3532.method_15375((float)((float)currentFire / (1.0f - (float)maxVanilla * 0.15f) * (maxLevel - (float)maxVanilla) * 0.15f))) : (newFire -= class_3532.method_15375((float)((float)currentFire * maxLevel * 0.15f)));
                        if (newFire < 0) {
                            newFire = 0;
                            fireData.finish = 0;
                        } else {
                            fireData.finish = newFire + entity.field_6012 + 1;
                        }
                        entity.method_20803(newFire);
                    }
                }
            });
        }
    }

    protected static class FireData {
        public final ModifierMaxLevel modifier = new ModifierMaxLevel();
        public final VanillaMaxLevel vanilla = new VanillaMaxLevel();
        int finish = 0;

        protected FireData() {
        }
    }
}

