/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import org.apache.commons.lang3.mutable.MutableObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.Util;

public class StatOverrideModifier
extends NoLevelsModifier {
    private static final class_2960 KEY_BONUS = TConstruct.getResource("override_bonus");
    private static final class_2960 KEY_MULTIPLY = TConstruct.getResource("override_multiplier");
    private static final class_2561 LANG_BONUS = TConstruct.makeTranslation("modifier", "stat_override.bonuses").method_27692(class_124.field_1073);
    private static final class_2561 LANG_MULTIPLY = TConstruct.makeTranslation("modifier", "stat_override.multipliers").method_27692(class_124.field_1073);

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return advanced;
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(KEY_BONUS);
        tool.getPersistentData().remove(KEY_MULTIPLY);
    }

    private static void processStats(IModDataView persistentData, class_2960 key, StatConsumer consumer) {
        if (persistentData.contains(key, 10)) {
            class_2487 nbt = persistentData.getCompound(key);
            for (String name : nbt.method_10541()) {
                IToolStat<?> stat;
                ToolStatId id = ToolStatId.tryCreate(name);
                if (id == null || (stat = ToolStats.getToolStat(id)) == null) continue;
                consumer.handle(stat, Objects.requireNonNull(nbt.method_10580(name)));
            }
        }
    }

    private static <T> void update(ModifierStatsBuilder builder, IToolStat<T> stat, class_2520 tag) {
        T value = stat.read(tag);
        if (value != null) {
            stat.update(builder, value);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        IModDataView persistentData = context.getPersistentData();
        StatOverrideModifier.processStats(persistentData, KEY_BONUS, (stat, tag) -> StatOverrideModifier.update(builder, stat, tag));
        StatOverrideModifier.processStats(persistentData, KEY_MULTIPLY, (stat, tag) -> {
            if (stat instanceof INumericToolStat) {
                INumericToolStat numeric = (INumericToolStat)stat;
                if (TagUtil.isNumeric(tag)) {
                    numeric.multiply(builder, ((class_2514)tag).method_10700());
                }
            }
        });
    }

    @Nullable
    private static <T> class_2561 format(IToolStat<T> stat, class_2520 tag) {
        T value = stat.read(tag);
        return value == null ? null : stat.formatValue(value);
    }

    private static void addToTooltip(IModDataView persistentData, class_2960 groupKey, class_2561 listStart, DecimalFormat format, Consumer<class_2561> consumer) {
        if (persistentData.contains(groupKey, 10)) {
            class_2487 stats = persistentData.getCompound(groupKey);
            boolean first = true;
            for (String key : stats.method_10541()) {
                IToolStat<?> stat;
                ToolStatId id = ToolStatId.tryCreate(key);
                if (id == null || (stat = ToolStats.getToolStat(id)) == null) continue;
                if (first) {
                    consumer.accept(listStart);
                    first = false;
                }
                if (stat instanceof INumericToolStat) {
                    consumer.accept((class_2561)new class_2585("* ").method_10852((class_2561)stat.getPrefix()).method_27693(format.format(stats.method_10583(key))));
                    continue;
                }
                class_2561 formatted = StatOverrideModifier.format(stat, Objects.requireNonNull(stats.method_10580(key)));
                if (formatted == null) continue;
                consumer.accept((class_2561)new class_2585("* ").method_10852(formatted));
            }
        }
    }

    @Override
    public List<class_2561> getDescriptionList(IToolStackView tool, int level) {
        List<class_2561> defaultList = this.getDescriptionList(level);
        MutableObject resultList = new MutableObject();
        Consumer<class_2561> consumer = text -> {
            ArrayList<class_2561> list = (ArrayList<class_2561>)resultList.getValue();
            if (list == null) {
                list = new ArrayList<class_2561>(defaultList);
                resultList.setValue(list);
            }
            list.add((class_2561)text);
        };
        ModDataNBT persistentData = tool.getPersistentData();
        StatOverrideModifier.addToTooltip(persistentData, KEY_BONUS, LANG_BONUS, Util.BONUS_FORMAT, consumer);
        StatOverrideModifier.addToTooltip(persistentData, KEY_MULTIPLY, LANG_MULTIPLY, Util.MULTIPLIER_FORMAT, consumer);
        List computedList = (List)resultList.getValue();
        if (computedList != null) {
            return computedList;
        }
        return defaultList;
    }

    @Nullable
    private static class_2487 getTag(IToolStackView tool, class_2960 groupKey, boolean createTag) {
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(groupKey, 10)) {
            return data.getCompound(groupKey);
        }
        if (createTag) {
            class_2487 nbt = new class_2487();
            data.put(groupKey, (class_2520)nbt);
            return nbt;
        }
        return null;
    }

    private static float getStat(IToolStackView tool, class_2960 groupKey, INumericToolStat<?> stat, float defaultValue) {
        String name;
        class_2487 nbt;
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(groupKey, 10) && (nbt = data.getCompound(groupKey)).method_10573(name = stat.getName().toString(), 5)) {
            return nbt.method_10583(name);
        }
        return defaultValue;
    }

    private static boolean setStat(IToolStackView tool, class_2960 groupKey, INumericToolStat<?> stat, float value, float neutralValue) {
        class_2487 nbt = StatOverrideModifier.getTag(tool, groupKey, value != neutralValue);
        if (nbt == null) {
            return false;
        }
        String name = stat.getName().toString();
        if (value != neutralValue) {
            nbt.method_10548(name, value);
            return true;
        }
        nbt.method_10551(name);
        if (nbt.method_10541().isEmpty()) {
            tool.getPersistentData().remove(groupKey);
            return false;
        }
        return true;
    }

    public <T> boolean set(IToolStackView tool, IToolStat<T> stat, T value) {
        class_2520 tag;
        ModDataNBT data = tool.getPersistentData();
        boolean storeValue = stat instanceof INumericToolStat ? ((Number)value).intValue() != 0 : value != stat.getDefaultValue();
        class_2487 nbt = StatOverrideModifier.getTag(tool, KEY_BONUS, storeValue);
        if (nbt == null) {
            return false;
        }
        String name = stat.getName().toString();
        if (storeValue && (tag = stat.write(value)) != null) {
            nbt.method_10566(name, tag);
            return true;
        }
        nbt.method_10551(name);
        if (nbt.method_10541().isEmpty()) {
            data.remove(KEY_BONUS);
            return false;
        }
        return true;
    }

    public boolean addBonus(IToolStackView tool, INumericToolStat<?> stat, float bonus) {
        if (bonus != 0.0f) {
            return StatOverrideModifier.setStat(tool, KEY_BONUS, stat, StatOverrideModifier.getStat(tool, KEY_BONUS, stat, 0.0f) + bonus, 0.0f);
        }
        return false;
    }

    public boolean setMultiplier(IToolStackView tool, INumericToolStat<?> stat, float multiplier) {
        return StatOverrideModifier.setStat(tool, KEY_MULTIPLY, stat, multiplier, 1.0f);
    }

    public boolean multiply(IToolStackView tool, INumericToolStat<?> stat, float value) {
        if (value != 1.0f) {
            return this.setMultiplier(tool, stat, StatOverrideModifier.getStat(tool, KEY_MULTIPLY, stat, 1.0f) * value);
        }
        return false;
    }

    public <T> boolean remove(IToolStackView tool, IToolStat<T> stat) {
        class_2487 nbt = StatOverrideModifier.getTag(tool, KEY_BONUS, false);
        if (nbt == null) {
            return false;
        }
        nbt.method_10551(stat.getName().toString());
        if (nbt.method_10541().isEmpty()) {
            tool.getPersistentData().remove(KEY_BONUS);
            return false;
        }
        return true;
    }

    @FunctionalInterface
    private static interface StatConsumer {
        public void handle(IToolStat<?> var1, class_2520 var2);
    }
}

