/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2708;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.events.teleport.EnderportingTeleportEvent;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EnderportingModifier
extends NoLevelsModifier
implements IHarvestModifier {
    private static final Set<class_2708.class_2709> PACKET_FLAGS = ImmutableSet.of((Object)class_2708.class_2709.field_12400, (Object)class_2708.class_2709.field_12398, (Object)class_2708.class_2709.field_12403);

    @Override
    public int getPriority() {
        return 75;
    }

    private static boolean tryTeleport(class_1309 living, double x, double y, double z) {
        class_1937 world = living.method_5770();
        if (world.field_9236) {
            return false;
        }
        float scaledWidth = living.method_17681() * 0.8f;
        float eyeHeight = living.method_5751();
        class_238 aabb = class_238.method_30048((class_243)new class_243(x, y + (double)(eyeHeight / 2.0f), z), (double)scaledWidth, (double)eyeHeight, (double)scaledWidth);
        boolean didCollide = world.method_20812((class_1297)living, aabb).iterator().hasNext();
        if (didCollide && living.method_17682() > 1.0f) {
            aabb = aabb.method_989(0.0, -1.0, 0.0);
            didCollide = world.method_20812((class_1297)living, aabb).iterator().hasNext();
            y -= 1.0;
        }
        if (!didCollide) {
            EnderportingTeleportEvent event = new EnderportingTeleportEvent(living, x, y, z);
            event.sendEvent();
            if (!event.isCanceled()) {
                if (living instanceof class_3222) {
                    class_3222 playerMP = (class_3222)living;
                    playerMP.field_13987.method_14360(x, y, z, playerMP.method_36454(), playerMP.method_36455(), PACKET_FLAGS);
                } else {
                    living.method_5814(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    for (int i = 0; i < 32; ++i) {
                        serverWorld.method_14199((class_2394)class_2398.field_11214, living.method_23317(), living.method_23318() + world.field_9229.nextDouble() * 2.0, living.method_23321(), 1, world.field_9229.nextGaussian(), 0.0, world.field_9229.nextGaussian(), 0.0);
                    }
                }
                world.method_8465(null, living.method_23317(), living.method_23318(), living.method_23321(), Sounds.ENDERPORTING.getSound(), living.method_5634(), 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        class_1309 target;
        if (!context.isExtraAttack() && (target = context.getLivingTarget()) != null && target.method_6032() == 0.0f) {
            class_243 pos = target.method_19538();
            if (EnderportingModifier.tryTeleport(context.getAttacker(), pos.method_10216(), pos.method_10214(), pos.method_10215())) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void finishBreakingBlocks(IToolStackView tool, int level, ToolHarvestContext context) {
        if (context.canHarvest()) {
            class_2338 pos = context.getPos();
            class_1309 living = context.getLiving();
            if (EnderportingModifier.tryTeleport(living, (float)pos.method_10263() + 0.5f, pos.method_10264(), (float)pos.method_10260() + 0.5f)) {
                ToolDamageUtil.damageAnimated(tool, 2, living);
            }
        }
    }

    @Override
    public void afterHarvest(IToolStackView tool, int level, class_1838 context, class_3218 world, class_2680 state, class_2338 pos) {
        class_1657 living;
        if (context.method_8037().equals((Object)pos) && (living = context.method_8036()) != null && EnderportingModifier.tryTeleport((class_1309)living, (float)pos.method_10263() + 0.5f, pos.method_10264(), (float)pos.method_10260() + 0.5f)) {
            ToolDamageUtil.damageAnimated(tool, 2, (class_1309)living);
        }
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return EnderportingModifier.tryModuleMatch(type, IHarvestModifier.class, this);
    }
}

