/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import io.github.fabricators_of_create.porting_lib.event.common.PlayerBreakSpeedCallback;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class DwarvenModifier
extends Modifier {
    private static final class_2561 MINING_SPEED = TConstruct.makeTranslation("modifier", "dwarven.mining_speed");
    private static final float BOOST_DISTANCE = 64.0f;
    private static final float DEBUFF_RANGE = 128.0f;
    private static final float BONUS = 6.0f;

    private static float getBoost(class_1937 world, int y, int level, float baseSpeed, float modifier) {
        if ((float)y < 64.0f) {
            float scale = class_3532.method_15363((float)((64.0f - (float)y) / 64.0f), (float)0.0f, (float)2.0f);
            return baseSpeed + (float)level * scale * 6.0f * modifier;
        }
        float baselineDebuff = Math.max((float)world.method_31600() - 192.0f, 96.0f);
        if ((float)y > baselineDebuff) {
            if ((float)y >= baselineDebuff + 128.0f) {
                return baseSpeed * 0.25f;
            }
            return baseSpeed * (1.0f - ((float)y - baselineDebuff) / 128.0f * 0.75f);
        }
        return baseSpeed;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerBreakSpeedCallback.BreakSpeed event, class_2350 sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!isEffective) {
            return;
        }
        event.newSpeed = DwarvenModifier.getBoost(event.player.field_6002, event.pos.method_10264(), level, event.newSpeed, miningSpeedModifier * tool.getMultiplier(ToolStats.MINING_SPEED));
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 tooltipFlag) {
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            double boost;
            if (player != null && key == TooltipKey.SHIFT) {
                boost = DwarvenModifier.getBoost(player.field_6002, (int)player.method_23318(), level, 1.0f, 1.0f) - 1.0f;
                if (boost < 0.0) {
                    if (boost <= -0.01) {
                        this.addPercentTooltip(MINING_SPEED, boost, tooltip);
                    }
                    return;
                }
            } else {
                boost = 6.0f * (float)level;
            }
            if (boost >= 0.01) {
                this.addFlatBoost(MINING_SPEED, boost * (double)tool.getMultiplier(ToolStats.MINING_SPEED), tooltip);
            }
        }
    }
}

