/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import io.github.fabricators_of_create.porting_lib.event.common.PlayerBreakSpeedCallback;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MomentumModifier
extends Modifier {
    private static final class_2561 MINING_SPEED = TConstruct.makeTranslation("modifier", "momentum.mining_speed");

    @Override
    public int getPriority() {
        return 75;
    }

    private static float getBonus(class_1309 living, int level) {
        int effectLevel = ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).getLevel(living) + 1;
        return (float)(level * effectLevel) / 128.0f;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerBreakSpeedCallback.BreakSpeed event, class_2350 sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.newSpeed *= 1.0f + MomentumModifier.getBonus((class_1309)event.player, level);
        }
    }

    @Override
    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        if (context.canHarvest() && context.isEffective() && !context.isAOE()) {
            class_1309 living = context.getLiving();
            int effectLevel = Math.min(31, ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).getLevel(living) + 1);
            int duration = (int)(10.0f / tool.getStats().get(ToolStats.MINING_SPEED).floatValue() * 1.5f * 20.0f);
            ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).apply(living, duration, effectLevel, true);
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            float bonus = player != null && key == TooltipKey.SHIFT ? MomentumModifier.getBonus((class_1309)player, level) : (float)level * 0.25f;
            this.addPercentTooltip(MINING_SPEED, bonus, tooltip);
        }
    }
}

