/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class SpringyModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<SlotInCharge> SLOT_IN_CHARGE = TConstruct.createKey("springy");

    @Override
    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1282 source, float amount, boolean isDirectDamage) {
        class_1309 user = context.getEntity();
        class_1297 attacker = source.method_5529();
        if (isDirectDamage && !user.field_6002.field_9236 && attacker instanceof class_1309) {
            class_1309 livingAttacker = (class_1309)attacker;
            context.getTinkerData().ifPresent(data -> {
                if (Optional.ofNullable(data.get(SLOT_IN_CHARGE)).filter(slot -> slot.inCharge == slotType).isPresent()) {
                    float bestBonus = 0.0f;
                    for (class_1304 bouncingSlot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                        float newBonus;
                        IToolStackView bouncingTool = context.getToolInSlot(bouncingSlot);
                        if (bouncingTool == null || bouncingTool.isBroken() || !(RANDOM.nextFloat() < (float)level * 0.25f) || !((newBonus = 0.5f * RANDOM.nextFloat() * (float)level) > bestBonus)) continue;
                        bestBonus = newBonus;
                    }
                    if (bestBonus > 0.0f) {
                        float angle = attacker.method_36454() * (float)Math.PI / 180.0f;
                        livingAttacker.method_6005((double)bestBonus, (double)(-class_3532.method_15374((float)angle)), (double)class_3532.method_15362((float)angle));
                    }
                }
            });
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        class_1304 slot = context.getChangedSlot();
        if (!tool.isBroken() && slot.method_5925() == class_1304.class_1305.field_6178 && !context.getEntity().field_6002.field_9236) {
            context.getTinkerData().ifPresent(data -> {
                SlotInCharge slotInCharge = data.get(SLOT_IN_CHARGE);
                if (slotInCharge != null) {
                    slotInCharge.removeSlot(slot);
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        class_1304 slot = context.getChangedSlot();
        if (!tool.isBroken() && slot.method_5925() == class_1304.class_1305.field_6178 && !context.getEntity().field_6002.field_9236) {
            context.getTinkerData().ifPresent(data -> {
                SlotInCharge slotInCharge = data.get(SLOT_IN_CHARGE);
                if (slotInCharge == null) {
                    slotInCharge = new SlotInCharge();
                    data.put(SLOT_IN_CHARGE, slotInCharge);
                }
                slotInCharge.addSlot(slot);
            });
        }
    }

    @Override
    public float beforeEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        return knockback + (float)level * 0.5f;
    }

    private static class SlotInCharge {
        private final boolean[] active = new boolean[4];
        @Nullable
        class_1304 inCharge = null;

        private SlotInCharge() {
        }

        void addSlot(class_1304 slotType) {
            this.active[slotType.method_5927()] = true;
            if (this.inCharge == null) {
                this.inCharge = slotType;
            }
        }

        void removeSlot(class_1304 slotType) {
            this.active[slotType.method_5927()] = false;
            for (class_1304 armorSlot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                if (!this.active[slotType.method_5927()]) continue;
                this.inCharge = armorSlot;
                return;
            }
            this.inCharge = null;
        }
    }
}

