/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class PiercingModifier
extends IncrementalModifier {
    private static final class_2960 PIERCING_DEBUFF = TConstruct.getResource("piercing_debuff");

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        float toRemove = 0.5f * this.getScaledLevel(context, level);
        float baseDamage = context.getBaseStats().get(ToolStats.ATTACK_DAMAGE).floatValue();
        if (baseDamage < toRemove) {
            volatileData.putFloat(PIERCING_DEBUFF, toRemove - baseDamage);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        float toRemove = 0.5f * this.getScaledLevel(context, level) - context.getVolatileData().getFloat(PIERCING_DEBUFF);
        ToolStats.ATTACK_DAMAGE.add(builder, -toRemove);
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        class_1657 player = context.getPlayerAttacker();
        class_1282 source = player != null ? class_1282.method_5532((class_1657)player) : class_1282.method_5511((class_1309)context.getAttacker());
        source.method_5508();
        float secondaryDamage = (this.getScaledLevel(tool, level) * tool.getMultiplier(ToolStats.ATTACK_DAMAGE) - tool.getVolatileData().getFloat(PIERCING_DEBUFF)) * context.getCooldown();
        if (context.isCritical()) {
            secondaryDamage *= 1.5f;
        }
        ToolAttackUtil.attackEntitySecondary(source, secondaryDamage, context.getTarget(), context.getLivingTarget(), true);
        return 0;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        this.addDamageTooltip(tool, this.getScaledLevel(tool, level) - tool.getVolatileData().getFloat(PIERCING_DEBUFF), tooltip);
    }
}

