/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.util.TagUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.alphamode.forgetags.Tags;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ArmorDyeingRecipe
implements ITinkerStationRecipe,
IMultiRecipe<IDisplayModifierRecipe> {
    private final class_2960 id;
    private final class_1856 toolRequirement;
    @Nullable
    private List<IDisplayModifierRecipe> displayRecipes;

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        if (!this.toolRequirement.method_8093(inv.getTinkerableStack())) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 input = inv.getInput(i);
            if (input.method_7960()) continue;
            if (!input.method_31573(Tags.Items.DYES)) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public class_1799 assemble(ITinkerStationContainer inv) {
        class_1799 tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.copyFrom(tinkerable);
        ModDataNBT persistentData = tool.getPersistentData();
        ModifierId key = TinkerModifiers.dyed.getId();
        int nr = 0;
        int nb = 0;
        int ng = 0;
        int brightness = 0;
        int count = 0;
        if (persistentData.contains(key, 3)) {
            int color = persistentData.getInt(key);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            brightness = Math.max(r, Math.max(g, b));
            nr = r;
            nb = b;
            ng = g;
            ++count;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1767 dye;
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960() || (dye = TagUtil.getColorFromStack((class_1799)stack)) == null) continue;
            float[] color = dye.method_7787();
            int r = (int)(color[0] * 255.0f);
            int g = (int)(color[1] * 255.0f);
            int b = (int)(color[2] * 255.0f);
            brightness += Math.max(r, Math.max(g, b));
            nr += r;
            ng += g;
            nb += b;
            ++count;
        }
        if (count == 0) {
            return class_1799.field_8037;
        }
        float scaledBrightness = (float)brightness / (float)count;
        brightness = Math.max(nr /= count, Math.max(ng /= count, nb /= count));
        nr = (int)((float)nr * scaledBrightness / (float)brightness);
        ng = (int)((float)ng * scaledBrightness / (float)brightness);
        nb = (int)((float)nb * scaledBrightness / (float)brightness);
        int finalColor = nr << 16 | ng << 8 | nb;
        persistentData.putInt(key, finalColor);
        ModifierId modifier = TinkerModifiers.dyed.getId();
        if (tool.getModifierLevel(modifier) == 0) {
            tool.addModifier(modifier, 1);
        }
        return tool.createStack(Math.min(tinkerable.method_7947(), this.shrinkToolSlotBy()));
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.armorDyeingSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<class_1799> toolInputs = Arrays.stream(this.toolRequirement.method_8105()).map(stack -> {
                if (stack.method_7909() instanceof IModifiableDisplay) {
                    return ((IModifiableDisplay)stack.method_7909()).getRenderTool();
                }
                return stack;
            }).toList();
            ModifierEntry result = new ModifierEntry((Modifier)TinkerModifiers.dyed.get(), 1);
            this.displayRecipes = Arrays.stream(class_1767.values()).map(dye -> new DisplayRecipe(result, toolInputs, (class_1767)dye)).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }

    @Deprecated
    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    public ArmorDyeingRecipe(class_2960 id, class_1856 toolRequirement) {
        this.id = id;
        this.toolRequirement = toolRequirement;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    private static class DisplayRecipe
    implements IDisplayModifierRecipe {
        private static final int[] TINT_COLORS = new int[16];
        private final List<class_1799> dyes;
        private final ModifierEntry displayResult;
        private final List<class_1799> toolWithoutModifier;
        private final List<class_1799> toolWithModifier;

        private static int getTintColor(class_1767 color) {
            int id = color.method_7789();
            if (TINT_COLORS[id] == 0) {
                float[] colors = color.method_7787();
                DisplayRecipe.TINT_COLORS[id] = (int)(colors[0] * 255.0f) << 16 | (int)(colors[1] * 255.0f) << 8 | (int)(colors[2] * 255.0f);
            }
            return TINT_COLORS[id];
        }

        public DisplayRecipe(ModifierEntry result, List<class_1799> tools, class_1767 color) {
            this.displayResult = result;
            this.toolWithoutModifier = tools;
            this.dyes = RegistryHelper.getTagValueStream((class_2378)class_2378.field_11142, (class_6862)color.getTag()).map(class_1799::new).toList();
            ModifierId id = result.getModifier().getId();
            int tintColor = DisplayRecipe.getTintColor(color);
            this.toolWithModifier = tools.stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, null, result, data -> data.putInt(id, tintColor))).toList();
        }

        @Override
        public int getInputCount() {
            return 1;
        }

        @Override
        public List<class_1799> getDisplayItems(int slot) {
            if (slot == 0) {
                return this.dyes;
            }
            return Collections.emptyList();
        }

        @Override
        public int getMaxLevel() {
            return 1;
        }

        @Override
        public ModifierEntry getDisplayResult() {
            return this.displayResult;
        }

        @Override
        public List<class_1799> getToolWithoutModifier() {
            return this.toolWithoutModifier;
        }

        @Override
        public List<class_1799> getToolWithModifier() {
            return this.toolWithModifier;
        }
    }

    public static class Finished
    implements class_2444 {
        private final class_2960 id;
        private final class_1856 toolRequirement;

        public void method_10416(JsonObject json) {
            json.add("tools", this.toolRequirement.method_8089());
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerModifiers.armorDyeingSerializer.get();
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }

        public Finished(class_2960 id, class_1856 toolRequirement) {
            this.id = id;
            this.toolRequirement = toolRequirement;
        }

        public class_2960 method_10417() {
            return this.id;
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ArmorDyeingRecipe> {
        @Nullable
        protected ArmorDyeingRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            class_1856 toolRequirement = class_1856.method_8086((class_2540)buffer);
            return new ArmorDyeingRecipe(id, toolRequirement);
        }

        protected void toNetworkSafe(class_2540 buffer, ArmorDyeingRecipe recipe) {
            recipe.toolRequirement.method_8088(buffer);
        }

        public ArmorDyeingRecipe fromJson(class_2960 id, JsonObject json) {
            class_1856 toolRequirement = class_1856.method_8102((JsonElement)json.get("tools"));
            return new ArmorDyeingRecipe(id, toolRequirement);
        }
    }
}

