/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRemovalRecipe
implements ITinkerStationRecipe {
    private static final ValidatedResult NO_MODIFIERS = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "remove_modifier.no_modifiers"), new Object[0]);
    private final class_2960 id;
    private final class_1856 ingredient;
    private final class_1799 container;

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        if (!inv.getTinkerableStack().method_31573(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Nullable
    private ModifierEntry getModifierToRemove(ITinkerStationContainer inv, List<ModifierEntry> modifiers) {
        int removeIndex = -1;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960() || !this.ingredient.method_8093(stack)) continue;
            removeIndex += (i + 1) * stack.method_7947();
        }
        if (removeIndex == -1) {
            return null;
        }
        removeIndex = removeIndex >= modifiers.size() ? 0 : modifiers.size() - removeIndex - 1;
        return modifiers.get(removeIndex);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ValidatedResult validated;
        ModifierId id;
        class_1799 toolStack = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(toolStack);
        List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
        if (modifiers.isEmpty()) {
            return NO_MODIFIERS;
        }
        ModifierEntry toRemove = this.getModifierToRemove(inv, modifiers);
        if (toRemove == null) {
            return ValidatedResult.PASS;
        }
        ModifierSalvage salvage = ModifierRecipeLookup.getSalvage(toolStack, tool = tool.copy(), id = toRemove.getId(), toRemove.getLevel());
        if (salvage != null) {
            salvage.updateTool(tool);
        }
        int newLevel = tool.getModifierLevel(id) - 1;
        Modifier modifier = toRemove.getModifier();
        if (newLevel <= 0) {
            modifier.beforeRemoved(tool, tool.getRestrictedNBT());
        }
        tool.removeModifier(id, 1);
        if (newLevel <= 0) {
            modifier.onRemoved(tool);
        }
        if ((validated = tool.validate()).hasError()) {
            return validated;
        }
        if (newLevel <= 0 && (validated = modifier.validate(tool, 0)).hasError()) {
            return validated;
        }
        class_1799 resultStack = tool.createStack(Math.min(toolStack.method_7947(), this.shrinkToolSlotBy()));
        validated = ModifierRecipeLookup.checkRequirements(resultStack, tool);
        if (validated.hasError()) {
            return validated;
        }
        return ValidatedResult.success(resultStack);
    }

    @Override
    public int shrinkToolSlotBy() {
        return 64;
    }

    @Override
    public void updateInputs(class_1799 result, IMutableTinkerStationContainer inv, boolean isServer) {
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960() || !this.ingredient.method_8093(stack)) continue;
            inv.shrinkInput(i, 1, this.container.method_7972());
            break;
        }
    }

    @Deprecated
    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.removeModifierSerializer.get();
    }

    public ModifierRemovalRecipe(class_2960 id, class_1856 ingredient, class_1799 container) {
        this.id = id;
        this.ingredient = ingredient;
        this.container = container;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public static class Builder
    extends AbstractRecipeBuilder<Builder> {
        private final class_1856 ingredient;
        private final class_1799 container;

        public void save(Consumer<class_2444> consumer) {
            this.save(consumer, Objects.requireNonNull(this.container.method_7909().getRegistryName()));
        }

        public void save(Consumer<class_2444> consumer, class_2960 id) {
            if (this.ingredient == class_1856.field_9017) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept((class_2444)new Finished(id, advancementId));
        }

        private Builder(class_1856 ingredient, class_1799 container) {
            this.ingredient = ingredient;
            this.container = container;
        }

        public static Builder removal(class_1856 ingredient, class_1799 container) {
            return new Builder(ingredient, container);
        }

        private class Finished
        extends AbstractRecipeBuilder.AbstractFinishedRecipe {
            public Finished(@Nullable class_2960 ID, class_2960 advancementID) {
                super((AbstractRecipeBuilder)Builder.this, ID, advancementID);
            }

            public void method_10416(JsonObject json) {
                json.add("ingredient", Builder.this.ingredient.method_8089());
                if (!Builder.this.container.method_7960()) {
                    json.add("container", IncrementalModifierRecipeBuilder.serializeResult(Builder.this.container));
                }
            }

            public class_1865<?> method_17800() {
                return (class_1865)TinkerModifiers.removeModifierSerializer.get();
            }
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierRemovalRecipe> {
        public ModifierRemovalRecipe fromJson(class_2960 id, JsonObject json) {
            class_1856 ingredient = class_1856.method_8102((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            class_1799 container = class_1799.field_8037;
            if (json.has("container")) {
                container = IncrementalModifierRecipe.deseralizeResultItem(json, "container");
            }
            return new ModifierRemovalRecipe(id, ingredient, container);
        }

        @Nullable
        public ModifierRemovalRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            class_1799 container = buffer.method_10819();
            return new ModifierRemovalRecipe(id, ingredient, container);
        }

        public void toNetworkSafe(class_2540 buffer, ModifierRemovalRecipe recipe) {
            recipe.ingredient.method_8088(buffer);
            buffer.method_10793(recipe.container);
        }
    }
}

