/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;

public class SlimeVineBlock
extends class_2541 {
    public static final class_2754<VineStage> STAGE = class_2754.method_11850((String)"stage", VineStage.class);
    private final SlimeType foliage;

    public SlimeVineBlock(class_4970.class_2251 properties, SlimeType foliage) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657(STAGE, (Comparable)((Object)VineStage.START)));
        this.foliage = foliage;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{STAGE});
    }

    public void method_9514(class_2680 state, class_3218 worldIn, class_2338 pos, Random random) {
        if (worldIn.field_9236) {
            return;
        }
        if (SlimeVineBlock.hasNoHorizontalSides(state)) {
            class_2680 newState = state;
            boolean onLeaves = worldIn.method_8320(pos.method_10084()).method_26164(TinkerTags.Blocks.SLIMY_LEAVES);
            for (class_2350 side : class_2350.class_2353.field_11062) {
                if (!onLeaves && !SlimeVineBlock.method_10821((class_1922)worldIn, (class_2338)pos.method_10093(side), (class_2350)side) || random.nextInt(6) != 0) continue;
                newState = (class_2680)newState.method_11657((class_2769)SlimeVineBlock.method_10828((class_2350)side), (Comparable)Boolean.valueOf(true));
            }
            if (newState != state) {
                worldIn.method_8652(pos, newState, 3);
            }
        } else if (random.nextInt(4) == 0) {
            this.grow((class_1936)worldIn, random, pos, state);
        }
    }

    public void grow(class_1936 worldIn, Random random, class_2338 pos, class_2680 state) {
        if (SlimeVineBlock.hasNoHorizontalSides(state) || state.method_11654(STAGE) == VineStage.END) {
            return;
        }
        class_2338 below = pos.method_10074();
        if (worldIn.method_22347(below)) {
            if (SlimeVineBlock.freeFloating(worldIn, pos, state)) {
                class_2680 above;
                int i;
                VineStage stage = (VineStage)((Object)state.method_11654(STAGE));
                for (i = 1; i < 3 && (above = worldIn.method_8320(pos.method_10086(i))).method_27852((class_2248)this) && above.method_11654(STAGE) == stage; ++i) {
                }
                if (i > 2 || random.nextInt(2) == 0) {
                    state = (class_2680)state.method_28493(STAGE);
                }
            }
            worldIn.method_8652(below, (class_2680)state.method_11657((class_2769)field_11703, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        return SlimeVineBlock.hasSides(this.updateConnections(state, (class_1922)worldIn, pos));
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (facing == class_2350.field_11033) {
            return super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        class_2680 updated = this.updateConnections(stateIn, (class_1922)worldIn, currentPos);
        return !SlimeVineBlock.hasSides(updated) ? class_2246.field_10124.method_9564() : updated;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 pos;
        class_1937 world = context.method_8045();
        class_2680 currState = world.method_8320(pos = context.method_8037());
        boolean isVine = currState.method_27852((class_2248)this);
        class_2680 vineState = isVine ? currState : this.method_9564();
        for (class_2350 direction : context.method_7718()) {
            if (direction == class_2350.field_11033) continue;
            class_2746 prop = SlimeVineBlock.method_10828((class_2350)direction);
            if (isVine && ((Boolean)currState.method_11654((class_2769)prop)).booleanValue() || !this.hasAttachment((class_1922)world, pos, direction)) continue;
            return (class_2680)vineState.method_11657((class_2769)prop, (Comparable)Boolean.valueOf(true));
        }
        return isVine ? vineState : null;
    }

    private static boolean hasSides(class_2680 state) {
        for (class_2746 booleanproperty : field_11697.values()) {
            if (!((Boolean)state.method_11654((class_2769)booleanproperty)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNoHorizontalSides(class_2680 state) {
        for (class_2350 side : class_2350.class_2353.field_11062) {
            if (!((Boolean)state.method_11654((class_2769)SlimeVineBlock.method_10828((class_2350)side))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean freeFloating(class_1936 world, class_2338 pos, class_2680 state) {
        for (class_2350 side : class_2350.class_2353.field_11062) {
            if (!((Boolean)state.method_11654((class_2769)SlimeVineBlock.method_10828((class_2350)side))).booleanValue() || !SlimeVineBlock.method_10821((class_1922)world, (class_2338)pos.method_10093(side), (class_2350)side)) continue;
            return false;
        }
        return true;
    }

    private class_2680 updateConnections(class_2680 state, class_1922 world, class_2338 pos) {
        class_2338 up = pos.method_10084();
        if (((Boolean)state.method_11654((class_2769)field_11703)).booleanValue()) {
            state = (class_2680)state.method_11657((class_2769)field_11703, (Comparable)Boolean.valueOf(SlimeVineBlock.method_10821((class_1922)world, (class_2338)up, (class_2350)class_2350.field_11036)));
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2746 prop = SlimeVineBlock.method_10828((class_2350)direction);
            if (!((Boolean)state.method_11654((class_2769)prop)).booleanValue()) continue;
            state = (class_2680)state.method_11657((class_2769)prop, (Comparable)Boolean.valueOf(this.hasAttachment(world, pos, direction)));
        }
        return state;
    }

    private boolean hasAttachment(class_1922 world, class_2338 pos, class_2350 side) {
        if (side == class_2350.field_11033) {
            return false;
        }
        class_2338 offset = pos.method_10093(side);
        if (SlimeVineBlock.method_10821((class_1922)world, (class_2338)offset, (class_2350)side)) {
            return true;
        }
        class_2680 upState = world.method_8320(pos.method_10084());
        if (upState.method_26164(TinkerTags.Blocks.SLIMY_LEAVES)) {
            return true;
        }
        return side != class_2350.field_11036 && upState.method_27852((class_2248)this) && (Boolean)upState.method_11654((class_2769)field_11697.get(side)) != false && upState.method_11654(STAGE) != VineStage.END;
    }

    public SlimeType getFoliage() {
        return this.foliage;
    }

    public static enum VineStage implements class_3542
    {
        START,
        MIDDLE,
        END;


        public String method_15434() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

