/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.entity;

import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.entity.ArmoredSlimeEntity;

public class SkySlimeEntity
extends ArmoredSlimeEntity {
    private double bounceAmount = 0.0;

    public SkySlimeEntity(class_1299<? extends SkySlimeEntity> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    protected float method_6106() {
        return (float)Math.sqrt(this.method_7152()) * this.method_23313() / 2.0f;
    }

    protected class_2394 method_7162() {
        return (class_2394)TinkerWorld.skySlimeParticle.get();
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        if (this.method_21750()) {
            return super.method_5747(distance, damageMultiplier * 0.2f, source);
        }
        LivingEntityEvents.Fall.FallEvent fallEvent = new LivingEntityEvents.Fall.FallEvent((class_1309)this, source, distance, damageMultiplier);
        fallEvent.sendEvent();
        distance = fallEvent.getDistance();
        if (distance > 2.0f) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352 / (double)0.95f, motion.field_1351 * -0.9, motion.field_1350 / (double)0.95f);
            this.bounceAmount = this.method_18798().field_1351;
            this.field_6017 = 0.0f;
            this.field_6007 = true;
            this.method_24830(false);
            this.method_5783(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
        }
        return false;
    }

    public void method_5784(class_1313 typeIn, class_243 pos) {
        super.method_5784(typeIn, pos);
        if (this.bounceAmount > 0.0) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352, this.bounceAmount, motion.field_1350);
            this.bounceAmount = 0.0;
        }
    }

    @Override
    protected void method_5964(class_1266 difficulty) {
        float multiplier = difficulty.method_5458();
        if (this.field_5974.nextFloat() < 0.15f * multiplier) {
            boolean isPlate = this.field_5974.nextFloat() < 0.05f * multiplier;
            class_1799 helmet = new class_1799((class_1935)(isPlate ? TinkerTools.plateArmor : TinkerTools.travelersGear).get((Enum)ArmorSlotType.HELMET));
            ToolStack tool = ToolStack.from(helmet);
            tool.ensureSlotsBuilt();
            ModifierNBT modifiers = tool.getUpgrades();
            ModDataNBT persistentData = tool.getPersistentData();
            if (!isPlate) {
                persistentData.putInt(TinkerModifiers.dyed.getId(), this.field_5974.nextInt(0x1000000));
                modifiers = modifiers.withModifier(TinkerModifiers.dyed.getId(), 1);
            }
            int max = tool.getFreeSlots(SlotType.DEFENSE);
            for (int i = 0; i < max && !(this.field_5974.nextFloat() > 0.5f * multiplier); ++i) {
                persistentData.addSlots(SlotType.DEFENSE, -1);
                modifiers = modifiers.withModifier(SkySlimeEntity.randomDefense(this.field_5974.nextInt(6)), 1);
            }
            if (tool.getFreeSlots(SlotType.UPGRADE) > 0 && this.field_5974.nextFloat() < 0.5f * multiplier) {
                persistentData.addSlots(SlotType.UPGRADE, -1);
                modifiers = modifiers.withModifier(this.field_5974.nextBoolean() ? ModifierIds.emerald : ModifierIds.diamond, 1);
            }
            tool.setUpgrades(modifiers);
            this.method_5673(class_1304.field_6169, helmet);
        }
    }

    private static ModifierId randomDefense(int index) {
        return switch (index) {
            default -> TinkerModifiers.meleeProtection.getId();
            case 1 -> TinkerModifiers.projectileProtection.getId();
            case 2 -> TinkerModifiers.fireProtection.getId();
            case 3 -> TinkerModifiers.magicProtection.getId();
            case 4 -> TinkerModifiers.blastProtection.getId();
            case 5 -> TinkerModifiers.golden.getId();
        };
    }

    @Override
    protected void method_5984(class_1266 difficulty) {
    }
}

