/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Optional;
import java.util.Random;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import slimeknights.tconstruct.world.worldgen.islands.SlimeIslandPiece;
import slimeknights.tconstruct.world.worldgen.islands.variants.IIslandVariant;

public abstract class AbstractIslandStructure
extends class_3195<class_3111> {
    protected static final String[] SIZES = new String[]{"0x1x0", "2x2x4", "4x1x6", "8x1x11", "11x1x11"};

    public AbstractIslandStructure(IIslandSettings settings) {
        super(class_3111.field_24893, context -> AbstractIslandStructure.pieceGeneratorSupplier((class_6834.class_6835<class_3111>)context, settings));
    }

    public class_2893.class_2895 method_28663() {
        return class_2893.class_2895.field_13173;
    }

    private static Optional<class_6622<class_3111>> pieceGeneratorSupplier(class_6834.class_6835<class_3111> context, IIslandSettings settings) {
        class_1923 chunkPos = context.comp_309();
        Random random = new Random((long)chunkPos.field_9181 + (long)chunkPos.field_9180 * 10387313L);
        class_2794 generator = context.comp_306();
        class_2470 rotation = class_2470.method_16548((Random)random);
        int height = settings.getHeight(context.comp_309(), generator, context.comp_311(), rotation, random);
        class_2338 targetPos = context.comp_309().method_33943(height);
        if (!context.comp_312().test(generator.method_16359(class_5742.method_33100((int)targetPos.method_10263()), class_5742.method_33100((int)targetPos.method_10264()), class_5742.method_33100((int)targetPos.method_10260())))) {
            return Optional.empty();
        }
        return Optional.of((builder, generatorContext) -> {
            class_2919 rand = generatorContext.comp_130();
            IIslandVariant variant = settings.getVariant((Random)rand);
            class_2415 mirror = (class_2415)class_156.method_27173((Object[])class_2415.values(), (Random)rand);
            builder.method_35462((class_3443)new SlimeIslandPiece(generatorContext.comp_126(), variant, (String)class_156.method_27173((Object[])SIZES, (Random)rand), targetPos, variant.getTreeFeature((Random)rand), rotation, mirror));
        });
    }

    protected static interface IIslandSettings {
        public IIslandVariant getVariant(Random var1);

        default public int getHeight(class_1923 chunkPos, class_2794 generator, class_5539 pLevel, class_2470 rotation, Random random) {
            int xOffset;
            int yOffset = switch (rotation) {
                case class_2470.field_11463 -> {
                    xOffset = -5;
                    yield 5;
                }
                case class_2470.field_11464 -> {
                    xOffset = -5;
                    yield -5;
                }
                case class_2470.field_11465 -> {
                    xOffset = 5;
                    yield -5;
                }
                default -> {
                    xOffset = 5;
                    yield 5;
                }
            };
            int x = chunkPos.method_33939(7);
            int z = chunkPos.method_33941(7);
            int minXMinZ = generator.method_18028(x, z, class_2902.class_2903.field_13194, pLevel);
            int minXMaxZ = generator.method_18028(x, z + yOffset, class_2902.class_2903.field_13194, pLevel);
            int maxXMinZ = generator.method_18028(x + xOffset, z, class_2902.class_2903.field_13194, pLevel);
            int maxXMaxZ = generator.method_18028(x + xOffset, z + yOffset, class_2902.class_2903.field_13194, pLevel);
            return Math.min(Math.min(Math.min(minXMinZ, minXMaxZ), Math.min(maxXMinZ, maxXMaxZ)) + 60 + random.nextInt(50), generator.method_12104() - 20);
        }
    }
}

