/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3341;
import net.minecraft.class_3470;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3773;
import net.minecraft.class_3793;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5458;
import net.minecraft.class_6625;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.variants.IIslandVariant;
import slimeknights.tconstruct.world.worldgen.islands.variants.IslandVariants;

public class SlimeIslandPiece
extends class_3470 {
    @Nullable
    private final class_2975<?, ?> tree;
    private final IIslandVariant variant;
    private int numberOfTreesPlaced;
    private class_2794 chunkGenerator;

    private SlimeIslandPiece(class_3485 manager, IIslandVariant variant, class_2960 templateName, class_2338 templatePos, @Nullable class_2975<?, ?> tree, class_2470 rotation, class_2415 mirror) {
        super((class_3773)TinkerStructures.slimeIslandPiece.get(), 0, manager, templateName, templateName.toString(), SlimeIslandPiece.makeSettings(rotation, mirror), templatePos);
        this.variant = variant;
        this.numberOfTreesPlaced = 0;
        this.tree = tree;
    }

    public SlimeIslandPiece(class_3485 manager, IIslandVariant variant, String templateName, class_2338 templatePos, @Nullable class_2975<?, ?> tree, class_2470 rotation, class_2415 mirror) {
        this(manager, variant, variant.getStructureName(templateName), templatePos, tree, rotation, mirror);
    }

    public SlimeIslandPiece(class_3485 templateManager, class_2487 nbt) {
        super((class_3773)TinkerStructures.slimeIslandPiece.get(), nbt, templateManager, context -> SlimeIslandPiece.makeSettings(class_2470.valueOf((String)nbt.method_10558("Rot")), class_2415.valueOf((String)nbt.method_10558("Mi"))));
        this.variant = IslandVariants.getVariantFromIndex(nbt.method_10550("Variant"));
        this.numberOfTreesPlaced = nbt.method_10550("NumberOfTreesPlaced");
        this.tree = Optional.of(nbt.method_10558("Tree")).filter(s -> !s.isEmpty()).map(class_2960::method_12829).flatMap(arg_0 -> ((class_2378)class_5458.field_25929).method_17966(arg_0)).orElse(null);
    }

    private static class_3492 makeSettings(class_2470 rotation, class_2415 mirror) {
        return new class_3492().method_15133(true).method_16184((class_3491)class_3793.field_16718).method_15123(rotation).method_15125(mirror);
    }

    protected void method_14943(class_6625 pContext, class_2487 tag) {
        class_2960 key;
        super.method_14943(pContext, tag);
        tag.method_10569("Variant", this.variant.getIndex());
        tag.method_10582("Rot", this.field_15434.method_15113().name());
        tag.method_10582("Mi", this.field_15434.method_15114().name());
        tag.method_10569("NumberOfTreesPlaced", this.numberOfTreesPlaced);
        if (this.tree != null && (key = class_5458.field_25929.method_10221(this.tree)) != null) {
            tag.method_10582("Tree", key.toString());
        }
    }

    protected void method_15026(String function, class_2338 pos, class_5425 level, Random rand, class_3341 sbb) {
        switch (function) {
            case "tconstruct:lake_bottom": {
                level.method_8652(pos, this.variant.getLakeBottom(), 2);
                break;
            }
            case "tconstruct:slime_fluid": {
                level.method_8652(pos, this.variant.getLakeFluid(), 2);
                break;
            }
            case "tconstruct:congealed_slime": {
                level.method_8652(pos, this.variant.getCongealedSlime(rand), 2);
                break;
            }
            case "tconstruct:slime_vine": {
                class_2680 vines = this.variant.getVines();
                if (vines == null || !rand.nextBoolean()) break;
                SlimeIslandPiece.placeVine((class_1936)level, pos, rand, vines);
                break;
            }
            case "tconstruct:slime_tree": {
                class_5281 worldgenLevel;
                if (this.tree == null || this.numberOfTreesPlaced >= 3 || !rand.nextBoolean() || !(level instanceof class_5281) || !this.tree.method_12862(worldgenLevel = (class_5281)level, this.chunkGenerator, rand, pos)) break;
                ++this.numberOfTreesPlaced;
                break;
            }
            case "tconstruct:slime_tall_grass": {
                class_2261 bush;
                class_2248 class_22482;
                class_2680 state;
                if (!rand.nextBoolean() || (state = this.variant.getPlant(rand)) == null || !((class_22482 = state.method_26204()) instanceof class_2261) || !(bush = (class_2261)class_22482).method_9558(state, (class_4538)level, pos)) break;
                level.method_8652(pos, state, 2);
            }
        }
    }

    private static void placeVine(class_1936 worldIn, class_2338 pos, Random random, class_2680 vineToPlace) {
        class_2680 state;
        class_2248 class_22482;
        for (class_2350 direction : class_2350.values()) {
            if (direction == class_2350.field_11033 || !SlimeVineBlock.method_10821((class_1922)worldIn, (class_2338)pos.method_10093(direction), (class_2350)direction)) continue;
            worldIn.method_8652(pos, (class_2680)vineToPlace.method_11657((class_2769)SlimeVineBlock.method_10828((class_2350)direction), (Comparable)Boolean.TRUE), 2);
        }
        class_2338 vinePos = pos;
        for (int size = random.nextInt(8); size >= 0 && (class_22482 = (state = worldIn.method_8320(vinePos)).method_26204()) instanceof SlimeVineBlock; --size) {
            SlimeVineBlock vine = (SlimeVineBlock)class_22482;
            vine.grow(worldIn, random, vinePos, state);
            vinePos = vinePos.method_10074();
        }
    }

    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, Random rand, class_3341 bounds, class_1923 chunk, class_2338 pos) {
        this.chunkGenerator = generator;
        if (this.variant.isPositionValid(world, this.field_15432, generator)) {
            super.method_14931(world, manager, generator, rand, bounds, chunk, pos);
        }
    }
}

