/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.trees.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_3747;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeTreeConfig;

public class SlimeTreeFeature
extends class_3031<SlimeTreeConfig> {
    public SlimeTreeFeature(Codec<SlimeTreeConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<SlimeTreeConfig> context) {
        HashSet trunkPos = Sets.newHashSet();
        HashSet foliagePos = Sets.newHashSet();
        HashSet leavesPos = Sets.newHashSet();
        class_3341 boundingBox = class_3341.method_14665();
        class_5281 level = context.method_33652();
        boolean placed = this.place(level, context.method_33654(), context.method_33655(), trunkPos, foliagePos, boundingBox, (SlimeTreeConfig)context.method_33656());
        if (boundingBox.method_35415() <= boundingBox.method_35418() && placed && !trunkPos.isEmpty()) {
            class_251 voxelshapepart = this.updateLeaves((class_1936)level, boundingBox, trunkPos, leavesPos);
            class_3499.method_20532((class_1936)level, (int)3, (class_251)voxelshapepart, (int)boundingBox.method_35415(), (int)boundingBox.method_35416(), (int)boundingBox.method_35417());
            return true;
        }
        return false;
    }

    private boolean place(class_5281 level, Random rand, class_2338 positionIn, Set<class_2338> trunkBlockPosSet, Set<class_2338> foliagePositions, class_3341 boundingBoxIn, SlimeTreeConfig configIn) {
        int height = rand.nextInt(configIn.randomHeight) + configIn.baseHeight;
        if (configIn.canDoubleHeight && rand.nextInt(10) == 0) {
            height *= 2;
        }
        if (positionIn.method_10264() >= level.method_31607() + 1 && positionIn.method_10264() + height + 1 <= level.method_31600() && SlimeTreeFeature.isSlimySoilAt((class_3746)level, positionIn.method_10074())) {
            this.setDirtAt(level, positionIn.method_10074(), positionIn);
            this.placeTrunk((class_3747)level, rand, height, positionIn, trunkBlockPosSet, boundingBoxIn, configIn);
            this.placeCanopy((class_3747)level, rand, height, positionIn, trunkBlockPosSet, boundingBoxIn, configIn);
            return true;
        }
        return false;
    }

    protected void setDirtAt(class_5281 reader, class_2338 pos, class_2338 origin) {
        class_2680 state = reader.method_8320(pos);
        if (state.method_26164(class_3481.field_29822)) {
            reader.method_8652(pos, class_2246.field_10566.method_9564(), 2);
        }
    }

    protected void placeTrunk(class_3747 worldIn, Random randomIn, int treeHeight, class_2338 blockPos, Set<class_2338> blockPosSet, class_3341 mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        while (treeHeight > 0) {
            this.setLog(worldIn, randomIn, blockPos, blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            blockPos = blockPos.method_10084();
            --treeHeight;
        }
    }

    protected void placeCanopy(class_3747 worldIn, Random randomIn, int treeHeight, class_2338 blockPos, Set<class_2338> blockPosSet, class_3341 mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        blockPos = blockPos.method_10086(treeHeight);
        for (int i = 0; i < 4; ++i) {
            this.placeDiamondLayer(worldIn, randomIn, i + 1, blockPos.method_10087(i), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        }
        blockPos = blockPos.method_10087(3);
        this.placeAir(worldIn, randomIn, blockPos.method_10069(4, 0, 0), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.method_10069(-4, 0, 0), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.method_10069(0, 0, 4), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.method_10069(0, 0, -4), blockPosSet, mutableBoundingBoxIn);
        if (treeFeatureConfigIn.hasVines) {
            this.placeAir(worldIn, randomIn, blockPos.method_10069(1, 0, 1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.method_10069(1, 0, -1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.method_10069(-1, 0, 1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.method_10069(-1, 0, -1), blockPosSet, mutableBoundingBoxIn);
        }
        blockPos = blockPos.method_10074();
        this.setLeaf(worldIn, randomIn, blockPos.method_10069(3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.method_10069(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.method_10069(0, 0, -3), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.method_10069(0, 0, 3), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        if (!treeFeatureConfigIn.hasVines) {
            this.setLeaf(worldIn, randomIn, blockPos.method_10069(1, 0, 1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.method_10069(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.method_10069(-1, 0, 1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.method_10069(-1, 0, -1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        }
        if (treeFeatureConfigIn.hasVines) {
            blockPos = blockPos.method_10074();
            this.placeVine(worldIn, randomIn, blockPos.method_10069(3, 0, 0), blockPosSet, mutableBoundingBoxIn, (class_2680)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.method_10069(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, (class_2680)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.method_10069(0, 0, -3), blockPosSet, mutableBoundingBoxIn, (class_2680)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.method_10069(0, 0, 3), blockPosSet, mutableBoundingBoxIn, (class_2680)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)));
            class_2680 randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.method_10069(2, 1, 2), blockPosSet, mutableBoundingBoxIn, (class_2680)randomVine.method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.method_10069(2, 0, 2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.method_10069(2, 1, -2), blockPosSet, mutableBoundingBoxIn, (class_2680)randomVine.method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.method_10069(2, 0, -2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.method_10069(-2, 1, 2), blockPosSet, mutableBoundingBoxIn, (class_2680)randomVine.method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.method_10069(-2, 0, 2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.method_10069(-2, 1, -2), blockPosSet, mutableBoundingBoxIn, (class_2680)randomVine.method_11657((class_2769)class_2541.field_11703, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.method_10069(-2, 0, -2), blockPosSet, mutableBoundingBoxIn, randomVine);
        }
    }

    private void placeDiamondLayer(class_3747 worldIn, Random randomIn, int range, class_2338 blockPos, Set<class_2338> blockPosSet, class_3341 mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) + Math.abs(z) > range) continue;
                class_2338 blockpos = blockPos.method_10069(x, 0, z);
                this.setLeaf(worldIn, randomIn, blockpos, blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            }
        }
    }

    protected boolean setLog(class_3747 worldIn, Random randomIn, class_2338 blockPos, Set<class_2338> blockPosSet, class_3341 mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((class_3746)worldIn, blockPos)) {
            return false;
        }
        this.method_13153((class_1945)worldIn, blockPos, treeFeatureConfigIn.trunkProvider.method_23455(randomIn, blockPos));
        blockPosSet.add(blockPos.method_10062());
        return true;
    }

    protected boolean placeAir(class_3747 worldIn, Random random, class_2338 blockPos, Set<class_2338> blockPosSet, class_3341 mutableBoundingBoxIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((class_3746)worldIn, blockPos)) {
            return false;
        }
        this.method_13153((class_1945)worldIn, blockPos, class_2246.field_10124.method_9564());
        blockPosSet.add(blockPos.method_10062());
        return true;
    }

    protected boolean setLeaf(class_3747 worldIn, Random random, class_2338 blockPos, Set<class_2338> blockPosSet, class_3341 mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((class_3746)worldIn, blockPos)) {
            return false;
        }
        this.method_13153((class_1945)worldIn, blockPos, treeFeatureConfigIn.leavesProvider.method_23455(random, blockPos));
        blockPosSet.add(blockPos.method_10062());
        return true;
    }

    protected boolean placeVine(class_3747 worldIn, Random random, class_2338 blockPos, Set<class_2338> blockPosSet, class_3341 mutableBoundingBoxIn, class_2680 vineState) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((class_3746)worldIn, blockPos)) {
            return false;
        }
        this.method_13153((class_1945)worldIn, blockPos, vineState);
        blockPosSet.add(blockPos.method_10062());
        return true;
    }

    private class_2680 getRandomizedVine(Random random, class_2338 blockPos, SlimeTreeConfig config) {
        class_2746[] sides;
        class_2680 state = config.vinesProvider.method_23455(random, blockPos);
        for (class_2746 side : sides = new class_2746[]{class_2541.field_11706, class_2541.field_11702, class_2541.field_11699, class_2541.field_11696}) {
            state = (class_2680)state.method_11657((class_2769)side, (Comparable)Boolean.valueOf(false));
        }
        for (int i = random.nextInt(3) + 1; i > 0; --i) {
            state = (class_2680)state.method_11657((class_2769)sides[random.nextInt(sides.length)], (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean isEmptyOrLogAt(class_3746 reader, class_2338 blockPos) {
        return SlimeTreeFeature.isReplaceableAt(reader, blockPos) || reader.method_16358(blockPos, state -> state.method_26164(class_3481.field_15475));
    }

    private static boolean isVineAt(class_3746 reader, class_2338 blockPos) {
        return reader.method_16358(blockPos, state -> state.method_27852(class_2246.field_10597));
    }

    private static boolean isWaterAt(class_3746 reader, class_2338 blockPos) {
        return reader.method_16358(blockPos, state -> state.method_27852(class_2246.field_10382));
    }

    public static boolean isAirOrLeavesAt(class_3746 reader, class_2338 blockPos) {
        return reader.method_16358(blockPos, state -> state.method_26215() || state.method_26164(class_3481.field_15503));
    }

    private static boolean isSlimySoilAt(class_3746 reader, class_2338 blockPos) {
        return reader.method_16358(blockPos, state -> state.method_26164(TinkerTags.Blocks.SLIMY_SOIL));
    }

    private static boolean isTallPlantAt(class_3746 reader, class_2338 blockPos) {
        return reader.method_16358(blockPos, state -> state.method_26207() == class_3614.field_15956);
    }

    public static boolean isReplaceableAt(class_3746 reader, class_2338 blockPos) {
        return SlimeTreeFeature.isAirOrLeavesAt(reader, blockPos) || SlimeTreeFeature.isTallPlantAt(reader, blockPos) || SlimeTreeFeature.isWaterAt(reader, blockPos);
    }

    public static void setBlockStateAt(class_1945 writer, class_2338 blockPos, class_2680 state) {
        writer.method_8652(blockPos, state, 19);
    }

    private class_251 updateLeaves(class_1936 world, class_3341 boundingBox, Set<class_2338> logs, Set<class_2338> leaves) {
        ArrayList distanceList = Lists.newArrayList();
        class_244 shapePart = new class_244(boundingBox.method_35414(), boundingBox.method_14660(), boundingBox.method_14663());
        for (int j = 0; j < 6; ++j) {
            distanceList.add(Sets.newHashSet());
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2338 leavePos : Lists.newArrayList(leaves)) {
            if (!boundingBox.method_14662((class_2382)leavePos)) continue;
        }
        for (class_2338 logPos : Lists.newArrayList(logs)) {
            if (boundingBox.method_14662((class_2382)logPos)) {
                // empty if block
            }
            for (class_2350 direction : class_2350.values()) {
                class_2680 blockstate;
                mutable.method_25505((class_2382)logPos, direction);
                if (logs.contains(mutable) || !(blockstate = world.method_8320((class_2338)mutable)).method_28498((class_2769)class_2741.field_12541)) continue;
                ((Set)distanceList.get(0)).add(mutable.method_10062());
                SlimeTreeFeature.setBlockStateAt((class_1945)world, (class_2338)mutable, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                if (!boundingBox.method_14662((class_2382)mutable)) continue;
            }
        }
        for (int distance = 1; distance < 6; ++distance) {
            Set current = (Set)distanceList.get(distance - 1);
            Set next = (Set)distanceList.get(distance);
            for (class_2338 pos : current) {
                if (boundingBox.method_14662((class_2382)pos)) {
                    // empty if block
                }
                for (class_2350 direction : class_2350.values()) {
                    int stateDistance;
                    class_2680 state;
                    mutable.method_25505((class_2382)pos, direction);
                    if (current.contains(mutable) || next.contains(mutable) || !(state = world.method_8320((class_2338)mutable)).method_28498((class_2769)class_2741.field_12541) || (stateDistance = ((Integer)state.method_11654((class_2769)class_2741.field_12541)).intValue()) <= distance + 1) continue;
                    class_2680 furtherState = (class_2680)state.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(distance + 1));
                    SlimeTreeFeature.setBlockStateAt((class_1945)world, (class_2338)mutable, furtherState);
                    if (boundingBox.method_14662((class_2382)mutable)) {
                        // empty if block
                    }
                    next.add(mutable.method_10062());
                }
            }
        }
        return shapePart;
    }
}

