/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.serialization;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.PuzzlesLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class StringEntryReader<T> {
    private final class_2378<T> activeRegistry;

    protected StringEntryReader(class_2378<T> registry) {
        this.activeRegistry = registry;
    }

    protected final List<T> getEntriesFromRegistry(String source) {
        return StringEntryReader.getEntriesFromRegistry(source, this.activeRegistry);
    }

    public static <R> List<R> getEntriesFromRegistry(String source, class_2378<R> activeRegistry) {
        ArrayList foundEntries = Lists.newArrayList();
        if (source.contains("*")) {
            foundEntries.addAll(StringEntryReader.getWildcardEntries(source, activeRegistry));
        } else {
            Optional<class_2960> location = Optional.ofNullable(class_2960.method_12829((String)source));
            if (location.isPresent()) {
                Optional<R> entry = StringEntryReader.getEntryFromRegistry(location.get(), activeRegistry);
                entry.ifPresent(foundEntries::add);
            } else {
                StringEntryReader.log(source, "Entry not found");
            }
        }
        return foundEntries;
    }

    private static <R> Optional<R> getEntryFromRegistry(class_2960 location, class_2378<R> activeRegistry) {
        if (activeRegistry.method_10250(location)) {
            return Optional.ofNullable(activeRegistry.method_10223(location));
        }
        StringEntryReader.log(location.toString(), "Entry not found");
        return Optional.empty();
    }

    private static <R> List<R> getWildcardEntries(String source, class_2378<R> activeRegistry) {
        String[] splitSource = source.split(":");
        switch (splitSource.length) {
            case 1: {
                return StringEntryReader.getListFromRegistry("minecraft", splitSource[0], activeRegistry);
            }
            case 2: {
                return StringEntryReader.getListFromRegistry(splitSource[0], splitSource[1], activeRegistry);
            }
        }
        StringEntryReader.log(source, "Invalid resource location format");
        return Lists.newArrayList();
    }

    private static <R> List<R> getListFromRegistry(String namespace, String path, class_2378<R> activeRegistry) {
        String regexPath = path.replace("*", "[a-z0-9/._-]*");
        List entries = activeRegistry.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals(namespace)).filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12832().matches(regexPath)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (entries.isEmpty()) {
            StringEntryReader.log(new class_2960(namespace, path).toString(), "Entry not found");
        }
        return entries;
    }

    protected final boolean isNotPresent(Collection<T> collection, T entry) {
        if (collection.contains(entry)) {
            StringEntryReader.log(entry.getClass().getSimpleName(), "Already present");
            return false;
        }
        return true;
    }

    protected static void log(String entry, String message) {
        PuzzlesLib.LOGGER.warn("Unable to parse entry {}: {}", (Object)entry, (Object)message);
    }
}

