/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import fuzs.puzzleslib.core.ModLoaderEnvironment;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import org.jetbrains.annotations.Nullable;

public class EnvTypeExecutor {
    @Nullable
    public static <T> T callWhenOn(EnvType envType, Supplier<Callable<T>> toRun) {
        if (ModLoaderEnvironment.isEnvironmentType(envType)) {
            try {
                return toRun.get().call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void runWhenOn(EnvType envType, Supplier<Runnable> toRun) {
        if (ModLoaderEnvironment.isEnvironmentType(envType)) {
            toRun.get().run();
        }
    }

    public static <T> T runForEnvType(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return switch (ModLoaderEnvironment.getEnvironmentType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnvType.CLIENT -> clientTarget.get().get();
            case EnvType.SERVER -> serverTarget.get().get();
        };
    }
}

