/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.data;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import reborncore.client.screen.builder.BlockEntityScreenHandlerBuilder;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.serialization.SerializationUtil;
import techreborn.blockentity.data.DataDrivenSlot;
import techreborn.blockentity.data.SlotType;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.init.ModRecipes;

public class DataDrivenBEProvider
extends class_2591<DataDrivenBlockEntity>
implements BiFunction<class_2338, class_2680, class_2586> {
    private final class_2960 identifier;
    private final class_2248 block;
    private final int energy;
    private final int maxInput;
    private final List<DataDrivenSlot> slots;

    public static DataDrivenBEProvider create(class_2248 block, class_2960 identifier) {
        JsonObject jsonObject;
        String location = String.format("%s/machines/%s.json", identifier.method_12836(), identifier.method_12832());
        try {
            jsonObject = (JsonObject)SerializationUtil.GSON.fromJson(IOUtils.toString((InputStream)FabricLauncherBase.getLauncher().getResourceAsStream(location), (Charset)StandardCharsets.UTF_8), JsonObject.class);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to read json: " + location, e);
        }
        class_2960 id = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"name"));
        DataDrivenBEProvider provider = new DataDrivenBEProvider(block, jsonObject);
        class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)id, (Object)provider);
        return provider;
    }

    private DataDrivenBEProvider(class_2248 block, JsonObject jsonObject) {
        super(null, (Set)ImmutableSet.copyOf(Collections.singletonList(block)), null);
        this.block = block;
        this.identifier = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"name"));
        this.energy = class_3518.method_15260((JsonObject)jsonObject, (String)"energy");
        this.maxInput = class_3518.method_15260((JsonObject)jsonObject, (String)"maxInput");
        this.slots = DataDrivenSlot.read(class_3518.method_15261((JsonObject)jsonObject, (String)"slots"));
        Validate.isTrue((this.getEnergySlot() > 0 ? 1 : 0) != 0);
    }

    @Nullable
    public DataDrivenBlockEntity instantiate(class_2338 pos, class_2680 state) {
        return new DataDrivenBlockEntity(this, pos, state);
    }

    public BuiltScreenHandler createScreenHandler(DataDrivenBlockEntity blockEntity, int syncID, class_1657 player) {
        BlockEntityScreenHandlerBuilder builder = new ScreenHandlerBuilder(this.identifier.method_12832()).player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)blockEntity);
        this.slots.forEach(dataDrivenSlot -> dataDrivenSlot.add(builder));
        builder.syncEnergyValue().syncCrafterValue();
        return builder.addInventory().create((MachineBaseBlockEntity)blockEntity, syncID);
    }

    @Override
    public class_2586 apply(class_2338 pos, class_2680 state) {
        return this.instantiate(pos, state);
    }

    private int getEnergySlot() {
        return ((DataDrivenSlot)this.slots.stream().filter(slot -> slot.type() == SlotType.ENERGY).findFirst().orElse(null)).id();
    }

    private int countOfSlotType(SlotType type) {
        return (int)this.slots.stream().filter(slot -> slot.type() == type).count();
    }

    private int[] slotIds(SlotType type) {
        return this.slots.stream().filter(slot -> slot.type() == type).mapToInt(DataDrivenSlot::id).toArray();
    }

    public List<DataDrivenSlot> getSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    private String getSimpleName() {
        return WordUtils.capitalize((String)this.identifier.method_12832());
    }

    public static class DataDrivenBlockEntity
    extends GenericMachineBlockEntity
    implements BuiltScreenHandlerProvider {
        private final DataDrivenBEProvider provider;

        private DataDrivenBlockEntity(DataDrivenBEProvider provider, class_2338 pos, class_2680 state) {
            super(provider, pos, state, provider.getSimpleName(), provider.maxInput, provider.energy, provider.block, provider.getEnergySlot());
            this.provider = provider;
            RebornRecipeType<?> recipeType = ModRecipes.byName(provider.identifier);
            Validate.notNull(recipeType);
            this.inventory = new RebornInventory(provider.slots.size(), provider.getSimpleName() + "BlockEntity", 64, (MachineBaseBlockEntity)this);
            this.crafter = new RecipeCrafter(recipeType, (class_2586)this, provider.countOfSlotType(SlotType.INPUT), provider.countOfSlotType(SlotType.OUTPUT), this.inventory, provider.slotIds(SlotType.INPUT), provider.slotIds(SlotType.OUTPUT));
        }

        public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
            return this.provider.createScreenHandler(this, syncID, player);
        }

        public DataDrivenBEProvider getProvider() {
            return this.provider;
        }
    }
}

