/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.widget.GuiButtonExtended;
import reborncore.client.gui.builder.widget.GuiButtonUpDown;
import reborncore.client.gui.guibuilder.GuiBuilder;
import reborncore.common.network.IdentifiedPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.util.Color;
import reborncore.common.util.Torus;
import techreborn.blockentity.machine.multiblock.fusion.FusionControlComputerBlockEntity;
import techreborn.packets.ServerboundPackets;

public class GuiFusionReactor
extends GuiBase<BuiltScreenHandler> {
    private final FusionControlComputerBlockEntity blockEntity;

    public GuiFusionReactor(int syncID, class_1657 player, FusionControlComputerBlockEntity blockEntity) {
        super(player, (class_2586)blockEntity, (class_1703)blockEntity.createScreenHandler(syncID, player));
        this.blockEntity = blockEntity;
    }

    public void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new GuiButtonUpDown(this.field_2776 + 121, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(5), GuiButtonUpDown.UpDownButtonType.FASTFORWARD));
        this.method_37063((class_364)new GuiButtonUpDown(this.field_2776 + 121 + 12, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(1), GuiButtonUpDown.UpDownButtonType.FORWARD));
        this.method_37063((class_364)new GuiButtonUpDown(this.field_2776 + 121 + 24, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(-1), GuiButtonUpDown.UpDownButtonType.REWIND));
        this.method_37063((class_364)new GuiButtonUpDown(this.field_2776 + 121 + 36, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(-5), GuiButtonUpDown.UpDownButtonType.FASTREWIND));
    }

    protected void method_2389(class_4587 matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(matrixStack, partialTicks, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(matrixStack, 34, 47, layer);
        this.drawSlot(matrixStack, 126, 47, layer);
        this.drawOutputSlot(matrixStack, 80, 47, layer);
        this.builder.drawJEIButton(matrixStack, (GuiBase)this, 158, 5, layer);
        if (this.blockEntity.isMultiblockValid()) {
            this.builder.drawHologramButton(matrixStack, (GuiBase)this, 6, 4, mouseX, mouseY, layer);
        }
    }

    protected void method_2388(class_4587 matrixStack, int mouseX, int mouseY) {
        super.method_2388(matrixStack, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar(matrixStack, (GuiBase)this, this.blockEntity.getProgressScaled(100), 100, 55, 51, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
        this.builder.drawProgressBar(matrixStack, (GuiBase)this, this.blockEntity.getProgressScaled(100), 100, 105, 51, mouseX, mouseY, GuiBuilder.ProgressDirection.LEFT, layer);
        if (this.blockEntity.isMultiblockValid()) {
            this.addHologramButton(6, 4, 212, layer).clickHandler(this::hologramToggle);
            this.drawCentredText(matrixStack, this.blockEntity.getStateText(), 20, Color.BLUE.darker().getColor(), layer);
            if (this.blockEntity.state.getValue() == 2) {
                this.drawCentredText(matrixStack, (class_2561)new class_2585(PowerSystem.getLocalizedPower((double)this.blockEntity.getPowerChange())).method_27693("/t"), 30, Color.GREEN.darker().getColor(), layer);
            }
        } else {
            this.builder.drawMultiblockMissingBar(matrixStack, (GuiBase)this, layer);
            this.addHologramButton(76, 56, 212, layer).clickHandler(this::hologramToggle);
            this.builder.drawHologramButton(matrixStack, (GuiBase)this, 76, 56, mouseX, mouseY, layer);
            Optional<Pair<Integer, Integer>> stackSize = this.getCoilStackCount();
            if (stackSize.isPresent()) {
                if ((Integer)stackSize.get().getLeft() > 0) {
                    this.drawCentredText(matrixStack, (class_2561)new class_2585("Required Coils: ").method_27693(String.valueOf(stackSize.get().getLeft())).method_27693("x64 +").method_27693(String.valueOf(stackSize.get().getRight())), 25, 0xFFFFFF, layer);
                } else {
                    this.drawCentredText(matrixStack, (class_2561)new class_2585("Required Coils: ").method_27693(String.valueOf(stackSize.get().getRight())), 25, 0xFFFFFF, layer);
                }
            }
        }
        GuiFusionReactor.method_27535((class_4587)matrixStack, (class_327)this.field_22793, (class_2561)new class_2585("Size: ").method_27693(String.valueOf(this.blockEntity.size)), (int)83, (int)81, (int)0xFFFFFF);
        GuiFusionReactor.method_27535((class_4587)matrixStack, (class_327)this.field_22793, (class_2561)new class_2585(String.valueOf(this.blockEntity.getPowerMultiplier())).method_27693("x"), (int)10, (int)81, (int)0xFFFFFF);
        this.builder.drawMultiEnergyBar(matrixStack, (GuiBase)this, 9, 19, this.blockEntity.getEnergy(), this.blockEntity.getMaxStoredPower(), mouseX, mouseY, 0, layer);
    }

    public void hologramToggle(GuiButtonExtended button, double x, double y) {
        this.blockEntity.renderMultiblock = this.blockEntity.renderMultiblock ^ !this.hideGuiElements();
    }

    private void sendSizeChange(int sizeDelta) {
        NetworkManager.sendToServer((IdentifiedPacket)ServerboundPackets.createPacketFusionControlSize(sizeDelta, this.blockEntity.method_11016()));
    }

    public Optional<Pair<Integer, Integer>> getCoilStackCount() {
        if (!Torus.getTorusSizeCache().containsKey(this.blockEntity.size)) {
            return Optional.empty();
        }
        int count = Torus.getTorusSizeCache().get(this.blockEntity.size);
        return Optional.of(Pair.of((Object)(count / 64), (Object)(count % 64)));
    }
}

