/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei.fluidreplicator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;

public class FluidReplicatorRecipeDisplay
implements Display {
    private final FluidReplicatorRecipe recipe;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> output;
    private final FluidInstance fluidInstance;
    private final int energy;
    private final int time;

    public FluidReplicatorRecipeDisplay(FluidReplicatorRecipe recipe) {
        this.recipe = recipe;
        this.inputs = CollectionUtils.map((Collection)recipe.getRebornIngredients(), ing -> EntryIngredients.ofItemStacks((Collection)ing.getPreviewStacks()));
        this.fluidInstance = recipe.getFluidInstance();
        this.output = this.fluidInstance == null ? Collections.emptyList() : Collections.singletonList(EntryIngredients.of((class_3611)this.fluidInstance.getFluid(), (long)this.fluidInstance.getAmount().getRawValue()));
        this.energy = recipe.getPower();
        this.time = recipe.getTime();
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getTime() {
        return this.time;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return CategoryIdentifier.of((class_2960)this.recipe.getRebornRecipeType().name());
    }

    public Optional<class_2960> getDisplayLocation() {
        return Optional.ofNullable(this.recipe).map(RebornRecipe::method_8114);
    }
}

