/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kir.packedinventory.api.v1.item.GenericContainerTooltipData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class GenericContainerTooltipComponent
implements class_5684 {
    private static final class_2960 TEXTURE = new class_2960("textures/gui/container/bundle.png");
    private static final int BORDER_SIZE = 1;
    private static final int VERTICAL_MARGIN = 4;
    private static final int SLOT_WIDTH = 18;
    private static final int SLOT_HEIGHT = 20;
    private static final int TEXTURE_SIZE = 128;
    private static final float[] TRUE_WHITE = new float[]{1.0f, 1.0f, 1.0f};
    private final class_1263 inventory;
    private final float[] color;
    private final int rows;
    private final int columns;

    public GenericContainerTooltipComponent(GenericContainerTooltipData tooltipData) {
        this.inventory = tooltipData.getInventory();
        this.color = tooltipData.getColor() == null ? TRUE_WHITE : tooltipData.getColor().method_7787();
        this.rows = tooltipData.getRows();
        this.columns = tooltipData.getColumns();
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public float[] getColor() {
        return this.color;
    }

    public int getColumns() {
        return this.columns;
    }

    private int getRows() {
        return this.rows;
    }

    public int method_32661() {
        return this.getRows() * 20 + 2 + 4;
    }

    public int method_32664(class_327 textRenderer) {
        return this.getColumns() * 18 + 2;
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_4587 matrices, class_918 itemRenderer, int z) {
        int columns = this.getColumns();
        int rows = this.getRows();
        int i = 0;
        for (int rI = 0; rI < rows; ++rI) {
            for (int cI = 0; cI < columns; ++cI) {
                int xS = x + cI * 18 + 1;
                int yS = y + rI * 20 + 1;
                this.drawSlot(matrices, i++, xS, yS, z, textRenderer, itemRenderer);
            }
        }
        this.drawOutline(matrices, x, y, z, columns, rows);
    }

    protected void drawSlot(class_4587 matrices, int index, int x, int y, int z, class_327 textRenderer, class_918 itemRenderer) {
        class_1263 inventory = this.getInventory();
        if (index >= inventory.method_5439()) {
            this.draw(matrices, x, y, z, Sprite.BLOCKED_SLOT);
            return;
        }
        class_1799 itemStack = inventory.method_5438(index);
        this.draw(matrices, x, y, z, Sprite.SLOT);
        itemRenderer.method_32797(itemStack, x + 1, y + 1, index);
        itemRenderer.method_4025(textRenderer, itemStack, x + 1, y + 1);
    }

    protected void drawOutline(class_4587 matrices, int x, int y, int z, int columns, int rows) {
        int i;
        this.draw(matrices, x, y, z, Sprite.BORDER_CORNER_TOP);
        this.draw(matrices, x + columns * 18 + 1, y, z, Sprite.BORDER_CORNER_TOP);
        for (i = 0; i < columns; ++i) {
            this.draw(matrices, x + 1 + i * 18, y, z, Sprite.BORDER_HORIZONTAL_TOP);
            this.draw(matrices, x + 1 + i * 18, y + rows * 20, z, Sprite.BORDER_HORIZONTAL_BOTTOM);
        }
        for (i = 0; i < rows; ++i) {
            this.draw(matrices, x, y + i * 20 + 1, z, Sprite.BORDER_VERTICAL);
            this.draw(matrices, x + columns * 18 + 1, y + i * 20 + 1, z, Sprite.BORDER_VERTICAL);
        }
        this.draw(matrices, x, y + rows * 20, z, Sprite.BORDER_CORNER_BOTTOM);
        this.draw(matrices, x + columns * 18 + 1, y + rows * 20, z, Sprite.BORDER_CORNER_BOTTOM);
    }

    private void draw(class_4587 matrices, int x, int y, int z, Sprite sprite) {
        this.draw(matrices, x, y, z, sprite, this.getColor());
    }

    protected void draw(class_4587 matrices, int x, int y, int z, Sprite sprite, float[] color) {
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        class_332.method_25291((class_4587)matrices, (int)x, (int)y, (int)z, (float)sprite.u, (float)sprite.v, (int)sprite.width, (int)sprite.height, (int)128, (int)128);
    }

    protected static enum Sprite {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int u;
        public final int v;
        public final int width;
        public final int height;

        private Sprite(int u, int v, int width, int height) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }
    }
}

