/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.inventory;

import dev.kir.packedinventory.api.v1.FailureReason;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface InventoryValidationFailureHandler {
    public void handle(FailureReason var1, class_1263 var2, int var3, class_1657 var4);

    @FunctionalInterface
    public static interface ItemPredicate
    extends Predicate {
        public Set<class_1792> getItems();

        @Override
        default public boolean test(FailureReason failureReason, class_1263 inventory, int slot, class_1657 player) {
            return this.getItems().contains(inventory.method_5438(slot).method_7909());
        }

        @Override
        default public ItemPredicate and(Predicate other) {
            return (ItemPredicate)Predicate.super.and(other);
        }

        @Override
        default public ItemPredicate or(Predicate other) {
            return (ItemPredicate)Predicate.super.or(other);
        }

        public static ItemPredicate of(Collection<class_1792> items) {
            return ItemPredicate.of(items, null);
        }

        public static ItemPredicate of(Collection<class_1792> items, final @Nullable Predicate innerPredicate) {
            final Set<class_1792> itemSet = Set.copyOf(items);
            if (innerPredicate == null) {
                return () -> itemSet;
            }
            return new ItemPredicate(){

                @Override
                public Set<class_1792> getItems() {
                    return itemSet;
                }

                @Override
                public boolean test(FailureReason failureReason, class_1263 inventory, int slot, class_1657 player) {
                    return innerPredicate.test(failureReason, inventory, slot, player);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Predicate {
        public static final Predicate TRUE = (f, i, s, p) -> true;
        public static final Predicate FALSE = (f, i, s, p) -> false;

        public boolean test(FailureReason var1, class_1263 var2, int var3, class_1657 var4);

        default public Predicate and(final Predicate other) {
            Set<class_1792> items = null;
            if (this instanceof ItemPredicate) {
                items = ((ItemPredicate)this).getItems();
            }
            if (other instanceof ItemPredicate) {
                if (items == null) {
                    items = ((ItemPredicate)other).getItems();
                } else {
                    items = new HashSet<class_1792>(items);
                    items.retainAll(((ItemPredicate)other).getItems());
                    items = Set.copyOf(items);
                }
            }
            final Predicate it = this;
            if (items != null) {
                final Set<class_1792> finalItems = items;
                return new ItemPredicate(){

                    @Override
                    public Set<class_1792> getItems() {
                        return finalItems;
                    }

                    @Override
                    public boolean test(FailureReason failureReason, class_1263 inventory, int slot, class_1657 player) {
                        return it.test(failureReason, inventory, slot, player) && other.test(failureReason, inventory, slot, player);
                    }
                };
            }
            return (f, i, s, p) -> it.test(f, i, s, p) && other.test(f, i, s, p);
        }

        default public Predicate or(final Predicate other) {
            Set<class_1792> items = null;
            if (this instanceof ItemPredicate) {
                items = ((ItemPredicate)this).getItems();
            }
            if (other instanceof ItemPredicate) {
                if (items == null) {
                    items = ((ItemPredicate)other).getItems();
                } else {
                    items = new HashSet<class_1792>(items);
                    items.addAll(((ItemPredicate)other).getItems());
                    items = Set.copyOf(items);
                }
            }
            final Predicate it = this;
            if (items != null) {
                final Set<class_1792> finalItems = items;
                return new ItemPredicate(){

                    @Override
                    public Set<class_1792> getItems() {
                        return finalItems;
                    }

                    @Override
                    public boolean test(FailureReason failureReason, class_1263 inventory, int slot, class_1657 player) {
                        return it.test(failureReason, inventory, slot, player) || other.test(failureReason, inventory, slot, player);
                    }
                };
            }
            return (f, i, s, p) -> it.test(f, i, s, p) || other.test(f, i, s, p);
        }
    }
}

