/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.inventory;

import dev.kir.packedinventory.api.v1.FailureReason;
import dev.kir.packedinventory.api.v1.config.PackedInventoryApiConfig;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewer;
import dev.kir.packedinventory.util.entity.EntityUtil;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class InventoryValidators {
    private static final Map<class_1887, Integer> SILK_TOUCH_ENCHANTMENT = Map.of(class_1893.field_9099, 1);
    public static final InventoryViewer.Validator EMPTY = InventoryViewer.Validator.EMPTY;
    public static final InventoryViewer.Validator SINGLE_ITEM = (inv, slot, player) -> inv.method_5438(slot).method_7947() == 1 ? null : FailureReason.STACK_CONSISTS_OF_MORE_THAN_ONE_ITEM;
    public static final InventoryViewer.Validator IS_ON_GROUND = (inv, slot, player) -> player.method_24828() ? null : FailureReason.PLAYER_IS_NOT_ON_THE_GROUND;
    public static final InventoryViewer.Validator IS_IN_CREATIVE = (inv, slot, player) -> player.method_31549().field_7477 ? null : FailureReason.PLAYER_IS_NOT_IN_THE_CREATIVE_MODE;
    public static final InventoryViewer.Validator HAS_PICKAXE_WITH_SILK_TOUCH = InventoryValidators.hasSilkTouchToolFor(class_2246.field_10340, 1, FailureReason.PLAYER_NEEDS_PICKAXE_ENCHANTED_WITH_SILK_TOUCH_ENCHANTMENT);

    public static <TConfig> InventoryViewer.Validator config(class_1792 item, PackedInventoryApiConfig config, TConfig defaultConfig, Predicate<TConfig> predicate) {
        return InventoryValidators.config(class_2378.field_11142.method_10221((Object)item), config, defaultConfig, predicate);
    }

    public static <TConfig> InventoryViewer.Validator config(class_2960 id, PackedInventoryApiConfig config, TConfig defaultConfig, Predicate<TConfig> predicate) {
        return (player, inv, slot) -> {
            Object cfg = config.getValidationConfigOrDefault(id, defaultConfig);
            return predicate.test(cfg) ? null : FailureReason.OTHER_PROBLEM;
        };
    }

    public static <TConfig> InventoryViewer.Validator config(class_1792 item, PackedInventoryApiConfig config, Class<TConfig> configClass, Predicate<TConfig> predicate) {
        return InventoryValidators.config(class_2378.field_11142.method_10221((Object)item), config, configClass, predicate);
    }

    public static <TConfig> InventoryViewer.Validator config(class_2960 id, PackedInventoryApiConfig config, Class<TConfig> configClass, Predicate<TConfig> predicate) {
        return (player, inv, slot) -> {
            Object cfg = config.getValidationConfig(id, configClass);
            if (cfg == null) {
                return FailureReason.OTHER_PROBLEM;
            }
            return predicate.test(cfg) ? null : FailureReason.OTHER_PROBLEM;
        };
    }

    public static InventoryViewer.Validator hasSilkTouchToolFor(class_2248 block, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, SILK_TOUCH_ENCHANTMENT, failureReason);
    }

    public static InventoryViewer.Validator hasSilkTouchToolFor(class_2248 block, int damageAmount, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, SILK_TOUCH_ENCHANTMENT, damageAmount, failureReason);
    }

    public static InventoryViewer.Validator hasSilkTouchToolFor(class_2248 block, int minRemainingDurability, int damageAmount, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, SILK_TOUCH_ENCHANTMENT, minRemainingDurability, damageAmount, failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, Map.of(), failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, int damageAmount, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, Map.of(), damageAmount, failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, int minRemainingDurability, int damageAmount, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, Map.of(), minRemainingDurability, damageAmount, failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, Collection<class_1887> enchantments, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, enchantments.stream().collect(Collectors.toMap(x -> x, x -> 1)), failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, Map<class_1887, Integer> enchantments, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, enchantments, 0, 0, failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, Collection<class_1887> enchantments, int damageAmount, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, enchantments.stream().collect(Collectors.toMap(x -> x, x -> 1)), damageAmount, failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, Map<class_1887, Integer> enchantments, int damageAmount, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, enchantments, damageAmount > 0 ? damageAmount + 1 : 0, damageAmount, failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, Collection<class_1887> enchantments, int minRemainingDurability, int damageAmount, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasToolFor(block, enchantments.stream().collect(Collectors.toMap(x -> x, x -> 1)), minRemainingDurability, damageAmount, failureReason);
    }

    public static InventoryViewer.Validator hasToolFor(class_2248 block, Map<class_1887, Integer> enchantments, int minRemainingDurability, int damageAmount, @Nullable FailureReason failureReason) {
        class_2680 blockState = block.method_9564();
        BiPredicate<class_1799, class_1263> hasToolPredicate = (x, i) -> x.method_7951(blockState);
        if (minRemainingDurability > 0) {
            hasToolPredicate = hasToolPredicate.and((x, i) -> x.method_7936() - x.method_7919() >= minRemainingDurability);
        }
        for (Map.Entry<class_1887, Integer> enchantmentEntry : enchantments.entrySet()) {
            class_1887 enchantment = enchantmentEntry.getKey();
            int level = enchantmentEntry.getValue();
            hasToolPredicate = hasToolPredicate.and((x, i) -> class_1890.method_8225((class_1887)enchantment, (class_1799)x) >= level);
        }
        BiFunction<class_1799, class_1263, class_1799> itemStackModifier = null;
        if (damageAmount > 0) {
            itemStackModifier = (x, i) -> {
                class_1657 miner;
                class_1657 class_16572 = miner = i instanceof class_1661 ? ((class_1661)i).field_7546 : null;
                if (miner == null) {
                    miner = EntityUtil.getFakeServerLivingEntity();
                }
                x.method_7956(damageAmount, (class_1309)miner, e -> {
                    if (EntityUtil.isFakeEntity((class_1297)e)) {
                        return;
                    }
                    class_1304 slot = null;
                    for (class_1304 testSlot : class_1304.values()) {
                        if (e.method_6118(testSlot) != x) continue;
                        slot = testSlot;
                        break;
                    }
                    if (slot != null) {
                        e.method_20235(slot);
                    }
                });
                return x;
            };
        }
        return InventoryValidators.hasItemStack(hasToolPredicate, itemStackModifier, failureReason);
    }

    public static InventoryViewer.Validator hasItemStack(BiPredicate<class_1799, class_1263> itemStackPredicate, @Nullable FailureReason failureReason) {
        return InventoryValidators.hasItemStack(itemStackPredicate, null, failureReason);
    }

    public static InventoryViewer.Validator hasItemStack(BiPredicate<class_1799, class_1263> itemStackPredicate, @Nullable BiFunction<class_1799, class_1263, class_1799> itemStackModifier, @Nullable FailureReason failureReason) {
        if (failureReason == null) {
            failureReason = FailureReason.OTHER_PROBLEM;
        }
        FailureReason finalFailureReason = failureReason;
        return (__, ___, ____, inventory) -> {
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (!itemStackPredicate.test(stack, inventory)) continue;
                if (itemStackModifier != null) {
                    stack = (class_1799)itemStackModifier.apply(stack, inventory);
                    inventory.method_5447(i, stack);
                }
                return null;
            }
            return finalFailureReason;
        };
    }

    private InventoryValidators() {
    }
}

