/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.inventory;

import dev.kir.packedinventory.api.v1.inventory.InventoryViewHandler;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewHandlerRegistryImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import org.jetbrains.annotations.ApiStatus;

public interface InventoryViewHandlerRegistry {
    @ApiStatus.Internal
    public static InventoryViewHandlerRegistry getInstance() {
        return InventoryViewHandlerRegistryImpl.INSTANCE;
    }

    public boolean handle(class_1263 var1, class_1263 var2, int var3, class_1657 var4);

    public Entry register(Entry var1);

    default public Entry register(final InventoryViewHandler handler, final InventoryViewHandler.Predicate predicate) {
        return this.register(new Entry(){

            @Override
            public InventoryViewHandler getHandler() {
                return handler;
            }

            @Override
            public InventoryViewHandler.Predicate getPredicate() {
                return predicate;
            }
        });
    }

    default public Entry register(InventoryViewHandler handler, class_1792 item) {
        return this.register(handler, List.of(item));
    }

    default public Entry register(InventoryViewHandler handler, class_1792 ... items) {
        return this.register(handler, Arrays.asList(items));
    }

    default public Entry register(InventoryViewHandler handler, Collection<class_1792> items) {
        return this.register(handler, InventoryViewHandler.ItemPredicate.of(items));
    }

    default public Entry registerDefault(InventoryViewHandler handler) {
        return this.register(handler, InventoryViewHandler.Predicate.TRUE);
    }

    public boolean unregister(InventoryViewHandler var1);

    default public boolean unregister(Entry entry) {
        return this.unregister(entry.getHandler());
    }

    public static interface Entry {
        public InventoryViewHandler getHandler();

        public InventoryViewHandler.Predicate getPredicate();
    }
}

