/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.inventory;

import dev.kir.packedinventory.api.v1.inventory.InventoryViewHandler;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewHandlerRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

final class InventoryViewHandlerRegistryImpl
implements InventoryViewHandlerRegistry {
    public static final InventoryViewHandlerRegistryImpl INSTANCE = new InventoryViewHandlerRegistryImpl();
    private final Map<class_1792, InventoryViewHandlerRegistry.Entry> itemBasedHandlers = new HashMap<class_1792, InventoryViewHandlerRegistry.Entry>();
    private final Set<InventoryViewHandlerRegistry.Entry> genericHandlersSet = new HashSet<InventoryViewHandlerRegistry.Entry>();
    private final Deque<InventoryViewHandlerRegistry.Entry> genericHandlers = new ArrayDeque<InventoryViewHandlerRegistry.Entry>();
    @Nullable
    private InventoryViewHandlerRegistry.Entry defaultHandler = null;

    InventoryViewHandlerRegistryImpl() {
    }

    @Override
    public boolean handle(class_1263 inventory, class_1263 parentInventory, int slot, class_1657 player) {
        InventoryViewHandlerRegistry.Entry handlerEntry = this.findHandler(inventory, parentInventory, slot, player);
        if (handlerEntry == null) {
            return false;
        }
        handlerEntry.getHandler().handle(inventory, parentInventory, slot, player);
        return true;
    }

    @Nullable
    private InventoryViewHandlerRegistry.Entry findHandler(class_1263 inventory, class_1263 parentInventory, int slot, class_1657 player) {
        InventoryViewHandlerRegistry.Entry entry = this.itemBasedHandlers.get(parentInventory.method_5438(slot).method_7909());
        if (entry != null && entry.getPredicate().test(inventory, parentInventory, slot, player)) {
            return entry;
        }
        for (InventoryViewHandlerRegistry.Entry genericEntry : this.genericHandlers) {
            if (!genericEntry.getPredicate().test(inventory, parentInventory, slot, player)) continue;
            return genericEntry;
        }
        return this.defaultHandler;
    }

    @Override
    public InventoryViewHandlerRegistry.Entry register(InventoryViewHandlerRegistry.Entry entry) {
        if (entry.getPredicate() instanceof InventoryViewHandler.ItemPredicate) {
            for (class_1792 item : ((InventoryViewHandler.ItemPredicate)entry.getPredicate()).getItems()) {
                this.itemBasedHandlers.put(item, entry);
            }
        } else if (this.genericHandlersSet.add(entry)) {
            this.genericHandlers.push(entry);
        }
        return entry;
    }

    @Override
    public InventoryViewHandlerRegistry.Entry register(InventoryViewHandler handler, Collection<class_1792> items) {
        return this.register(handler, InventoryViewHandler.ItemPredicate.of(items, InventoryViewHandler.Predicate.TRUE));
    }

    @Override
    public InventoryViewHandlerRegistry.Entry registerDefault(final InventoryViewHandler handler) {
        this.defaultHandler = new InventoryViewHandlerRegistry.Entry(){

            @Override
            public InventoryViewHandler getHandler() {
                return handler;
            }

            @Override
            public InventoryViewHandler.Predicate getPredicate() {
                return InventoryViewHandler.Predicate.TRUE;
            }
        };
        return this.defaultHandler;
    }

    @Override
    public boolean unregister(InventoryViewHandler handler) {
        boolean removed = this.itemBasedHandlers.entrySet().removeIf(x -> ((InventoryViewHandlerRegistry.Entry)x.getValue()).getHandler() == handler);
        removed |= this.genericHandlersSet.removeIf(x -> x.getHandler() == handler) && this.genericHandlers.removeIf(x -> x.getHandler() == handler);
        if (this.defaultHandler != null && this.defaultHandler.getHandler() == handler) {
            this.defaultHandler = null;
            removed = true;
        }
        return removed;
    }
}

